/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzewu;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

public final class zzewz {
    private zzewu zzohv;
    private Exception zzksh;
    private int zzohw;
    private Exception zzohx;

    public zzewz(@NonNull zzewu zzewu2) {
        this.zzohv = zzewu2;
    }

    public final void zzbq(String string, String string2) {
        try {
            this.zzohv.zzbq(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string3.length() != 0 ? "Caught remote exception setting custom header:".concat(string3) : new String("Caught remote exception setting custom header:")), (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final String zzry(String string) {
        try {
            return this.zzohv.zzry(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public final void zze(@Nullable String string, @NonNull Context context) {
        try {
            boolean bl;
            Context context2 = context;
            zzewz zzewz2 = this;
            NetworkInfo networkInfo = ((ConnectivityManager)context2.getSystemService("connectivity")).getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                zzewz2.zzohw = -2;
                zzewz2.zzohx = new SocketException("Network subsystem is unavailable");
                bl = false;
            } else {
                bl = true;
            }
            if (!bl) {
                return;
            }
            this.zzohv.zzrw(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzksh = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequest failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void reset() {
        try {
            this.zzohw = 0;
            this.zzohx = null;
            this.zzohv.reset();
            return;
        }
        catch (RemoteException remoteException) {
            this.zzksh = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"reset failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void zzrx(@Nullable String string) {
        try {
            this.zzohv.zzrx(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzksh = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestStart failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void zzckh() {
        try {
            if (this.zzohv != null) {
                this.zzohv.zzckh();
            }
            return;
        }
        catch (RemoteException remoteException) {
            this.zzksh = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestEnd failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final InputStream getStream() {
        try {
            return (InputStream)zzn.zzx((IObjectWrapper)this.zzohv.zzcki());
        }
        catch (RemoteException remoteException) {
            this.zzksh = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getStream failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @NonNull
    public final JSONObject zzckp() throws RemoteException {
        return (JSONObject)zzn.zzx((IObjectWrapper)this.zzohv.zzckj());
    }

    @Nullable
    public final String zzckk() {
        try {
            this.zzohv.zzckk();
        }
        catch (RemoteException remoteException) {
            this.zzksh = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getRawResult failed with a RemoteException:", (Throwable)remoteException);
        }
        return null;
    }

    @Nullable
    public final Exception getException() {
        try {
            if (this.zzohx != null) {
                return this.zzohx;
            }
            if (this.zzksh != null) {
                return this.zzksh;
            }
            return (Exception)zzn.zzx((IObjectWrapper)this.zzohv.zzckl());
        }
        catch (RemoteException remoteException) {
            this.zzksh = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getException failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    public final int getResultCode() {
        try {
            if (this.zzohw != 0) {
                return this.zzohw;
            }
            return this.zzohv.getResultCode();
        }
        catch (RemoteException remoteException) {
            this.zzksh = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultCode failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }

    public final boolean zzckm() {
        try {
            if (this.zzohw == -2 || this.zzohx != null) {
                return false;
            }
            return this.zzohv.zzckm();
        }
        catch (RemoteException remoteException) {
            this.zzksh = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"isResultSuccess failed with a RemoteException:", (Throwable)remoteException);
            return false;
        }
    }

    public final <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.getException();
        if (this.zzckm() && exception == null) {
            taskCompletionSource.setResult(TResult);
            return;
        }
        StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
        taskCompletionSource.setException((Exception)((Object)storageException));
    }

    public final int zzckn() {
        try {
            return this.zzohv.zzckn();
        }
        catch (RemoteException remoteException) {
            this.zzksh = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultingContentLength failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }
}

