/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.CancellableTask;
import com.google.firebase.storage.ControllableTask;
import com.google.firebase.storage.OnPausedListener;
import com.google.firebase.storage.OnProgressListener;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzi;
import com.google.firebase.storage.zzj;
import com.google.firebase.storage.zzk;
import com.google.firebase.storage.zzl;
import com.google.firebase.storage.zzm;
import com.google.firebase.storage.zzn;
import com.google.firebase.storage.zzo;
import com.google.firebase.storage.zzr;
import com.google.firebase.storage.zzs;
import com.google.firebase.storage.zzw;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executor;

public abstract class StorageTask<TResult extends ProvideError>
extends ControllableTask<TResult> {
    private static final HashMap<Integer, HashSet<Integer>> zzofd = new HashMap();
    private static final HashMap<Integer, HashSet<Integer>> zzofe = new HashMap();
    protected final Object mSyncObject = new Object();
    @VisibleForTesting
    private zzw<OnSuccessListener<? super TResult>, TResult> zzoff = new zzw(this, 128, new zzi(this));
    @VisibleForTesting
    private zzw<OnFailureListener, TResult> zzofg = new zzw(this, 320, new zzj(this));
    @VisibleForTesting
    private zzw<OnCompleteListener<TResult>, TResult> zzofh = new zzw(this, 448, new zzk(this));
    @VisibleForTesting
    private zzw<OnProgressListener<? super TResult>, TResult> zzofi = new zzw(this, -465, new zzl(this));
    @VisibleForTesting
    private zzw<OnPausedListener<? super TResult>, TResult> zzofj = new zzw(this, 16, new zzm(this));
    private volatile int zzddl = 1;
    private TResult zzofk;

    protected StorageTask() {
    }

    @VisibleForTesting
    final boolean zzcjs() {
        if (this.zzk(2, false)) {
            this.schedule();
            return true;
        }
        return false;
    }

    @VisibleForTesting
    void resetState() {
    }

    @VisibleForTesting
    abstract StorageReference getStorage();

    @VisibleForTesting
    abstract void schedule();

    @Override
    public boolean resume() {
        if (this.zzk(2, true)) {
            this.resetState();
            this.schedule();
            return true;
        }
        return false;
    }

    @Override
    public boolean pause() {
        return this.zza(new int[]{16, 8}, true);
    }

    @Override
    public boolean cancel() {
        return this.zza(new int[]{256, 32}, true);
    }

    public boolean isComplete() {
        return (this.zzddl & 0x80) != 0 || (this.zzddl & 0x140) != 0;
    }

    public boolean isSuccessful() {
        return (this.zzddl & 0x80) != 0;
    }

    @Override
    public boolean isCanceled() {
        return this.zzddl == 256;
    }

    @Override
    public boolean isInProgress() {
        return (this.zzddl & 0xFFFFFE2F) != 0;
    }

    @Override
    public boolean isPaused() {
        return (this.zzddl & 0x10) != 0;
    }

    public TResult getResult() {
        if (this.zzcjv() == null) {
            throw new IllegalStateException();
        }
        Exception exception = this.zzcjv().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.zzcjv();
    }

    public <X extends Throwable> TResult getResult(@NonNull Class<X> clazz) throws X {
        if (this.zzcjv() == null) {
            throw new IllegalStateException();
        }
        if (clazz.isInstance(this.zzcjv().getError())) {
            throw (Throwable)clazz.cast(this.zzcjv().getError());
        }
        Exception exception = this.zzcjv().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.zzcjv();
    }

    @Nullable
    public Exception getException() {
        if (this.zzcjv() == null) {
            return null;
        }
        return this.zzcjv().getError();
    }

    public TResult getSnapshot() {
        return this.zzcju();
    }

    @VisibleForTesting
    final int zzcjt() {
        return this.zzddl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @VisibleForTesting
    final TResult zzcju() {
        Object object = this.mSyncObject;
        synchronized (object) {
            return this.zzcjo();
        }
    }

    @NonNull
    @VisibleForTesting
    abstract TResult zzcjo();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final boolean zza(int[] nArray, boolean bl) {
        HashMap<Integer, HashSet<Integer>> hashMap = bl ? zzofd : zzofe;
        Object object = this.mSyncObject;
        synchronized (object) {
            Object object2 = nArray;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = object2[i];
                HashSet<Integer> hashSet = hashMap.get(this.zzddl);
                if (hashSet == null || !hashSet.contains(n2)) continue;
                this.zzddl = n2;
                switch (this.zzddl) {
                    case 2: {
                        zzs.zzcjx().zzb(this);
                        this.onQueued();
                        break;
                    }
                    case 4: {
                        this.onProgress();
                        break;
                    }
                    case 16: {
                        this.onPaused();
                        break;
                    }
                    case 64: {
                        this.onFailure();
                        break;
                    }
                    case 128: {
                        this.onSuccess();
                        break;
                    }
                    case 256: {
                        this.onCanceled();
                    }
                }
                this.zzoff.zzckb();
                this.zzofg.zzckb();
                this.zzofh.zzckb();
                this.zzofj.zzckb();
                this.zzofi.zzckb();
                if (Log.isLoggable((String)"StorageTask", (int)3)) {
                    String string = StorageTask.zzia(n2);
                    String string2 = StorageTask.zzia(this.zzddl);
                    Log.d((String)"StorageTask", (String)new StringBuilder(53 + String.valueOf(string).length() + String.valueOf(string2).length()).append("changed internal state to: ").append(string).append(" isUser: ").append(bl).append(" from state:").append(string2).toString());
                }
                return true;
            }
            object2 = StorageTask.zzk(nArray);
            String string = StorageTask.zzia(this.zzddl);
            Log.w((String)"StorageTask", (String)new StringBuilder(62 + String.valueOf(object2).length() + String.valueOf(string).length()).append("unable to change internal state to: ").append((String)object2).append(" isUser: ").append(bl).append(" from state:").append(string).toString());
            return false;
        }
    }

    @VisibleForTesting
    final boolean zzk(int n, boolean bl) {
        return this.zza(new int[]{n}, bl);
    }

    protected void onQueued() {
    }

    protected void onProgress() {
    }

    protected void onPaused() {
    }

    protected void onFailure() {
    }

    protected void onSuccess() {
    }

    protected void onCanceled() {
    }

    private final TResult zzcjv() {
        if (this.zzofk != null) {
            return this.zzofk;
        }
        if (!this.isComplete()) {
            return null;
        }
        if (this.zzofk == null) {
            this.zzofk = this.zzcju();
        }
        return this.zzofk;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbq.checkNotNull(onPausedListener);
        this.zzofj.zza(null, null, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Executor executor, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbq.checkNotNull(onPausedListener);
        zzbq.checkNotNull((Object)executor);
        this.zzofj.zza(null, executor, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Activity activity, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbq.checkNotNull(onPausedListener);
        zzbq.checkNotNull((Object)activity);
        this.zzofj.zza(activity, null, onPausedListener);
        return this;
    }

    public StorageTask<TResult> removeOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbq.checkNotNull(onPausedListener);
        this.zzofj.zzci(onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbq.checkNotNull(onProgressListener);
        this.zzofi.zza(null, null, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Executor executor, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbq.checkNotNull(onProgressListener);
        zzbq.checkNotNull((Object)executor);
        this.zzofi.zza(null, executor, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Activity activity, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbq.checkNotNull(onProgressListener);
        zzbq.checkNotNull((Object)activity);
        this.zzofi.zza(activity, null, onProgressListener);
        return this;
    }

    public StorageTask<TResult> removeOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbq.checkNotNull(onProgressListener);
        this.zzofi.zzci(onProgressListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbq.checkNotNull(onSuccessListener);
        this.zzoff.zza(null, null, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbq.checkNotNull((Object)executor);
        zzbq.checkNotNull(onSuccessListener);
        this.zzoff.zza(null, executor, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Activity activity, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbq.checkNotNull((Object)activity);
        zzbq.checkNotNull(onSuccessListener);
        this.zzoff.zza(activity, null, onSuccessListener);
        return this;
    }

    public StorageTask<TResult> removeOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbq.checkNotNull(onSuccessListener);
        this.zzoff.zzci(onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzbq.checkNotNull((Object)onFailureListener);
        this.zzofg.zza(null, null, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener onFailureListener) {
        zzbq.checkNotNull((Object)onFailureListener);
        zzbq.checkNotNull((Object)executor);
        this.zzofg.zza(null, executor, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Activity activity, @NonNull OnFailureListener onFailureListener) {
        zzbq.checkNotNull((Object)onFailureListener);
        zzbq.checkNotNull((Object)activity);
        this.zzofg.zza(activity, null, onFailureListener);
        return this;
    }

    public StorageTask<TResult> removeOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzbq.checkNotNull((Object)onFailureListener);
        this.zzofg.zzci(onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbq.checkNotNull(onCompleteListener);
        this.zzofh.zza(null, null, onCompleteListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull Executor executor, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbq.checkNotNull(onCompleteListener);
        zzbq.checkNotNull((Object)executor);
        this.zzofh.zza(null, executor, onCompleteListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull Activity activity, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbq.checkNotNull(onCompleteListener);
        zzbq.checkNotNull((Object)activity);
        this.zzofh.zza(activity, null, onCompleteListener);
        return this;
    }

    public StorageTask<TResult> removeOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbq.checkNotNull(onCompleteListener);
        this.zzofh.zzci(onCompleteListener);
        return this;
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.zza(null, continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.zza(executor, continuation);
    }

    @NonNull
    private final <TContinuationResult> Task<TContinuationResult> zza(@Nullable Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzofh.zza(null, executor, new zzn(this, continuation, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.zzb(null, continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.zzb(executor, continuation);
    }

    @NonNull
    private final <TContinuationResult> Task<TContinuationResult> zzb(@Nullable Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzofh.zza(null, executor, new zzo(this, continuation, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @VisibleForTesting
    abstract void run();

    @VisibleForTesting
    final Runnable zzbkc() {
        return new zzr(this);
    }

    private final void zzcjw() {
        if (!(this.isComplete() || ((ControllableTask)this).isPaused() || this.zzddl == 2 || this.zzk(256, false))) {
            this.zzk(64, false);
        }
    }

    private static String zzk(int[] nArray) {
        if (nArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            stringBuilder.append(StorageTask.zzia(n2)).append(", ");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2);
    }

    private static String zzia(int n) {
        switch (n) {
            case 1: {
                return "INTERNAL_STATE_NOT_STARTED";
            }
            case 2: {
                return "INTERNAL_STATE_QUEUED";
            }
            case 4: {
                return "INTERNAL_STATE_IN_PROGRESS";
            }
            case 8: {
                return "INTERNAL_STATE_PAUSING";
            }
            case 16: {
                return "INTERNAL_STATE_PAUSED";
            }
            case 32: {
                return "INTERNAL_STATE_CANCELING";
            }
            case 64: {
                return "INTERNAL_STATE_FAILURE";
            }
            case 128: {
                return "INTERNAL_STATE_SUCCESS";
            }
            case 256: {
                return "INTERNAL_STATE_CANCELED";
            }
        }
        return "Unknown Internal State!";
    }

    static /* synthetic */ void zza(StorageTask storageTask) {
        storageTask.zzcjw();
    }

    static {
        zzofd.put(1, new HashSet<Integer>(Arrays.asList(16, 256)));
        zzofd.put(2, new HashSet<Integer>(Arrays.asList(8, 32)));
        zzofd.put(4, new HashSet<Integer>(Arrays.asList(8, 32)));
        zzofd.put(16, new HashSet<Integer>(Arrays.asList(2, 256)));
        zzofd.put(64, new HashSet<Integer>(Arrays.asList(2, 256)));
        zzofe.put(1, new HashSet<Integer>(Arrays.asList(2, 64)));
        zzofe.put(2, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        zzofe.put(4, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        zzofe.put(8, new HashSet<Integer>(Arrays.asList(16, 64, 128)));
        zzofe.put(32, new HashSet<Integer>(Arrays.asList(256, 64, 128)));
    }

    public class SnapshotBase
    implements ProvideError {
        private final Exception zzofo;
        private /* synthetic */ StorageTask zzofl;

        public SnapshotBase(StorageTask storageTask, Exception exception) {
            this.zzofl = storageTask;
            if (exception == null) {
                if (((CancellableTask)storageTask).isCanceled()) {
                    this.zzofo = StorageException.fromErrorStatus(Status.zzflc);
                    return;
                }
                if (storageTask.zzcjt() == 64) {
                    this.zzofo = StorageException.fromErrorStatus(Status.zzfla);
                    return;
                }
                this.zzofo = null;
                return;
            }
            this.zzofo = exception;
        }

        @NonNull
        public StorageTask<TResult> getTask() {
            return this.zzofl;
        }

        @NonNull
        public StorageReference getStorage() {
            return this.getTask().getStorage();
        }

        @Override
        @Nullable
        public Exception getError() {
            return this.zzofo;
        }
    }

    public static interface ProvideError {
        public Exception getError();
    }
}

