/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;

public final class zzewf {
    private static final Runtime zzogw = Runtime.getRuntime();
    private final InputStream zzogx;
    private byte[] buffer;
    private int zzogy;
    private boolean zzogz;
    private boolean zzoha;

    public zzewf(InputStream inputStream, int n) {
        this.zzogx = inputStream;
        this.buffer = new byte[262144];
        this.zzogy = 0;
        this.zzoha = true;
        this.zzogz = false;
    }

    public final int available() {
        return this.zzogy;
    }

    public final byte[] zzckf() {
        return this.buffer;
    }

    public final int zzia(int n) throws IOException {
        int n2;
        if (n <= this.zzogy) {
            this.zzogy -= n;
            System.arraycopy(this.buffer, n, this.buffer, 0, this.zzogy);
            n2 = n;
        } else {
            n2 = this.zzogy = 0;
            while (n2 < n) {
                long l = this.zzogx.skip(n - n2);
                if (l > 0L) {
                    n2 = (int)((long)n2 + l);
                    continue;
                }
                if (l != 0L) continue;
                if (this.zzogx.read() == -1) break;
                ++n2;
            }
        }
        return n2;
    }

    public final int zzib(int n) throws IOException {
        if (n > this.buffer.length) {
            n = Math.min(n, this.zzic(n));
        }
        while (this.zzogy < n) {
            int n2 = this.zzogx.read(this.buffer, this.zzogy, n - this.zzogy);
            if (n2 == -1) {
                this.zzogz = true;
                break;
            }
            this.zzogy += n2;
        }
        return this.zzogy;
    }

    private final int zzic(int n) {
        int n2 = Math.max(this.buffer.length << 1, n);
        long l = zzogw.totalMemory() - zzogw.freeMemory();
        long l2 = zzogw.maxMemory() - l;
        if (this.zzoha && (long)n2 < l2) {
            try {
                byte[] byArray = new byte[n2];
                System.arraycopy(this.buffer, 0, byArray, 0, this.zzogy);
                this.buffer = byArray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing due to low memory.");
                this.zzoha = false;
            }
        } else {
            Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing to conserve memory.");
        }
        return this.buffer.length;
    }

    public final boolean isFinished() {
        return this.zzogz;
    }

    public final void close() throws IOException {
        this.zzogx.close();
    }
}

