/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.Uri;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.zzewo;
import com.google.android.gms.internal.zzewp;
import com.google.android.gms.internal.zzewr;
import com.google.firebase.FirebaseApp;
import org.json.JSONObject;

public final class zzewq {
    private static DynamiteModule.zzd zzohd = DynamiteModule.zzgug;
    private static final Object zzohe = new Object();
    private static volatile zzewq zzohf;
    private zzewo zzohg;
    private Context mContext;
    private FirebaseApp zzodh;

    private zzewq(@NonNull FirebaseApp firebaseApp) throws RemoteException {
        this.mContext = firebaseApp.getApplicationContext();
        this.zzodh = firebaseApp;
        try {
            IInterface iInterface;
            DynamiteModule dynamiteModule = DynamiteModule.zza((Context)this.mContext, (DynamiteModule.zzd)zzohd, (String)"com.google.android.gms.firebasestorage");
            IBinder iBinder = dynamiteModule.zzgw("com.google.firebase.storage.network.NetworkRequestFactoryImpl");
            this.zzohg = iBinder == null ? null : ((iInterface = iBinder.queryLocalInterface("com.google.firebase.storage.network.INetworkRequestFactory")) instanceof zzewo ? (zzewo)iInterface : new zzewp(iBinder));
        }
        catch (DynamiteModule.zzc zzc2) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"NetworkRequestFactoryProxy failed with a RemoteException:", (Throwable)zzc2);
            throw new RemoteException();
        }
        if (this.zzohg == null) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"Unable to load Firebase Storage Network layer.");
            throw new RemoteException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzewq zzh(@NonNull FirebaseApp firebaseApp) throws RemoteException {
        if (zzohf == null) {
            Object object = zzohe;
            synchronized (object) {
                if (zzohf == null) {
                    zzohf = new zzewq(firebaseApp);
                }
            }
        }
        return zzohf;
    }

    private final zzewr zze(zzewr zzewr2) {
        zzewr2.zzbq("x-firebase-gmpid", this.zzodh.getOptions().getApplicationId());
        return zzewr2;
    }

    @NonNull
    public final zzewr zzv(Uri uri) throws RemoteException {
        return this.zze(new zzewr(this.zzohg.zza(uri, zzn.zzy((Object)this.mContext))));
    }

    @NonNull
    public final zzewr zzw(Uri uri) throws RemoteException {
        return this.zze(new zzewr(this.zzohg.zzb(uri, zzn.zzy((Object)this.mContext))));
    }

    @NonNull
    public final zzewr zza(Uri uri, long l) throws RemoteException {
        return this.zze(new zzewr(this.zzohg.zza(uri, zzn.zzy((Object)this.mContext), l)));
    }

    @NonNull
    public final zzewr zza(Uri uri, String string, byte[] byArray, long l, int n, boolean bl) throws RemoteException {
        return this.zze(new zzewr(this.zzohg.zza(uri, zzn.zzy((Object)this.mContext), string, zzn.zzy((Object)byArray), l, n, bl)));
    }

    @Nullable
    public final zzewr zza(Uri uri, String string) throws RemoteException {
        return this.zze(new zzewr(this.zzohg.zza(uri, zzn.zzy((Object)this.mContext), string)));
    }

    @NonNull
    public final zzewr zzb(Uri uri, String string) throws RemoteException {
        return this.zze(new zzewr(this.zzohg.zzb(uri, zzn.zzy((Object)this.mContext), string)));
    }

    @NonNull
    public final zzewr zza(Uri uri, JSONObject jSONObject, String string) throws RemoteException {
        return this.zze(new zzewr(this.zzohg.zza(uri, zzn.zzy((Object)this.mContext), zzn.zzy((Object)jSONObject), string)));
    }

    @NonNull
    public final zzewr zza(Uri uri, JSONObject jSONObject) throws RemoteException {
        return this.zze(new zzewr(this.zzohg.zza(uri, zzn.zzy((Object)this.mContext), zzn.zzy((Object)jSONObject))));
    }

    @Nullable
    public final String zzckn() {
        try {
            return this.zzohg.zzckn();
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"getBackendAuthority failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @Nullable
    public final String zzu(Uri uri) {
        try {
            return this.zzohg.zzu(uri);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"getDefaultURL failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }
}

