/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzewg;
import com.google.android.gms.internal.zzewr;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzu;
import com.google.firebase.storage.zzw;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference zzocy;
    private zzewg zzoda;
    private volatile Exception zzkrx = null;
    private volatile int mResultCode = 0;
    private StreamProcessor zzofm;
    private long zzgjh = -1L;
    private long zzodc;
    private long zzofn;
    private InputStream zzlgf;
    private zzewr zzofo;
    private String zzodd;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.zzocy = storageReference;
        this.zzoda = new zzewg(this.zzocy.getStorage().getApp(), this.zzocy.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzbq.checkNotNull((Object)streamProcessor);
        zzbq.checkState((this.zzofm == null ? 1 : 0) != 0);
        this.zzofm = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zzocy;
    }

    final long getTotalBytes() {
        return this.zzgjh;
    }

    final void zzco(long l) {
        this.zzodc += l;
        if (this.zzofn + 262144L <= this.zzodc) {
            if (this.zzcjs() == 4) {
                this.zzk(4, false);
                return;
            }
            this.zzofn = this.zzodc;
        }
    }

    @Override
    protected void schedule() {
        zzu.zzu(this.zzbkb());
    }

    private final InputStream zzcjx() throws Exception {
        this.zzoda.reset();
        if (this.zzofo != null) {
            this.zzofo.zzckg();
        }
        try {
            this.zzofo = this.zzocy.zzcjp().zza(this.zzocy.zzcjq(), this.zzodc);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            throw remoteException;
        }
        this.zzoda.zza(this.zzofo, false);
        this.mResultCode = this.zzofo.getResultCode();
        this.zzkrx = this.zzofo.getException() != null ? this.zzofo.getException() : this.zzkrx;
        int n = this.mResultCode;
        if ((n == 308 || n >= 200 && n < 300) && this.zzkrx == null && this.zzcjs() == 4) {
            String string = this.zzofo.zzrx("ETag");
            if (!TextUtils.isEmpty((CharSequence)string) && this.zzodd != null && !this.zzodd.equals(string)) {
                this.mResultCode = 409;
                throw new IOException("The ETag on the server changed.");
            }
            this.zzodd = string;
            if (this.zzgjh == -1L) {
                this.zzgjh = this.zzofo.zzckm();
            }
            return this.zzofo.getStream();
        }
        throw new IOException("Could not open resulting stream.");
    }

    @Override
    final void run() {
        if (this.zzkrx != null) {
            this.zzk(64, false);
            return;
        }
        if (!this.zzk(4, false)) {
            return;
        }
        zza zza2 = new zza(new zzw(this), this);
        this.zzlgf = new BufferedInputStream(zza2);
        try {
            zza2.zzcjz();
            if (this.zzofm != null) {
                try {
                    this.zzofm.doInBackground((TaskSnapshot)this.zzcjt(), this.zzlgf);
                }
                catch (Exception exception) {
                    Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                    this.zzkrx = exception;
                }
            }
        }
        catch (IOException iOException) {
            Log.d((String)"StreamDownloadTask", (String)"Initial opening of Stream failed", (Throwable)iOException);
            this.zzkrx = iOException;
        }
        if (this.zzlgf == null) {
            this.zzofo.zzckg();
            this.zzofo = null;
        }
        if (this.zzkrx == null && this.zzcjs() == 4) {
            this.zzk(4, false);
            this.zzk(128, false);
            return;
        }
        if (!this.zzk(this.zzcjs() == 32 ? 256 : 64, false)) {
            int n = this.zzcjs();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    protected void onCanceled() {
        this.zzoda.cancel();
        this.zzkrx = StorageException.fromErrorStatus(Status.zzfks);
    }

    @Override
    protected void onProgress() {
        this.zzofn = this.zzodc;
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzcjm() {
        StreamDownloadTask streamDownloadTask = this;
        return new TaskSnapshot(streamDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(streamDownloadTask.zzkrx, streamDownloadTask.mResultCode)), streamDownloadTask.zzofn);
    }

    static /* synthetic */ InputStream zza(StreamDownloadTask streamDownloadTask) throws Exception {
        return streamDownloadTask.zzcjx();
    }

    static /* synthetic */ zzewr zza(StreamDownloadTask streamDownloadTask, zzewr zzewr2) {
        streamDownloadTask.zzofo = null;
        return null;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzodc;
        private /* synthetic */ StreamDownloadTask zzofp;

        TaskSnapshot(@Nullable StreamDownloadTask streamDownloadTask, Exception exception, long l) {
            this.zzofp = streamDownloadTask;
            super(streamDownloadTask, exception);
            this.zzodc = l;
        }

        public long getBytesTransferred() {
            return this.zzodc;
        }

        public long getTotalByteCount() {
            return this.zzofp.getTotalBytes();
        }

        public InputStream getStream() {
            return this.zzofp.zzlgf;
        }
    }

    static final class zza
    extends InputStream {
        @Nullable
        private StreamDownloadTask zzofq;
        @Nullable
        private InputStream zzofr;
        private Callable<InputStream> zzofs;
        private IOException zzoft;
        private int zzofu;
        private int zzofv;
        private boolean zzofw;

        zza(@NonNull Callable<InputStream> callable, @Nullable StreamDownloadTask streamDownloadTask) {
            this.zzofq = streamDownloadTask;
            this.zzofs = callable;
        }

        private final void zzcjy() throws IOException {
            if (this.zzofq != null && this.zzofq.zzcjs() == 32) {
                throw new com.google.firebase.storage.zza();
            }
        }

        private final void zzco(long l) {
            if (this.zzofq != null) {
                this.zzofq.zzco(l);
            }
            this.zzofu = (int)((long)this.zzofu + l);
        }

        private final boolean zzcjz() throws IOException {
            this.zzcjy();
            if (this.zzoft != null) {
                try {
                    if (this.zzofr != null) {
                        this.zzofr.close();
                    }
                }
                catch (IOException iOException) {}
                this.zzofr = null;
                if (this.zzofv == this.zzofu) {
                    Log.i((String)"StreamDownloadTask", (String)"Encountered exception during stream operation. Aborting.", (Throwable)this.zzoft);
                    return false;
                }
                int n = this.zzofu;
                Log.i((String)"StreamDownloadTask", (String)new StringBuilder(70).append("Encountered exception during stream operation. Retrying at ").append(n).toString(), (Throwable)this.zzoft);
                this.zzofv = this.zzofu;
                this.zzoft = null;
            }
            if (this.zzofw) {
                throw new IOException("Can't perform operation on closed stream");
            }
            if (this.zzofr == null) {
                try {
                    this.zzofr = this.zzofs.call();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    if (exception instanceof IOException) {
                        throw (IOException)exception2;
                    }
                    throw new IOException("Unable to open stream", exception2);
                }
            }
            return true;
        }

        @Override
        public final int read() throws IOException {
            while (this.zzcjz()) {
                try {
                    int n = this.zzofr.read();
                    if (n != -1) {
                        this.zzco(1L);
                    }
                    return n;
                }
                catch (IOException iOException) {
                    this.zzoft = iOException;
                }
            }
            throw this.zzoft;
        }

        @Override
        public final int available() throws IOException {
            while (this.zzcjz()) {
                try {
                    return this.zzofr.available();
                }
                catch (IOException iOException) {
                    this.zzoft = iOException;
                }
            }
            throw this.zzoft;
        }

        @Override
        public final void close() throws IOException {
            if (this.zzofr != null) {
                this.zzofr.close();
            }
            this.zzofw = true;
            if (this.zzofq != null && this.zzofq.zzofo != null) {
                this.zzofq.zzofo.zzckg();
                StreamDownloadTask.zza(this.zzofq, null);
            }
            this.zzcjy();
        }

        @Override
        public final void mark(int n) {
        }

        @Override
        public final boolean markSupported() {
            return false;
        }

        @Override
        public final int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (this.zzcjz()) {
                try {
                    int n4;
                    while ((long)n2 > 262144L) {
                        n4 = this.zzofr.read(byArray, n, 262144);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        this.zzco(n4);
                        this.zzcjy();
                    }
                    if (n2 > 0) {
                        n4 = this.zzofr.read(byArray, n, n2);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n += n4;
                        n3 += n4;
                        n2 -= n4;
                        this.zzco(n4);
                    }
                    if (n2 != 0) continue;
                    return n3;
                }
                catch (IOException iOException) {
                    this.zzoft = iOException;
                }
            }
            throw this.zzoft;
        }

        @Override
        public final long skip(long l) throws IOException {
            int n = 0;
            while (this.zzcjz()) {
                try {
                    long l2;
                    while (l > 262144L) {
                        l2 = this.zzofr.skip(262144L);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzco(l2);
                        this.zzcjy();
                    }
                    if (l > 0L) {
                        l2 = this.zzofr.skip(l);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzco(l2);
                    }
                    if (l != 0L) continue;
                    return n;
                }
                catch (IOException iOException) {
                    this.zzoft = iOException;
                }
            }
            throw this.zzoft;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

