/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzewf;
import com.google.android.gms.internal.zzewg;
import com.google.android.gms.internal.zzewl;
import com.google.android.gms.internal.zzewr;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzad;
import com.google.firebase.storage.zzu;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference zzocy;
    private final Uri mUri;
    private final long zzogh;
    private final zzewf zzogi;
    private final AtomicLong zzogj;
    private int zzogk;
    private zzewg zzoda;
    private boolean zzogl;
    private volatile StorageMetadata zzoeg;
    private volatile Uri zzogm;
    private volatile Exception zzkrx;
    private volatile Exception zzogn;
    private volatile int mResultCode;
    private volatile String zzogo;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        this.zzogj = new AtomicLong(0L);
        this.zzogk = 262144;
        this.zzogm = null;
        this.zzkrx = null;
        this.zzogn = null;
        this.mResultCode = 0;
        zzbq.checkNotNull((Object)storageReference);
        zzbq.checkNotNull((Object)byArray);
        this.zzogh = byArray.length;
        this.zzocy = storageReference;
        this.zzoeg = storageMetadata;
        this.mUri = null;
        this.zzogi = new zzewf(new ByteArrayInputStream(byArray), 262144);
        this.zzogl = true;
        this.zzoda = new zzewg(this.zzocy.getStorage().getApp(), this.zzocy.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        long l;
        InputStream inputStream;
        block10: {
            this.zzogj = new AtomicLong(0L);
            this.zzogk = 262144;
            this.zzogm = null;
            this.zzkrx = null;
            this.zzogn = null;
            this.mResultCode = 0;
            zzbq.checkNotNull((Object)storageReference);
            zzbq.checkNotNull((Object)uri);
            this.zzocy = storageReference;
            this.zzoeg = storageMetadata;
            this.mUri = uri;
            inputStream = null;
            this.zzoda = new zzewg(this.zzocy.getStorage().getApp(), this.zzocy.getStorage().getMaxUploadRetryTimeMillis());
            l = -1L;
            try {
                ContentResolver contentResolver = this.zzocy.getStorage().getApp().getApplicationContext().getContentResolver();
                try {
                    ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.mUri, "r");
                    if (parcelFileDescriptor != null) {
                        l = parcelFileDescriptor.getStatSize();
                        parcelFileDescriptor.close();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                    l = -1L;
                }
                catch (IOException iOException) {
                    String string = String.valueOf(this.mUri.toString());
                    Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")), (Throwable)iOException);
                }
                inputStream = contentResolver.openInputStream(this.mUri);
                if (inputStream == null) break block10;
                if (l == -1L) {
                    try {
                        int n = inputStream.available();
                        if (n >= 0) {
                            l = n;
                        }
                    }
                    catch (IOException iOException) {}
                }
                inputStream = new BufferedInputStream(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = String.valueOf(this.mUri.toString());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
                this.zzkrx = fileNotFoundException;
            }
        }
        this.zzogh = l;
        this.zzogi = new zzewf(inputStream, 262144);
        this.zzogl = true;
        this.zzogm = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        this.zzogj = new AtomicLong(0L);
        this.zzogk = 262144;
        this.zzogm = null;
        this.zzkrx = null;
        this.zzogn = null;
        this.mResultCode = 0;
        zzbq.checkNotNull((Object)storageReference);
        zzbq.checkNotNull((Object)inputStream);
        this.zzogh = -1L;
        this.zzocy = storageReference;
        this.zzoeg = storageMetadata;
        this.zzogi = new zzewf(inputStream, 262144);
        this.zzogl = false;
        this.mUri = null;
        this.zzoda = new zzewg(this.zzocy.getStorage().getApp(), this.zzocy.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    final StorageReference getStorage() {
        return this.zzocy;
    }

    final long getTotalByteCount() {
        return this.zzogh;
    }

    @Override
    protected void schedule() {
        zzu.zzt(this.zzbkb());
    }

    @Override
    final void run() {
        zzewr zzewr2;
        UploadTask uploadTask;
        block24: {
            this.zzoda.reset();
            if (!this.zzk(4, false)) {
                Log.d((String)"UploadTask", (String)"The upload cannot continue as it is not in a valid state.");
                return;
            }
            if (this.zzocy.getParent() == null) {
                this.zzkrx = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
            }
            if (this.zzkrx != null) {
                return;
            }
            if (this.zzogm == null) {
                String string;
                uploadTask = this;
                String string2 = null;
                if (uploadTask.zzoeg != null) {
                    string2 = uploadTask.zzoeg.getContentType();
                }
                if (uploadTask.mUri != null && TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = uploadTask.zzocy.getStorage().getApp().getApplicationContext().getContentResolver().getType(uploadTask.mUri);
                }
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = "application/octet-stream";
                }
                try {
                    zzewr2 = uploadTask.zzocy.zzcjp().zza(uploadTask.zzocy.zzcjq(), uploadTask.zzoeg != null ? uploadTask.zzoeg.zzcjn() : null, string2);
                }
                catch (RemoteException | JSONException throwable) {
                    Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
                    uploadTask.zzkrx = throwable;
                    break block24;
                }
                if (uploadTask.zzc(zzewr2) && !TextUtils.isEmpty((CharSequence)(string = zzewr2.zzrx("X-Goog-Upload-URL")))) {
                    uploadTask.zzogm = Uri.parse((String)string);
                }
            } else {
                this.zzct(false);
            }
        }
        boolean bl = this.zzckb();
        while (bl) {
            block25: {
                uploadTask = this;
                try {
                    uploadTask.zzogi.zzib(uploadTask.zzogk);
                    int n = Math.min(uploadTask.zzogk, uploadTask.zzogi.available());
                    try {
                        zzewr2 = uploadTask.zzocy.zzcjp().zza(uploadTask.zzocy.zzcjq(), uploadTask.zzogm.toString(), uploadTask.zzogi.zzckf(), uploadTask.zzogj.get(), n, uploadTask.zzogi.isFinished());
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
                        uploadTask.zzkrx = remoteException;
                        break block25;
                    }
                    if (!uploadTask.zzb(zzewr2)) {
                        int n2 = uploadTask.zzogk = 262144;
                        Log.d((String)"UploadTask", (String)new StringBuilder(35).append("Resetting chunk size to ").append(n2).toString());
                        break block25;
                    }
                    uploadTask.zzogj.getAndAdd(n);
                    if (!uploadTask.zzogi.isFinished()) {
                        uploadTask.zzogi.zzia(n);
                        if (uploadTask.zzogk < 0x2000000) {
                            uploadTask.zzogk <<= 1;
                            int n3 = uploadTask.zzogk;
                            Log.d((String)"UploadTask", (String)new StringBuilder(36).append("Increasing chunk size to ").append(n3).toString());
                        }
                        break block25;
                    }
                    try {
                        uploadTask.zzoeg = new StorageMetadata.Builder(zzewr2.zzcko(), uploadTask.zzocy).build();
                    }
                    catch (RemoteException | JSONException throwable) {
                        String string = String.valueOf(zzewr2.zzckj());
                        Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                        uploadTask.zzkrx = throwable;
                        break block25;
                    }
                    uploadTask.zzk(4, false);
                    uploadTask.zzk(128, false);
                }
                catch (IOException iOException) {
                    Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
                    uploadTask.zzkrx = iOException;
                }
            }
            if (!(bl = this.zzckb())) continue;
            this.zzk(4, false);
        }
        if (this.zzogl && this.zzcjs() != 16) {
            try {
                this.zzogi.close();
                return;
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to close stream.", (Throwable)iOException);
            }
        }
    }

    @Override
    protected void resetState() {
        this.zzkrx = null;
        this.zzogn = null;
        this.mResultCode = 0;
        this.zzogo = null;
    }

    private final boolean zzckb() {
        if (this.zzcjs() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.zzkrx = new InterruptedException();
            this.zzk(64, false);
            return false;
        }
        if (this.zzcjs() == 32) {
            this.zzk(256, false);
            return false;
        }
        if (this.zzcjs() == 8) {
            this.zzk(16, false);
            return false;
        }
        if (!this.zzckc()) {
            return false;
        }
        if (this.zzogm == null) {
            if (this.zzkrx == null) {
                this.zzkrx = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zzk(64, false);
            return false;
        }
        if (this.zzkrx != null) {
            this.zzk(64, false);
            return false;
        }
        if ((this.zzogn != null || this.mResultCode < 200 || this.mResultCode >= 300) && !this.zzct(true)) {
            if (this.zzckc()) {
                this.zzk(64, false);
            }
            return false;
        }
        return true;
    }

    private final boolean zzckc() {
        if ("final".equals(this.zzogo)) {
            if (this.zzkrx == null) {
                this.zzkrx = new IOException("The server has terminated the upload session", this.zzogn);
            }
            this.zzk(64, false);
            return false;
        }
        return true;
    }

    private final boolean zzct(boolean bl) {
        zzewr zzewr2;
        try {
            zzewr2 = this.zzocy.zzcjp().zzb(this.zzocy.zzcjq(), this.zzogm.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.zzkrx = remoteException;
            return false;
        }
        if ("final".equals(this.zzogo)) {
            return false;
        }
        if (bl ? !this.zzc(zzewr2) : !this.zzb(zzewr2)) {
            return false;
        }
        if ("final".equals(zzewr2.zzrx("X-Goog-Upload-Status"))) {
            this.zzkrx = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = zzewr2.zzrx("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.zzogj.get();
        if (l2 > l) {
            this.zzkrx = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if ((long)this.zzogi.zzia((int)(l - l2)) != l - l2) {
                    this.zzkrx = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.zzogj.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.zzkrx = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.zzkrx = iOException;
                return false;
            }
        }
        return true;
    }

    private final boolean zzb(zzewr zzewr2) {
        zzewr2.zze(zzewl.zzg(this.zzocy.getStorage().getApp()), this.zzocy.getStorage().getApp().getApplicationContext());
        return this.zzd(zzewr2);
    }

    private final boolean zzc(zzewr zzewr2) {
        zzewr zzewr3 = zzewr2;
        this.zzoda.zza(zzewr3, true);
        return this.zzd(zzewr2);
    }

    private final boolean zzd(zzewr zzewr2) {
        int n = zzewr2.getResultCode();
        this.mResultCode = zzewg.zzid(n) ? -2 : n;
        this.zzogn = zzewr2.getException();
        this.zzogo = zzewr2.zzrx("X-Goog-Upload-Status");
        int n2 = this.mResultCode;
        return (n2 == 308 || n2 >= 200 && n2 < 300) && this.zzogn == null;
    }

    @Override
    protected void onCanceled() {
        this.zzoda.cancel();
        zzewr zzewr2 = null;
        if (this.zzogm != null) {
            try {
                zzewr2 = this.zzocy.zzcjp().zza(this.zzocy.zzcjq(), this.zzogm.toString());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            }
        }
        if (zzewr2 != null) {
            zzewr zzewr3 = zzewr2;
            zzu.zzs(new zzad(this, zzewr3));
        }
        this.zzkrx = StorageException.fromErrorStatus(Status.zzfks);
        super.onCanceled();
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzcjm() {
        UploadTask uploadTask = this;
        Exception exception = uploadTask.zzkrx != null ? uploadTask.zzkrx : uploadTask.zzogn;
        return new TaskSnapshot(uploadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, uploadTask.mResultCode)), uploadTask.zzogj.get(), uploadTask.zzogm, uploadTask.zzoeg);
    }

    static /* synthetic */ StorageReference zza(UploadTask uploadTask) {
        return uploadTask.zzocy;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzogr;
        private final Uri zzogm;
        private final StorageMetadata zzoeg;
        private /* synthetic */ UploadTask zzogq;

        TaskSnapshot(@Nullable UploadTask uploadTask, Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            this.zzogq = uploadTask;
            super(uploadTask, exception);
            this.zzogr = l;
            this.zzogm = uri;
            this.zzoeg = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.zzogr;
        }

        public long getTotalByteCount() {
            return this.zzogq.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.zzogm;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.zzoeg;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

