/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzewg;
import com.google.android.gms.internal.zzewq;
import com.google.android.gms.internal.zzewr;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import org.json.JSONException;

final class zzc
implements Runnable {
    private StorageReference zzocy;
    private TaskCompletionSource<StorageMetadata> zzocz;
    private StorageMetadata zzodm;
    private zzewg zzoda;

    public zzc(@NonNull StorageReference storageReference, @NonNull TaskCompletionSource<StorageMetadata> taskCompletionSource) {
        zzbq.checkNotNull((Object)storageReference);
        zzbq.checkNotNull(taskCompletionSource);
        this.zzocy = storageReference;
        this.zzocz = taskCompletionSource;
        this.zzoda = new zzewg(this.zzocy.getStorage().getApp(), this.zzocy.getStorage().getMaxOperationRetryTimeMillis());
    }

    @Override
    public final void run() {
        zzewr zzewr2;
        try {
            zzewr2 = zzewq.zzh(this.zzocy.getStorage().getApp()).zzw(this.zzocy.zzcjq());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"GetMetadataTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            this.zzocz.setException((Exception)((Object)StorageException.fromException(remoteException)));
            return;
        }
        zzewr zzewr3 = zzewr2;
        this.zzoda.zza(zzewr3, true);
        if (zzewr2.zzckl()) {
            try {
                this.zzodm = new StorageMetadata.Builder(zzewr2.zzcko(), this.zzocy).build();
            }
            catch (RemoteException | JSONException throwable) {
                String string = String.valueOf(zzewr2.zzckj());
                Log.e((String)"GetMetadataTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata. ".concat(string) : new String("Unable to parse resulting metadata. ")), (Throwable)throwable);
                this.zzocz.setException((Exception)((Object)StorageException.fromException(throwable)));
                return;
            }
        }
        if (this.zzocz != null) {
            zzewr2.zza(this.zzocz, this.zzodm);
        }
    }
}

