/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;

public final class zzexq {
    private static final Runtime zzolr = Runtime.getRuntime();
    private final InputStream zzols;
    private byte[] buffer;
    private int zzolt;
    private boolean zzolu;
    private boolean zzolv;

    public zzexq(InputStream inputStream, int n) {
        this.zzols = inputStream;
        this.buffer = new byte[262144];
        this.zzolt = 0;
        this.zzolv = true;
        this.zzolu = false;
    }

    public final int available() {
        return this.zzolt;
    }

    public final byte[] zzcmg() {
        return this.buffer;
    }

    public final int zzik(int n) throws IOException {
        int n2;
        if (n <= this.zzolt) {
            this.zzolt -= n;
            System.arraycopy(this.buffer, n, this.buffer, 0, this.zzolt);
            n2 = n;
        } else {
            n2 = this.zzolt = 0;
            while (n2 < n) {
                long l = this.zzols.skip(n - n2);
                if (l > 0L) {
                    n2 = (int)((long)n2 + l);
                    continue;
                }
                if (l != 0L) continue;
                if (this.zzols.read() == -1) break;
                ++n2;
            }
        }
        return n2;
    }

    public final int zzil(int n) throws IOException {
        if (n > this.buffer.length) {
            n = Math.min(n, this.zzim(n));
        }
        while (this.zzolt < n) {
            int n2 = this.zzols.read(this.buffer, this.zzolt, n - this.zzolt);
            if (n2 == -1) {
                this.zzolu = true;
                break;
            }
            this.zzolt += n2;
        }
        return this.zzolt;
    }

    private final int zzim(int n) {
        int n2 = Math.max(this.buffer.length << 1, n);
        long l = zzolr.totalMemory() - zzolr.freeMemory();
        long l2 = zzolr.maxMemory() - l;
        if (this.zzolv && (long)n2 < l2) {
            try {
                byte[] byArray = new byte[n2];
                System.arraycopy(this.buffer, 0, byArray, 0, this.zzolt);
                this.buffer = byArray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing due to low memory.");
                this.zzolv = false;
            }
        } else {
            Log.w((String)"AdaptiveStreamBuffer", (String)"Turning off adaptive buffer resizing to conserve memory.");
        }
        return this.buffer.length;
    }

    public final boolean isFinished() {
        return this.zzolu;
    }

    public final void close() throws IOException {
        this.zzols.close();
    }
}

