/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.Uri;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.zzexz;
import com.google.android.gms.internal.zzeya;
import com.google.android.gms.internal.zzeyc;
import com.google.firebase.FirebaseApp;
import org.json.JSONObject;

public final class zzeyb {
    private static DynamiteModule.zzd zzoly = DynamiteModule.zzgxa;
    private static final Object zzolz = new Object();
    private static volatile zzeyb zzoma;
    private zzexz zzomb;
    private Context mContext;
    private FirebaseApp zzoic;

    private zzeyb(@NonNull FirebaseApp firebaseApp) throws RemoteException {
        this.mContext = firebaseApp.getApplicationContext();
        this.zzoic = firebaseApp;
        try {
            IInterface iInterface;
            DynamiteModule dynamiteModule = DynamiteModule.zza((Context)this.mContext, (DynamiteModule.zzd)zzoly, (String)"com.google.android.gms.firebasestorage");
            IBinder iBinder = dynamiteModule.zzhb("com.google.firebase.storage.network.NetworkRequestFactoryImpl");
            this.zzomb = iBinder == null ? null : ((iInterface = iBinder.queryLocalInterface("com.google.firebase.storage.network.INetworkRequestFactory")) instanceof zzexz ? (zzexz)iInterface : new zzeya(iBinder));
        }
        catch (DynamiteModule.zzc zzc2) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"NetworkRequestFactoryProxy failed with a RemoteException:", (Throwable)zzc2);
            throw new RemoteException();
        }
        if (this.zzomb == null) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"Unable to load Firebase Storage Network layer.");
            throw new RemoteException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzeyb zzi(@NonNull FirebaseApp firebaseApp) throws RemoteException {
        if (zzoma == null) {
            Object object = zzolz;
            synchronized (object) {
                if (zzoma == null) {
                    zzoma = new zzeyb(firebaseApp);
                }
            }
        }
        return zzoma;
    }

    private final zzeyc zze(zzeyc zzeyc2) {
        zzeyc2.zzbq("x-firebase-gmpid", this.zzoic.getOptions().getApplicationId());
        return zzeyc2;
    }

    @NonNull
    public final zzeyc zzv(Uri uri) throws RemoteException {
        return this.zze(new zzeyc(this.zzomb.zza(uri, zzn.zzz((Object)this.mContext))));
    }

    @NonNull
    public final zzeyc zzw(Uri uri) throws RemoteException {
        return this.zze(new zzeyc(this.zzomb.zzb(uri, zzn.zzz((Object)this.mContext))));
    }

    @NonNull
    public final zzeyc zza(Uri uri, long l) throws RemoteException {
        return this.zze(new zzeyc(this.zzomb.zza(uri, zzn.zzz((Object)this.mContext), l)));
    }

    @NonNull
    public final zzeyc zza(Uri uri, String string, byte[] byArray, long l, int n, boolean bl) throws RemoteException {
        return this.zze(new zzeyc(this.zzomb.zza(uri, zzn.zzz((Object)this.mContext), string, zzn.zzz((Object)byArray), l, n, bl)));
    }

    @Nullable
    public final zzeyc zza(Uri uri, String string) throws RemoteException {
        return this.zze(new zzeyc(this.zzomb.zza(uri, zzn.zzz((Object)this.mContext), string)));
    }

    @NonNull
    public final zzeyc zzb(Uri uri, String string) throws RemoteException {
        return this.zze(new zzeyc(this.zzomb.zzb(uri, zzn.zzz((Object)this.mContext), string)));
    }

    @NonNull
    public final zzeyc zza(Uri uri, JSONObject jSONObject, String string) throws RemoteException {
        return this.zze(new zzeyc(this.zzomb.zza(uri, zzn.zzz((Object)this.mContext), zzn.zzz((Object)jSONObject), string)));
    }

    @NonNull
    public final zzeyc zza(Uri uri, JSONObject jSONObject) throws RemoteException {
        return this.zze(new zzeyc(this.zzomb.zza(uri, zzn.zzz((Object)this.mContext), zzn.zzz((Object)jSONObject))));
    }

    @Nullable
    public final String zzcmo() {
        try {
            return this.zzomb.zzcmo();
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"getBackendAuthority failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @Nullable
    public final String zzu(Uri uri) {
        try {
            return this.zzomb.zzu(uri);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"getDefaultURL failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }
}

