/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzexx;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

public final class zzeyc {
    private zzexx zzomc;
    private Exception zzkuq;
    private int zzomd;
    private Exception zzome;

    public zzeyc(@NonNull zzexx zzexx2) {
        this.zzomc = zzexx2;
    }

    public final void zzbq(String string, String string2) {
        try {
            this.zzomc.zzbq(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string3.length() != 0 ? "Caught remote exception setting custom header:".concat(string3) : new String("Caught remote exception setting custom header:")), (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final String zzsn(String string) {
        try {
            return this.zzomc.zzsn(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public final void zze(@Nullable String string, @NonNull Context context) {
        try {
            boolean bl;
            Context context2 = context;
            zzeyc zzeyc2 = this;
            NetworkInfo networkInfo = ((ConnectivityManager)context2.getSystemService("connectivity")).getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                zzeyc2.zzomd = -2;
                zzeyc2.zzome = new SocketException("Network subsystem is unavailable");
                bl = false;
            } else {
                bl = true;
            }
            if (!bl) {
                return;
            }
            this.zzomc.zzsl(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkuq = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequest failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void reset() {
        try {
            this.zzomd = 0;
            this.zzome = null;
            this.zzomc.reset();
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkuq = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"reset failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void zzsm(@Nullable String string) {
        try {
            this.zzomc.zzsm(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkuq = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestStart failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    public final void zzcmh() {
        try {
            if (this.zzomc != null) {
                this.zzomc.zzcmh();
            }
            return;
        }
        catch (RemoteException remoteException) {
            this.zzkuq = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestEnd failed with a RemoteException:", (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final InputStream getStream() {
        try {
            return (InputStream)zzn.zzx((IObjectWrapper)this.zzomc.zzcmi());
        }
        catch (RemoteException remoteException) {
            this.zzkuq = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getStream failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @NonNull
    public final JSONObject zzcmp() throws RemoteException {
        return (JSONObject)zzn.zzx((IObjectWrapper)this.zzomc.zzcmj());
    }

    @Nullable
    public final String zzcmk() {
        try {
            this.zzomc.zzcmk();
        }
        catch (RemoteException remoteException) {
            this.zzkuq = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getRawResult failed with a RemoteException:", (Throwable)remoteException);
        }
        return null;
    }

    @Nullable
    public final Exception getException() {
        try {
            if (this.zzome != null) {
                return this.zzome;
            }
            if (this.zzkuq != null) {
                return this.zzkuq;
            }
            return (Exception)zzn.zzx((IObjectWrapper)this.zzomc.zzcml());
        }
        catch (RemoteException remoteException) {
            this.zzkuq = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getException failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    public final int getResultCode() {
        try {
            if (this.zzomd != 0) {
                return this.zzomd;
            }
            return this.zzomc.getResultCode();
        }
        catch (RemoteException remoteException) {
            this.zzkuq = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultCode failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }

    public final boolean zzcmm() {
        try {
            if (this.zzomd == -2 || this.zzome != null) {
                return false;
            }
            return this.zzomc.zzcmm();
        }
        catch (RemoteException remoteException) {
            this.zzkuq = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"isResultSuccess failed with a RemoteException:", (Throwable)remoteException);
            return false;
        }
    }

    public final <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.getException();
        if (this.zzcmm() && exception == null) {
            taskCompletionSource.setResult(TResult);
            return;
        }
        StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
        taskCompletionSource.setException((Exception)((Object)storageException));
    }

    public final int zzcmn() {
        try {
            return this.zzomc.zzcmn();
        }
        catch (RemoteException remoteException) {
            this.zzkuq = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultingContentLength failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }
}

