/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzexr;
import com.google.android.gms.internal.zzeyb;
import com.google.android.gms.internal.zzeyc;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzu;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDownloadTask
extends StorageTask<TaskSnapshot> {
    private final Uri zzohw;
    private long zzohx;
    private StorageReference zzoht;
    private zzexr zzohv;
    private long zzgmb = -1L;
    private String zzohy = null;
    private volatile Exception zzkuq = null;
    private long zzohz = 0L;
    private int mResultCode;

    FileDownloadTask(@NonNull StorageReference storageReference, @NonNull Uri uri) {
        this.zzoht = storageReference;
        this.zzohw = uri;
        this.zzohv = new zzexr(this.zzoht.getStorage().getApp(), this.zzoht.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final long getTotalBytes() {
        return this.zzgmb;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zzoht;
    }

    @Override
    protected void schedule() {
        zzu.zzu(this.zzbko());
    }

    private final int zza(InputStream inputStream, byte[] byArray) {
        int n;
        boolean bl = false;
        try {
            int n2;
            for (n = 0; n != byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) != -1; n += n2) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            this.zzkuq = iOException;
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    private final boolean zza(zzeyc zzeyc2) throws IOException {
        boolean bl = true;
        InputStream inputStream = zzeyc2.getStream();
        if (inputStream != null) {
            FileOutputStream fileOutputStream;
            Object object;
            File file = new File(this.zzohw.getPath());
            if (!file.exists()) {
                if (this.zzohz > 0L) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.e((String)"FileDownloadTask", (String)(string.length() != 0 ? "The file downloading to has been deleted:".concat(string) : new String("The file downloading to has been deleted:")));
                    throw new IllegalStateException("expected a file to resume from.");
                }
                if (!file.createNewFile()) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.w((String)"FileDownloadTask", (String)(string.length() != 0 ? "unable to create file:".concat(string) : new String("unable to create file:")));
                }
            }
            if (this.zzohz > 0L) {
                object = file.getAbsolutePath();
                long l = this.zzohz;
                Log.d((String)"FileDownloadTask", (String)new StringBuilder(47 + String.valueOf(object).length()).append("Resuming download file ").append((String)object).append(" at ").append(l).toString());
                fileOutputStream = new FileOutputStream(file, true);
            } else {
                fileOutputStream = new FileOutputStream(file);
            }
            try {
                int n;
                object = new byte[262144];
                while (bl && (n = this.zza(inputStream, (byte[])object)) != -1) {
                    ((OutputStream)fileOutputStream).write((byte[])object, 0, n);
                    this.zzohx += (long)n;
                    if (this.zzkuq != null) {
                        Log.d((String)"FileDownloadTask", (String)"Exception occurred during file download. Retrying.", (Throwable)this.zzkuq);
                        this.zzkuq = null;
                        bl = false;
                    }
                    if (this.zzk(4, false)) continue;
                    bl = false;
                }
            }
            finally {
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                inputStream.close();
            }
        } else {
            this.zzkuq = new IllegalStateException("Unable to open Firebase Storage stream.");
            bl = false;
        }
        return bl;
    }

    @Override
    final void run() {
        if (this.zzkuq != null) {
            this.zzk(64, false);
            return;
        }
        if (!this.zzk(4, false)) {
            return;
        }
        do {
            Object object;
            zzeyc zzeyc2;
            this.zzohx = 0L;
            this.zzkuq = null;
            this.zzohv.reset();
            try {
                zzeyc2 = zzeyb.zzi(this.zzoht.getStorage().getApp()).zza(this.zzoht.zzclr(), this.zzohz);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"FileDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
                this.zzkuq = remoteException;
                this.zzk(64, false);
                return;
            }
            this.zzohv.zza(zzeyc2, false);
            this.mResultCode = zzeyc2.getResultCode();
            this.zzkuq = zzeyc2.getException() != null ? zzeyc2.getException() : this.zzkuq;
            int n = this.mResultCode;
            boolean bl = (n == 308 || n >= 200 && n < 300) && this.zzkuq == null && this.zzclt() == 4;
            if (bl) {
                this.zzgmb = zzeyc2.zzcmn();
                object = zzeyc2.zzsn("ETag");
                if (!TextUtils.isEmpty((CharSequence)object) && this.zzohy != null && !this.zzohy.equals(object)) {
                    Log.w((String)"FileDownloadTask", (String)"The file at the server has changed.  Restarting from the beginning.");
                    this.zzohz = 0L;
                    this.zzohy = null;
                    zzeyc2.zzcmh();
                    ((StorageTask)this).schedule();
                    return;
                }
                this.zzohy = object;
                try {
                    bl = this.zza(zzeyc2);
                }
                catch (IOException iOException) {
                    Log.e((String)"FileDownloadTask", (String)"Exception occurred during file write.  Aborting.", (Throwable)iOException);
                    this.zzkuq = iOException;
                }
            }
            zzeyc2.zzcmh();
            if (bl && this.zzkuq == null && this.zzclt() == 4) {
                this.zzk(128, false);
                return;
            }
            object = new File(this.zzohw.getPath());
            this.zzohz = ((File)object).exists() ? ((File)object).length() : 0L;
            if (this.zzclt() == 8) {
                this.zzk(16, false);
                return;
            }
            if (this.zzclt() != 32) continue;
            if (!this.zzk(256, false)) {
                int n2 = this.zzclt();
                Log.w((String)"FileDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n2).toString());
            }
            return;
        } while (this.zzohx > 0L);
        this.zzk(64, false);
    }

    @Override
    protected void onCanceled() {
        this.zzohv.cancel();
        this.zzkuq = StorageException.fromErrorStatus(Status.zzfnm);
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzcln() {
        FileDownloadTask fileDownloadTask = this;
        return new TaskSnapshot(fileDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(fileDownloadTask.zzkuq, fileDownloadTask.mResultCode)), fileDownloadTask.zzohx + fileDownloadTask.zzohz);
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzohx;
        private /* synthetic */ FileDownloadTask zzoia;

        TaskSnapshot(@Nullable FileDownloadTask fileDownloadTask, Exception exception, long l) {
            this.zzoia = fileDownloadTask;
            super(fileDownloadTask, exception);
            this.zzohx = l;
        }

        public long getBytesTransferred() {
            return this.zzohx;
        }

        public long getTotalByteCount() {
            return this.zzoia.getTotalBytes();
        }
    }
}

