/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzexs;
import com.google.android.gms.internal.zzexw;
import com.google.android.gms.internal.zzeyb;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzd;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage zzoim = null;
    private StorageReference zzoht = null;
    private String zzoin = null;
    private String zzoio = null;
    private zza<String> zzoip = zza.zzcj("");
    private String zzoiq = null;
    private String zzoir = null;
    private String zzois = null;
    private long zzoit;
    private String zzoiu = null;
    private zza<String> zzoiv = zza.zzcj("");
    private zza<String> zzoiw = zza.zzcj("");
    private zza<String> zzoix = zza.zzcj("");
    private zza<String> zzoiy = zza.zzcj("");
    private zza<Map<String, String>> zzoiz = zza.zzcj(Collections.emptyMap());
    private String[] zzoja = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzbq.checkNotNull((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.zzoim = storageMetadata.zzoim;
        this.zzoht = storageMetadata.zzoht;
        this.zzoin = storageMetadata.zzoin;
        this.zzoip = storageMetadata.zzoip;
        this.zzoiv = storageMetadata.zzoiv;
        this.zzoiw = storageMetadata.zzoiw;
        this.zzoix = storageMetadata.zzoix;
        this.zzoiy = storageMetadata.zzoiy;
        this.zzoiz = storageMetadata.zzoiz;
        this.zzoja = storageMetadata.zzoja;
        if (bl) {
            this.zzoiu = storageMetadata.zzoiu;
            this.zzoit = storageMetadata.zzoit;
            this.zzois = storageMetadata.zzois;
            this.zzoir = storageMetadata.zzoir;
            this.zzoiq = storageMetadata.zzoiq;
            this.zzoio = storageMetadata.zzoio;
        }
    }

    public String getContentType() {
        return this.zzoip.getValue();
    }

    public String getCustomMetadata(@NonNull String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.zzoiz.getValue().get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        return this.zzoiz.getValue().keySet();
    }

    @NonNull
    public String getPath() {
        if (this.mPath != null) {
            return this.mPath;
        }
        return "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.zzoin;
    }

    @Nullable
    public String getGeneration() {
        return this.zzoio;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.zzoiq;
    }

    public long getCreationTimeMillis() {
        return zzexw.zzsk(this.zzoir);
    }

    public long getUpdatedTimeMillis() {
        return zzexw.zzsk(this.zzois);
    }

    public long getSizeBytes() {
        return this.zzoit;
    }

    @Nullable
    public String getMd5Hash() {
        return this.zzoiu;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.zzoja != null && this.zzoht != null) {
            try {
                String string = zzeyb.zzi(this.zzoht.getStorage().getApp()).zzu(this.zzoht.zzclr());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    String[] stringArray = this.zzoja;
                    int n = this.zzoja.length;
                    for (int i = 0; i < n; ++i) {
                        String string2 = stringArray[i];
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.zzoiv.getValue();
    }

    @Nullable
    public String getContentDisposition() {
        return this.zzoiw.getValue();
    }

    @Nullable
    public String getContentEncoding() {
        return this.zzoix.getValue();
    }

    @Nullable
    public String getContentLanguage() {
        return this.zzoiy.getValue();
    }

    @Nullable
    public StorageReference getReference() {
        if (this.zzoht == null && this.zzoim != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(zzexs.zzsh((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.zzoim);
        }
        return this.zzoht;
    }

    @NonNull
    final JSONObject zzclo() throws JSONException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.zzoip.zzclp()) {
            hashMap.put("contentType", this.getContentType());
        }
        if (this.zzoiz.zzclp()) {
            hashMap.put("metadata", (String)new JSONObject(this.zzoiz.getValue()));
        }
        if (this.zzoiv.zzclp()) {
            hashMap.put("cacheControl", this.getCacheControl());
        }
        if (this.zzoiw.zzclp()) {
            hashMap.put("contentDisposition", this.getContentDisposition());
        }
        if (this.zzoix.zzclp()) {
            hashMap.put("contentEncoding", this.getContentEncoding());
        }
        if (this.zzoiy.zzclp()) {
            hashMap.put("contentLanguage", this.getContentLanguage());
        }
        return new JSONObject(hashMap);
    }

    private final void zzsg(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.zzoja = string.split(",");
        }
    }

    /* synthetic */ StorageMetadata(StorageMetadata storageMetadata, boolean bl, zzd zzd2) {
        this(storageMetadata, bl);
    }

    public static class Builder {
        private StorageMetadata zzojb;
        private boolean zzojc;

        public Builder() {
            this.zzojb = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.zzojb = new StorageMetadata(storageMetadata, false, null);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.zzojb.zzoht = storageReference;
        }

        private Builder(JSONObject jSONObject) throws JSONException {
            this.zzojb = new StorageMetadata();
            if (jSONObject != null) {
                this.zzac(jSONObject);
                this.zzojc = true;
            }
        }

        @Nullable
        private static String zze(JSONObject jSONObject, String string) throws JSONException {
            if (jSONObject.has(string) && !jSONObject.isNull(string)) {
                return jSONObject.getString(string);
            }
            return null;
        }

        private final void zzac(JSONObject jSONObject) throws JSONException {
            String string;
            this.zzojb.zzoio = jSONObject.optString("generation");
            this.zzojb.mPath = jSONObject.optString("name");
            this.zzojb.zzoin = jSONObject.optString("bucket");
            this.zzojb.zzoiq = jSONObject.optString("metageneration");
            this.zzojb.zzoir = jSONObject.optString("timeCreated");
            this.zzojb.zzois = jSONObject.optString("updated");
            this.zzojb.zzoit = jSONObject.optLong("size");
            this.zzojb.zzoiu = jSONObject.optString("md5Hash");
            this.zzojb.zzsg(jSONObject.optString("downloadTokens"));
            if (jSONObject.has("metadata") && !jSONObject.isNull("metadata")) {
                string = jSONObject.getJSONObject("metadata");
                Iterator iterator = string.keys();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    this.setCustomMetadata(string2, string.getString(string2));
                }
            }
            if ((string = Builder.zze(jSONObject, "contentType")) != null) {
                this.setContentType(string);
            }
            if ((string = Builder.zze(jSONObject, "cacheControl")) != null) {
                this.setCacheControl(string);
            }
            if ((string = Builder.zze(jSONObject, "contentDisposition")) != null) {
                this.setContentDisposition(string);
            }
            if ((string = Builder.zze(jSONObject, "contentEncoding")) != null) {
                this.setContentEncoding(string);
            }
            if ((string = Builder.zze(jSONObject, "contentLanguage")) != null) {
                this.setContentLanguage(string);
            }
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.zzojb, this.zzojc, null);
        }

        public Builder setContentLanguage(@Nullable String string) {
            this.zzojb.zzoiy = zza.zzck(string);
            return this;
        }

        public Builder setContentEncoding(@Nullable String string) {
            this.zzojb.zzoix = zza.zzck(string);
            return this;
        }

        public Builder setContentDisposition(@Nullable String string) {
            this.zzojb.zzoiw = zza.zzck(string);
            return this;
        }

        public Builder setCacheControl(@Nullable String string) {
            this.zzojb.zzoiv = zza.zzck(string);
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (!this.zzojb.zzoiz.zzclp()) {
                this.zzojb.zzoiz = zza.zzck(new HashMap());
            }
            ((Map)this.zzojb.zzoiz.getValue()).put(string, string2);
            return this;
        }

        public Builder setContentType(@Nullable String string) {
            this.zzojb.zzoip = zza.zzck(string);
            return this;
        }
    }

    static final class zza<T> {
        private final boolean zzojd;
        @Nullable
        private final T value;

        private zza(@Nullable T t, boolean bl) {
            this.zzojd = bl;
            this.value = t;
        }

        static <T> zza<T> zzcj(T t) {
            return new zza<T>(t, false);
        }

        static <T> zza<T> zzck(@Nullable T t) {
            return new zza<T>(t, true);
        }

        final boolean zzclp() {
            return this.zzojd;
        }

        @Nullable
        final T getValue() {
            return this.value;
        }
    }
}

