/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.CancellableTask;
import com.google.firebase.storage.ControllableTask;
import com.google.firebase.storage.OnPausedListener;
import com.google.firebase.storage.OnProgressListener;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzj;
import com.google.firebase.storage.zzk;
import com.google.firebase.storage.zzl;
import com.google.firebase.storage.zzm;
import com.google.firebase.storage.zzn;
import com.google.firebase.storage.zzo;
import com.google.firebase.storage.zzp;
import com.google.firebase.storage.zzs;
import com.google.firebase.storage.zzt;
import com.google.firebase.storage.zzx;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executor;

public abstract class StorageTask<TResult extends ProvideError>
extends ControllableTask<TResult> {
    private static final HashMap<Integer, HashSet<Integer>> zzojj = new HashMap();
    private static final HashMap<Integer, HashSet<Integer>> zzojk = new HashMap();
    protected final Object mSyncObject = new Object();
    @VisibleForTesting
    private zzx<OnSuccessListener<? super TResult>, TResult> zzojl = new zzx(this, 128, new zzj(this));
    @VisibleForTesting
    private zzx<OnFailureListener, TResult> zzojm = new zzx(this, 320, new zzk(this));
    @VisibleForTesting
    private zzx<OnCompleteListener<TResult>, TResult> zzojn = new zzx(this, 448, new zzl(this));
    @VisibleForTesting
    private zzx<OnProgressListener<? super TResult>, TResult> zzojo = new zzx(this, -465, new zzm(this));
    @VisibleForTesting
    private zzx<OnPausedListener<? super TResult>, TResult> zzojp = new zzx(this, 16, new zzn(this));
    private volatile int zzdfx = 1;
    private TResult zzojq;

    protected StorageTask() {
    }

    @VisibleForTesting
    final boolean zzcls() {
        if (this.zzk(2, false)) {
            this.schedule();
            return true;
        }
        return false;
    }

    @VisibleForTesting
    void resetState() {
    }

    @VisibleForTesting
    abstract StorageReference getStorage();

    @VisibleForTesting
    abstract void schedule();

    @Override
    public boolean resume() {
        if (this.zzk(2, true)) {
            this.resetState();
            this.schedule();
            return true;
        }
        return false;
    }

    @Override
    public boolean pause() {
        return this.zza(new int[]{16, 8}, true);
    }

    @Override
    public boolean cancel() {
        return this.zza(new int[]{256, 32}, true);
    }

    public boolean isComplete() {
        return (this.zzdfx & 0x80) != 0 || (this.zzdfx & 0x140) != 0;
    }

    public boolean isSuccessful() {
        return (this.zzdfx & 0x80) != 0;
    }

    @Override
    public boolean isCanceled() {
        return this.zzdfx == 256;
    }

    @Override
    public boolean isInProgress() {
        return (this.zzdfx & 0xFFFFFE2F) != 0;
    }

    @Override
    public boolean isPaused() {
        return (this.zzdfx & 0x10) != 0;
    }

    public TResult getResult() {
        if (this.zzclv() == null) {
            throw new IllegalStateException();
        }
        Exception exception = this.zzclv().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.zzclv();
    }

    public <X extends Throwable> TResult getResult(@NonNull Class<X> clazz) throws X {
        if (this.zzclv() == null) {
            throw new IllegalStateException();
        }
        if (clazz.isInstance(this.zzclv().getError())) {
            throw (Throwable)clazz.cast(this.zzclv().getError());
        }
        Exception exception = this.zzclv().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.zzclv();
    }

    @Nullable
    public Exception getException() {
        if (this.zzclv() == null) {
            return null;
        }
        return this.zzclv().getError();
    }

    public TResult getSnapshot() {
        return this.zzclu();
    }

    @VisibleForTesting
    final int zzclt() {
        return this.zzdfx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @VisibleForTesting
    final TResult zzclu() {
        Object object = this.mSyncObject;
        synchronized (object) {
            return this.zzcln();
        }
    }

    @NonNull
    @VisibleForTesting
    abstract TResult zzcln();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final boolean zza(int[] nArray, boolean bl) {
        HashMap<Integer, HashSet<Integer>> hashMap = bl ? zzojj : zzojk;
        Object object = this.mSyncObject;
        synchronized (object) {
            Object object2 = nArray;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = object2[i];
                HashSet<Integer> hashSet = hashMap.get(this.zzdfx);
                if (hashSet == null || !hashSet.contains(n2)) continue;
                this.zzdfx = n2;
                switch (this.zzdfx) {
                    case 2: {
                        zzt.zzclx().zzb(this);
                        this.onQueued();
                        break;
                    }
                    case 4: {
                        this.onProgress();
                        break;
                    }
                    case 16: {
                        this.onPaused();
                        break;
                    }
                    case 64: {
                        this.onFailure();
                        break;
                    }
                    case 128: {
                        this.onSuccess();
                        break;
                    }
                    case 256: {
                        this.onCanceled();
                    }
                }
                this.zzojl.zzcmb();
                this.zzojm.zzcmb();
                this.zzojn.zzcmb();
                this.zzojp.zzcmb();
                this.zzojo.zzcmb();
                if (Log.isLoggable((String)"StorageTask", (int)3)) {
                    String string = StorageTask.zzij(n2);
                    String string2 = StorageTask.zzij(this.zzdfx);
                    Log.d((String)"StorageTask", (String)new StringBuilder(53 + String.valueOf(string).length() + String.valueOf(string2).length()).append("changed internal state to: ").append(string).append(" isUser: ").append(bl).append(" from state:").append(string2).toString());
                }
                return true;
            }
            object2 = StorageTask.zzj(nArray);
            String string = StorageTask.zzij(this.zzdfx);
            Log.w((String)"StorageTask", (String)new StringBuilder(62 + String.valueOf(object2).length() + String.valueOf(string).length()).append("unable to change internal state to: ").append((String)object2).append(" isUser: ").append(bl).append(" from state:").append(string).toString());
            return false;
        }
    }

    @VisibleForTesting
    final boolean zzk(int n, boolean bl) {
        return this.zza(new int[]{n}, bl);
    }

    protected void onQueued() {
    }

    protected void onProgress() {
    }

    protected void onPaused() {
    }

    protected void onFailure() {
    }

    protected void onSuccess() {
    }

    protected void onCanceled() {
    }

    private final TResult zzclv() {
        if (this.zzojq != null) {
            return this.zzojq;
        }
        if (!this.isComplete()) {
            return null;
        }
        if (this.zzojq == null) {
            this.zzojq = this.zzclu();
        }
        return this.zzojq;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbq.checkNotNull(onPausedListener);
        this.zzojp.zza(null, null, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Executor executor, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbq.checkNotNull(onPausedListener);
        zzbq.checkNotNull((Object)executor);
        this.zzojp.zza(null, executor, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Activity activity, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbq.checkNotNull(onPausedListener);
        zzbq.checkNotNull((Object)activity);
        this.zzojp.zza(activity, null, onPausedListener);
        return this;
    }

    public StorageTask<TResult> removeOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbq.checkNotNull(onPausedListener);
        this.zzojp.zzcl(onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbq.checkNotNull(onProgressListener);
        this.zzojo.zza(null, null, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Executor executor, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbq.checkNotNull(onProgressListener);
        zzbq.checkNotNull((Object)executor);
        this.zzojo.zza(null, executor, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Activity activity, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbq.checkNotNull(onProgressListener);
        zzbq.checkNotNull((Object)activity);
        this.zzojo.zza(activity, null, onProgressListener);
        return this;
    }

    public StorageTask<TResult> removeOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbq.checkNotNull(onProgressListener);
        this.zzojo.zzcl(onProgressListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbq.checkNotNull(onSuccessListener);
        this.zzojl.zza(null, null, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbq.checkNotNull((Object)executor);
        zzbq.checkNotNull(onSuccessListener);
        this.zzojl.zza(null, executor, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Activity activity, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbq.checkNotNull((Object)activity);
        zzbq.checkNotNull(onSuccessListener);
        this.zzojl.zza(activity, null, onSuccessListener);
        return this;
    }

    public StorageTask<TResult> removeOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbq.checkNotNull(onSuccessListener);
        this.zzojl.zzcl(onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzbq.checkNotNull((Object)onFailureListener);
        this.zzojm.zza(null, null, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener onFailureListener) {
        zzbq.checkNotNull((Object)onFailureListener);
        zzbq.checkNotNull((Object)executor);
        this.zzojm.zza(null, executor, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Activity activity, @NonNull OnFailureListener onFailureListener) {
        zzbq.checkNotNull((Object)onFailureListener);
        zzbq.checkNotNull((Object)activity);
        this.zzojm.zza(activity, null, onFailureListener);
        return this;
    }

    public StorageTask<TResult> removeOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzbq.checkNotNull((Object)onFailureListener);
        this.zzojm.zzcl(onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbq.checkNotNull(onCompleteListener);
        this.zzojn.zza(null, null, onCompleteListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull Executor executor, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbq.checkNotNull(onCompleteListener);
        zzbq.checkNotNull((Object)executor);
        this.zzojn.zza(null, executor, onCompleteListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull Activity activity, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbq.checkNotNull(onCompleteListener);
        zzbq.checkNotNull((Object)activity);
        this.zzojn.zza(activity, null, onCompleteListener);
        return this;
    }

    public StorageTask<TResult> removeOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbq.checkNotNull(onCompleteListener);
        this.zzojn.zzcl(onCompleteListener);
        return this;
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.zza(null, continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.zza(executor, continuation);
    }

    @NonNull
    private final <TContinuationResult> Task<TContinuationResult> zza(@Nullable Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzojn.zza(null, executor, new zzo(this, continuation, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.zzb(null, continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.zzb(executor, continuation);
    }

    @NonNull
    private final <TContinuationResult> Task<TContinuationResult> zzb(@Nullable Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzojn.zza(null, executor, new zzp(this, continuation, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @VisibleForTesting
    abstract void run();

    @VisibleForTesting
    final Runnable zzbko() {
        return new zzs(this);
    }

    private final void zzclw() {
        if (!(this.isComplete() || ((ControllableTask)this).isPaused() || this.zzdfx == 2 || this.zzk(256, false))) {
            this.zzk(64, false);
        }
    }

    private static String zzj(int[] nArray) {
        if (nArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            stringBuilder.append(StorageTask.zzij(n2)).append(", ");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2);
    }

    private static String zzij(int n) {
        switch (n) {
            case 1: {
                return "INTERNAL_STATE_NOT_STARTED";
            }
            case 2: {
                return "INTERNAL_STATE_QUEUED";
            }
            case 4: {
                return "INTERNAL_STATE_IN_PROGRESS";
            }
            case 8: {
                return "INTERNAL_STATE_PAUSING";
            }
            case 16: {
                return "INTERNAL_STATE_PAUSED";
            }
            case 32: {
                return "INTERNAL_STATE_CANCELING";
            }
            case 64: {
                return "INTERNAL_STATE_FAILURE";
            }
            case 128: {
                return "INTERNAL_STATE_SUCCESS";
            }
            case 256: {
                return "INTERNAL_STATE_CANCELED";
            }
        }
        return "Unknown Internal State!";
    }

    static /* synthetic */ void zza(StorageTask storageTask) {
        storageTask.zzclw();
    }

    static {
        zzojj.put(1, new HashSet<Integer>(Arrays.asList(16, 256)));
        zzojj.put(2, new HashSet<Integer>(Arrays.asList(8, 32)));
        zzojj.put(4, new HashSet<Integer>(Arrays.asList(8, 32)));
        zzojj.put(16, new HashSet<Integer>(Arrays.asList(2, 256)));
        zzojj.put(64, new HashSet<Integer>(Arrays.asList(2, 256)));
        zzojk.put(1, new HashSet<Integer>(Arrays.asList(2, 64)));
        zzojk.put(2, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        zzojk.put(4, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        zzojk.put(8, new HashSet<Integer>(Arrays.asList(16, 64, 128)));
        zzojk.put(32, new HashSet<Integer>(Arrays.asList(256, 64, 128)));
    }

    public class SnapshotBase
    implements ProvideError {
        private final Exception zzoju;
        private /* synthetic */ StorageTask zzojr;

        public SnapshotBase(@Nullable StorageTask storageTask, Exception exception) {
            this.zzojr = storageTask;
            if (exception == null) {
                if (((CancellableTask)storageTask).isCanceled()) {
                    this.zzoju = StorageException.fromErrorStatus(Status.zzfnm);
                    return;
                }
                if (storageTask.zzclt() == 64) {
                    this.zzoju = StorageException.fromErrorStatus(Status.zzfnk);
                    return;
                }
                this.zzoju = null;
                return;
            }
            this.zzoju = exception;
        }

        @NonNull
        public StorageTask<TResult> getTask() {
            return this.zzojr;
        }

        @NonNull
        public StorageReference getStorage() {
            return this.getTask().getStorage();
        }

        @Override
        @Nullable
        public Exception getError() {
            return this.zzoju;
        }
    }

    public static interface ProvideError {
        public Exception getError();
    }
}

