/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzexr;
import com.google.android.gms.internal.zzeyc;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzu;
import com.google.firebase.storage.zzw;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference zzoht;
    private zzexr zzohv;
    private volatile Exception zzkuq = null;
    private volatile int mResultCode = 0;
    private StreamProcessor zzokh;
    private long zzgmb = -1L;
    private long zzohx;
    private long zzoki;
    private InputStream zzljj;
    private zzeyc zzokj;
    private String zzohy;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.zzoht = storageReference;
        this.zzohv = new zzexr(this.zzoht.getStorage().getApp(), this.zzoht.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzbq.checkNotNull((Object)streamProcessor);
        zzbq.checkState((this.zzokh == null ? 1 : 0) != 0);
        this.zzokh = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zzoht;
    }

    final long getTotalBytes() {
        return this.zzgmb;
    }

    final void zzcp(long l) {
        this.zzohx += l;
        if (this.zzoki + 262144L <= this.zzohx) {
            if (this.zzclt() == 4) {
                this.zzk(4, false);
                return;
            }
            this.zzoki = this.zzohx;
        }
    }

    @Override
    protected void schedule() {
        zzu.zzu(this.zzbko());
    }

    private final InputStream zzcly() throws Exception {
        this.zzohv.reset();
        if (this.zzokj != null) {
            this.zzokj.zzcmh();
        }
        try {
            this.zzokj = this.zzoht.zzclq().zza(this.zzoht.zzclr(), this.zzohx);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            throw remoteException;
        }
        this.zzohv.zza(this.zzokj, false);
        this.mResultCode = this.zzokj.getResultCode();
        this.zzkuq = this.zzokj.getException() != null ? this.zzokj.getException() : this.zzkuq;
        int n = this.mResultCode;
        if ((n == 308 || n >= 200 && n < 300) && this.zzkuq == null && this.zzclt() == 4) {
            String string = this.zzokj.zzsn("ETag");
            if (!TextUtils.isEmpty((CharSequence)string) && this.zzohy != null && !this.zzohy.equals(string)) {
                this.mResultCode = 409;
                throw new IOException("The ETag on the server changed.");
            }
            this.zzohy = string;
            if (this.zzgmb == -1L) {
                this.zzgmb = this.zzokj.zzcmn();
            }
            return this.zzokj.getStream();
        }
        throw new IOException("Could not open resulting stream.");
    }

    @Override
    final void run() {
        if (this.zzkuq != null) {
            this.zzk(64, false);
            return;
        }
        if (!this.zzk(4, false)) {
            return;
        }
        zza zza2 = new zza(new zzw(this), this);
        this.zzljj = new BufferedInputStream(zza2);
        try {
            zza2.zzcma();
            if (this.zzokh != null) {
                try {
                    this.zzokh.doInBackground((TaskSnapshot)this.zzclu(), this.zzljj);
                }
                catch (Exception exception) {
                    Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                    this.zzkuq = exception;
                }
            }
        }
        catch (IOException iOException) {
            Log.d((String)"StreamDownloadTask", (String)"Initial opening of Stream failed", (Throwable)iOException);
            this.zzkuq = iOException;
        }
        if (this.zzljj == null) {
            this.zzokj.zzcmh();
            this.zzokj = null;
        }
        if (this.zzkuq == null && this.zzclt() == 4) {
            this.zzk(4, false);
            this.zzk(128, false);
            return;
        }
        if (!this.zzk(this.zzclt() == 32 ? 256 : 64, false)) {
            int n = this.zzclt();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    protected void onCanceled() {
        this.zzohv.cancel();
        this.zzkuq = StorageException.fromErrorStatus(Status.zzfnm);
    }

    @Override
    protected void onProgress() {
        this.zzoki = this.zzohx;
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzcln() {
        StreamDownloadTask streamDownloadTask = this;
        return new TaskSnapshot(streamDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(streamDownloadTask.zzkuq, streamDownloadTask.mResultCode)), streamDownloadTask.zzoki);
    }

    static /* synthetic */ InputStream zza(StreamDownloadTask streamDownloadTask) throws Exception {
        return streamDownloadTask.zzcly();
    }

    static /* synthetic */ zzeyc zza(StreamDownloadTask streamDownloadTask, zzeyc zzeyc2) {
        streamDownloadTask.zzokj = null;
        return null;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzohx;
        private /* synthetic */ StreamDownloadTask zzokk;

        TaskSnapshot(@Nullable StreamDownloadTask streamDownloadTask, Exception exception, long l) {
            this.zzokk = streamDownloadTask;
            super(streamDownloadTask, exception);
            this.zzohx = l;
        }

        public long getBytesTransferred() {
            return this.zzohx;
        }

        public long getTotalByteCount() {
            return this.zzokk.getTotalBytes();
        }

        public InputStream getStream() {
            return this.zzokk.zzljj;
        }
    }

    static final class zza
    extends InputStream {
        @Nullable
        private StreamDownloadTask zzokl;
        @Nullable
        private InputStream zzokm;
        private Callable<InputStream> zzokn;
        private IOException zzoko;
        private int zzokp;
        private int zzokq;
        private boolean zzokr;

        zza(@NonNull Callable<InputStream> callable, @Nullable StreamDownloadTask streamDownloadTask) {
            this.zzokl = streamDownloadTask;
            this.zzokn = callable;
        }

        private final void zzclz() throws IOException {
            if (this.zzokl != null && this.zzokl.zzclt() == 32) {
                throw new com.google.firebase.storage.zza();
            }
        }

        private final void zzcp(long l) {
            if (this.zzokl != null) {
                this.zzokl.zzcp(l);
            }
            this.zzokp = (int)((long)this.zzokp + l);
        }

        private final boolean zzcma() throws IOException {
            this.zzclz();
            if (this.zzoko != null) {
                try {
                    if (this.zzokm != null) {
                        this.zzokm.close();
                    }
                }
                catch (IOException iOException) {}
                this.zzokm = null;
                if (this.zzokq == this.zzokp) {
                    Log.i((String)"StreamDownloadTask", (String)"Encountered exception during stream operation. Aborting.", (Throwable)this.zzoko);
                    return false;
                }
                int n = this.zzokp;
                Log.i((String)"StreamDownloadTask", (String)new StringBuilder(70).append("Encountered exception during stream operation. Retrying at ").append(n).toString(), (Throwable)this.zzoko);
                this.zzokq = this.zzokp;
                this.zzoko = null;
            }
            if (this.zzokr) {
                throw new IOException("Can't perform operation on closed stream");
            }
            if (this.zzokm == null) {
                try {
                    this.zzokm = this.zzokn.call();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    if (exception instanceof IOException) {
                        throw (IOException)exception2;
                    }
                    throw new IOException("Unable to open stream", exception2);
                }
            }
            return true;
        }

        @Override
        public final int read() throws IOException {
            while (this.zzcma()) {
                try {
                    int n = this.zzokm.read();
                    if (n != -1) {
                        this.zzcp(1L);
                    }
                    return n;
                }
                catch (IOException iOException) {
                    this.zzoko = iOException;
                }
            }
            throw this.zzoko;
        }

        @Override
        public final int available() throws IOException {
            while (this.zzcma()) {
                try {
                    return this.zzokm.available();
                }
                catch (IOException iOException) {
                    this.zzoko = iOException;
                }
            }
            throw this.zzoko;
        }

        @Override
        public final void close() throws IOException {
            if (this.zzokm != null) {
                this.zzokm.close();
            }
            this.zzokr = true;
            if (this.zzokl != null && this.zzokl.zzokj != null) {
                this.zzokl.zzokj.zzcmh();
                StreamDownloadTask.zza(this.zzokl, null);
            }
            this.zzclz();
        }

        @Override
        public final void mark(int n) {
        }

        @Override
        public final boolean markSupported() {
            return false;
        }

        @Override
        public final int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (this.zzcma()) {
                try {
                    int n4;
                    while ((long)n2 > 262144L) {
                        n4 = this.zzokm.read(byArray, n, 262144);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        this.zzcp(n4);
                        this.zzclz();
                    }
                    if (n2 > 0) {
                        n4 = this.zzokm.read(byArray, n, n2);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n += n4;
                        n3 += n4;
                        n2 -= n4;
                        this.zzcp(n4);
                    }
                    if (n2 != 0) continue;
                    return n3;
                }
                catch (IOException iOException) {
                    this.zzoko = iOException;
                }
            }
            throw this.zzoko;
        }

        @Override
        public final long skip(long l) throws IOException {
            int n = 0;
            while (this.zzcma()) {
                try {
                    long l2;
                    while (l > 262144L) {
                        l2 = this.zzokm.skip(262144L);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzcp(l2);
                        this.zzclz();
                    }
                    if (l > 0L) {
                        l2 = this.zzokm.skip(l);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zzcp(l2);
                    }
                    if (l != 0L) continue;
                    return n;
                }
                catch (IOException iOException) {
                    this.zzoko = iOException;
                }
            }
            throw this.zzoko;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

