/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzexr;
import com.google.android.gms.internal.zzeyb;
import com.google.android.gms.internal.zzeyc;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import org.json.JSONException;

final class zzc
implements Runnable {
    private StorageReference zzoht;
    private TaskCompletionSource<StorageMetadata> zzohu;
    private StorageMetadata zzoih;
    private zzexr zzohv;

    public zzc(@NonNull StorageReference storageReference, @NonNull TaskCompletionSource<StorageMetadata> taskCompletionSource) {
        zzbq.checkNotNull((Object)storageReference);
        zzbq.checkNotNull(taskCompletionSource);
        this.zzoht = storageReference;
        this.zzohu = taskCompletionSource;
        this.zzohv = new zzexr(this.zzoht.getStorage().getApp(), this.zzoht.getStorage().getMaxOperationRetryTimeMillis());
    }

    @Override
    public final void run() {
        zzeyc zzeyc2;
        try {
            zzeyc2 = zzeyb.zzi(this.zzoht.getStorage().getApp()).zzw(this.zzoht.zzclr());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"GetMetadataTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            this.zzohu.setException((Exception)((Object)StorageException.fromException(remoteException)));
            return;
        }
        zzeyc zzeyc3 = zzeyc2;
        this.zzohv.zza(zzeyc3, true);
        if (zzeyc2.zzcmm()) {
            try {
                this.zzoih = new StorageMetadata.Builder(zzeyc2.zzcmp(), this.zzoht).build();
            }
            catch (RemoteException | JSONException throwable) {
                String string = String.valueOf(zzeyc2.zzcmk());
                Log.e((String)"GetMetadataTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata. ".concat(string) : new String("Unable to parse resulting metadata. ")), (Throwable)throwable);
                this.zzohu.setException((Exception)((Object)StorageException.fromException(throwable)));
                return;
            }
        }
        if (this.zzohu != null) {
            zzeyc2.zza(this.zzohu, this.zzoih);
        }
    }
}

