/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzfbd;
import com.google.android.gms.internal.zzfbm;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.GetTokenResult;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@Hide
public final class zzfbh {
    public static long zza(@Nullable String string) {
        if (string == null) {
            return 0L;
        }
        string = string.replaceAll("Z$", "-0000");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.getDefault());
        try {
            return simpleDateFormat.parse(string).getTime();
        }
        catch (ParseException parseException) {
            String string2 = String.valueOf(string);
            Log.w((String)"StorageUtil", (String)(string2.length() != 0 ? "unable to parse datetime:".concat(string2) : new String("unable to parse datetime:")), (Throwable)parseException);
            return 0L;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static Uri zza(@NonNull FirebaseApp var0, @Nullable String var1_1) throws UnsupportedEncodingException {
        block8: {
            if (TextUtils.isEmpty((CharSequence)var1_1)) {
                return null;
            }
            if (var1_1.toLowerCase().startsWith("gs://")) {
                var4_2 = zzfbd.zza((String)zzfbd.zzc((String)var1_1.substring(5)));
                v0 = String.valueOf(var4_2);
                return Uri.parse((String)(v0.length() != 0 ? "gs://".concat(v0) : new String("gs://")));
            }
            var4_3 = Uri.parse((String)var1_1);
            var5_4 = var4_3.getScheme();
            if (var5_4 == null) ** GOTO lbl39
            var11_5 = "http";
            if (zzbg.zza((Object)var5_4.toLowerCase(), (Object)"http")) break block8;
            var11_5 = "https";
            if (!zzbg.zza((Object)var5_4.toLowerCase(), (Object)"https")) ** GOTO lbl39
        }
        var6_6 = var4_3.getAuthority().toLowerCase();
        try {
            var7_7 = var6_6.indexOf(zzfbm.zza(var0).zza());
        }
        catch (RemoteException v1) {
            throw new UnsupportedEncodingException("Could not parse Url because the Storage network layer did not load");
        }
        var3_8 = zzfbd.zzb((String)var4_3.getEncodedPath());
        if (var7_7 != 0 || !var3_8.startsWith("/")) ** GOTO lbl33
        var8_9 = var3_8.indexOf("/b/", 0);
        var9_10 = var3_8.indexOf("/", var8_9 + 3);
        var10_11 = var3_8.indexOf("/o/", 0);
        if (var8_9 != -1 && var9_10 != -1) {
            var2_12 = var3_8.substring(var8_9 + 3, var9_10);
            var3_8 = var10_11 != -1 ? var3_8.substring(var10_11 + 3) : "";
        } else {
            Log.w((String)"StorageUtil", (String)"Firebase Storage URLs must point to an object in your Storage Bucket. Please obtain a URL using the Firebase Console or getDownloadUrl().");
            throw new IllegalArgumentException("Firebase Storage URLs must point to an object in your Storage Bucket. Please obtain a URL using the Firebase Console or getDownloadUrl().");
lbl33:
            // 1 sources

            if (var7_7 > 1) {
                var2_12 = var4_3.getAuthority().substring(0, var7_7 - 1);
            } else {
                Log.w((String)"StorageUtil", (String)"Firebase Storage URLs must point to an object in your Storage Bucket. Please obtain a URL using the Firebase Console or getDownloadUrl().");
                throw new IllegalArgumentException("Firebase Storage URLs must point to an object in your Storage Bucket. Please obtain a URL using the Firebase Console or getDownloadUrl().");
lbl39:
                // 2 sources

                v2 = String.valueOf(var5_4);
                Log.w((String)"StorageUtil", (String)(v2.length() != 0 ? "FirebaseStorage is unable to support the scheme:".concat(v2) : new String("FirebaseStorage is unable to support the scheme:")));
                throw new IllegalArgumentException("Uri scheme");
            }
        }
        zzbq.zza((String)var2_12, (Object)"No bucket specified");
        return new Uri.Builder().scheme("gs").authority(var2_12).encodedPath(var3_8).build();
    }

    @Nullable
    public static String zza(FirebaseApp firebaseApp) {
        Task task = firebaseApp.getToken(false);
        try {
            String string = ((GetTokenResult)Tasks.await((Task)task, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS)).getToken();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return string;
            }
            Log.w((String)"StorageUtil", (String)"no auth token for request");
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            String string = String.valueOf(exception);
            Log.e((String)"StorageUtil", (String)new StringBuilder(20 + String.valueOf(string).length()).append("error getting token ").append(string).toString());
        }
        return null;
    }
}

