/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzfbc;
import com.google.android.gms.internal.zzfbm;
import com.google.android.gms.internal.zzfbn;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzu;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDownloadTask
extends StorageTask<TaskSnapshot> {
    private final Uri zza;
    private long zzb;
    private StorageReference zzc;
    private zzfbc zzd;
    private long zze = -1L;
    private String zzf = null;
    private volatile Exception zzg = null;
    private long zzh = 0L;
    private int zzi;

    FileDownloadTask(@NonNull StorageReference storageReference, @NonNull Uri uri) {
        this.zzc = storageReference;
        this.zza = uri;
        this.zzd = new zzfbc(this.zzc.getStorage().getApp(), this.zzc.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final long zza() {
        return this.zze;
    }

    @Override
    @NonNull
    final StorageReference zzb() {
        return this.zzc;
    }

    @Override
    @Hide
    protected void schedule() {
        zzu.zzc(this.zzh());
    }

    private final int zza(InputStream inputStream, byte[] byArray) {
        int n;
        boolean bl = false;
        try {
            int n2;
            for (n = 0; n != byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) != -1; n += n2) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            this.zzg = iOException;
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    private final boolean zza(zzfbn zzfbn2) throws IOException {
        boolean bl = true;
        InputStream inputStream = zzfbn2.zzc();
        if (inputStream != null) {
            FileOutputStream fileOutputStream;
            Object object;
            File file = new File(this.zza.getPath());
            if (!file.exists()) {
                if (this.zzh > 0L) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.e((String)"FileDownloadTask", (String)(string.length() != 0 ? "The file downloading to has been deleted:".concat(string) : new String("The file downloading to has been deleted:")));
                    throw new IllegalStateException("expected a file to resume from.");
                }
                if (!file.createNewFile()) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.w((String)"FileDownloadTask", (String)(string.length() != 0 ? "unable to create file:".concat(string) : new String("unable to create file:")));
                }
            }
            if (this.zzh > 0L) {
                object = file.getAbsolutePath();
                long l = this.zzh;
                Log.d((String)"FileDownloadTask", (String)new StringBuilder(47 + String.valueOf(object).length()).append("Resuming download file ").append((String)object).append(" at ").append(l).toString());
                fileOutputStream = new FileOutputStream(file, true);
            } else {
                fileOutputStream = new FileOutputStream(file);
            }
            try {
                int n;
                object = new byte[262144];
                while (bl && (n = this.zza(inputStream, (byte[])object)) != -1) {
                    ((OutputStream)fileOutputStream).write((byte[])object, 0, n);
                    this.zzb += (long)n;
                    if (this.zzg != null) {
                        Log.d((String)"FileDownloadTask", (String)"Exception occurred during file download. Retrying.", (Throwable)this.zzg);
                        this.zzg = null;
                        bl = false;
                    }
                    if (this.zza(4, false)) continue;
                    bl = false;
                }
            }
            finally {
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                inputStream.close();
            }
        } else {
            this.zzg = new IllegalStateException("Unable to open Firebase Storage stream.");
            bl = false;
        }
        return bl;
    }

    @Override
    @Hide
    final void zzc() {
        if (this.zzg != null) {
            this.zza(64, false);
            return;
        }
        if (!this.zza(4, false)) {
            return;
        }
        do {
            Object object;
            zzfbn zzfbn2;
            this.zzb = 0L;
            this.zzg = null;
            this.zzd.zzb();
            try {
                zzfbn2 = zzfbm.zza(this.zzc.getStorage().getApp()).zza(this.zzc.zzb(), this.zzh);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"FileDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
                this.zzg = remoteException;
                this.zza(64, false);
                return;
            }
            this.zzd.zza(zzfbn2, false);
            this.zzi = zzfbn2.zzg();
            this.zzg = zzfbn2.zzf() != null ? zzfbn2.zzf() : this.zzg;
            int n = this.zzi;
            boolean bl = (n == 308 || n >= 200 && n < 300) && this.zzg == null && this.zzf() == 4;
            if (bl) {
                this.zze = zzfbn2.zzi();
                object = zzfbn2.zza("ETag");
                if (!TextUtils.isEmpty((CharSequence)object) && this.zzf != null && !this.zzf.equals(object)) {
                    Log.w((String)"FileDownloadTask", (String)"The file at the server has changed.  Restarting from the beginning.");
                    this.zzh = 0L;
                    this.zzf = null;
                    zzfbn2.zzb();
                    ((StorageTask)this).schedule();
                    return;
                }
                this.zzf = object;
                try {
                    bl = this.zza(zzfbn2);
                }
                catch (IOException iOException) {
                    Log.e((String)"FileDownloadTask", (String)"Exception occurred during file write.  Aborting.", (Throwable)iOException);
                    this.zzg = iOException;
                }
            }
            zzfbn2.zzb();
            if (bl && this.zzg == null && this.zzf() == 4) {
                this.zza(128, false);
                return;
            }
            object = new File(this.zza.getPath());
            this.zzh = ((File)object).exists() ? ((File)object).length() : 0L;
            if (this.zzf() == 8) {
                this.zza(16, false);
                return;
            }
            if (this.zzf() != 32) continue;
            if (!this.zza(256, false)) {
                int n2 = this.zzf();
                Log.w((String)"FileDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n2).toString());
            }
            return;
        } while (this.zzb > 0L);
        this.zza(64, false);
    }

    @Override
    protected void onCanceled() {
        this.zzd.zza();
        this.zzg = StorageException.fromErrorStatus(Status.zze);
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzd() {
        FileDownloadTask fileDownloadTask = this;
        return new TaskSnapshot(fileDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(fileDownloadTask.zzg, fileDownloadTask.zzi)), fileDownloadTask.zzb + fileDownloadTask.zzh);
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zza;
        private /* synthetic */ FileDownloadTask zzb;

        TaskSnapshot(@Nullable FileDownloadTask fileDownloadTask, Exception exception, long l) {
            this.zzb = fileDownloadTask;
            super(fileDownloadTask, exception);
            this.zza = l;
        }

        public long getBytesTransferred() {
            return this.zza;
        }

        public long getTotalByteCount() {
            return this.zzb.zza();
        }
    }
}

