/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzfbd;
import com.google.android.gms.internal.zzfbh;
import com.google.android.gms.internal.zzfbm;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzd;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String zza = null;
    private FirebaseStorage zzb = null;
    private StorageReference zzc = null;
    private String zzd = null;
    private String zze = null;
    private zza<String> zzf = com.google.firebase.storage.StorageMetadata$zza.zza("");
    private String zzg = null;
    private String zzh = null;
    private String zzi = null;
    private long zzj;
    private String zzk = null;
    private zza<String> zzl = com.google.firebase.storage.StorageMetadata$zza.zza("");
    private zza<String> zzm = com.google.firebase.storage.StorageMetadata$zza.zza("");
    private zza<String> zzn = com.google.firebase.storage.StorageMetadata$zza.zza("");
    private zza<String> zzo = com.google.firebase.storage.StorageMetadata$zza.zza("");
    private zza<Map<String, String>> zzp = com.google.firebase.storage.StorageMetadata$zza.zza(Collections.emptyMap());
    private String[] zzq = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzbq.zza((Object)storageMetadata);
        this.zza = storageMetadata.zza;
        this.zzb = storageMetadata.zzb;
        this.zzc = storageMetadata.zzc;
        this.zzd = storageMetadata.zzd;
        this.zzf = storageMetadata.zzf;
        this.zzl = storageMetadata.zzl;
        this.zzm = storageMetadata.zzm;
        this.zzn = storageMetadata.zzn;
        this.zzo = storageMetadata.zzo;
        this.zzp = storageMetadata.zzp;
        this.zzq = storageMetadata.zzq;
        if (bl) {
            this.zzk = storageMetadata.zzk;
            this.zzj = storageMetadata.zzj;
            this.zzi = storageMetadata.zzi;
            this.zzh = storageMetadata.zzh;
            this.zzg = storageMetadata.zzg;
            this.zze = storageMetadata.zze;
        }
    }

    public String getContentType() {
        return this.zzf.zzb();
    }

    public String getCustomMetadata(@NonNull String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.zzp.zzb().get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        return this.zzp.zzb().keySet();
    }

    @NonNull
    public String getPath() {
        if (this.zza != null) {
            return this.zza;
        }
        return "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.zzd;
    }

    @Nullable
    public String getGeneration() {
        return this.zze;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.zzg;
    }

    public long getCreationTimeMillis() {
        return zzfbh.zza(this.zzh);
    }

    public long getUpdatedTimeMillis() {
        return zzfbh.zza(this.zzi);
    }

    public long getSizeBytes() {
        return this.zzj;
    }

    @Nullable
    public String getMd5Hash() {
        return this.zzk;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.zzq != null && this.zzc != null) {
            try {
                String string = zzfbm.zza(this.zzc.getStorage().getApp()).zzc(this.zzc.zzb());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    String[] stringArray = this.zzq;
                    int n = this.zzq.length;
                    for (int i = 0; i < n; ++i) {
                        String string2 = stringArray[i];
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.zzl.zzb();
    }

    @Nullable
    public String getContentDisposition() {
        return this.zzm.zzb();
    }

    @Nullable
    public String getContentEncoding() {
        return this.zzn.zzb();
    }

    @Nullable
    public String getContentLanguage() {
        return this.zzo.zzb();
    }

    @Nullable
    public StorageReference getReference() {
        if (this.zzc == null && this.zzb != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(zzfbd.zza((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.zzb);
        }
        return this.zzc;
    }

    @NonNull
    final JSONObject zza() throws JSONException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.zzf.zza()) {
            hashMap.put("contentType", this.getContentType());
        }
        if (this.zzp.zza()) {
            hashMap.put("metadata", (String)new JSONObject(this.zzp.zzb()));
        }
        if (this.zzl.zza()) {
            hashMap.put("cacheControl", this.getCacheControl());
        }
        if (this.zzm.zza()) {
            hashMap.put("contentDisposition", this.getContentDisposition());
        }
        if (this.zzn.zza()) {
            hashMap.put("contentEncoding", this.getContentEncoding());
        }
        if (this.zzo.zza()) {
            hashMap.put("contentLanguage", this.getContentLanguage());
        }
        return new JSONObject(hashMap);
    }

    private final void zza(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.zzq = string.split(",");
        }
    }

    /* synthetic */ StorageMetadata(StorageMetadata storageMetadata, boolean bl, zzd zzd2) {
        this(storageMetadata, bl);
    }

    public static class Builder {
        private StorageMetadata zza;
        private boolean zzb;

        public Builder() {
            this.zza = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.zza = new StorageMetadata(storageMetadata, false, null);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.zza.zzc = storageReference;
        }

        private Builder(JSONObject jSONObject) throws JSONException {
            this.zza = new StorageMetadata();
            if (jSONObject != null) {
                this.zza(jSONObject);
                this.zzb = true;
            }
        }

        @Nullable
        private static String zza(JSONObject jSONObject, String string) throws JSONException {
            if (jSONObject.has(string) && !jSONObject.isNull(string)) {
                return jSONObject.getString(string);
            }
            return null;
        }

        private final void zza(JSONObject jSONObject) throws JSONException {
            String string;
            this.zza.zze = jSONObject.optString("generation");
            this.zza.zza = jSONObject.optString("name");
            this.zza.zzd = jSONObject.optString("bucket");
            this.zza.zzg = jSONObject.optString("metageneration");
            this.zza.zzh = jSONObject.optString("timeCreated");
            this.zza.zzi = jSONObject.optString("updated");
            this.zza.zzj = jSONObject.optLong("size");
            this.zza.zzk = jSONObject.optString("md5Hash");
            this.zza.zza(jSONObject.optString("downloadTokens"));
            if (jSONObject.has("metadata") && !jSONObject.isNull("metadata")) {
                string = jSONObject.getJSONObject("metadata");
                Iterator iterator = string.keys();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    this.setCustomMetadata(string2, string.getString(string2));
                }
            }
            if ((string = Builder.zza(jSONObject, "contentType")) != null) {
                this.setContentType(string);
            }
            if ((string = Builder.zza(jSONObject, "cacheControl")) != null) {
                this.setCacheControl(string);
            }
            if ((string = Builder.zza(jSONObject, "contentDisposition")) != null) {
                this.setContentDisposition(string);
            }
            if ((string = Builder.zza(jSONObject, "contentEncoding")) != null) {
                this.setContentEncoding(string);
            }
            if ((string = Builder.zza(jSONObject, "contentLanguage")) != null) {
                this.setContentLanguage(string);
            }
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.zza, this.zzb, null);
        }

        public Builder setContentLanguage(@Nullable String string) {
            this.zza.zzo = com.google.firebase.storage.StorageMetadata$zza.zzb(string);
            return this;
        }

        public Builder setContentEncoding(@Nullable String string) {
            this.zza.zzn = com.google.firebase.storage.StorageMetadata$zza.zzb(string);
            return this;
        }

        public Builder setContentDisposition(@Nullable String string) {
            this.zza.zzm = com.google.firebase.storage.StorageMetadata$zza.zzb(string);
            return this;
        }

        public Builder setCacheControl(@Nullable String string) {
            this.zza.zzl = com.google.firebase.storage.StorageMetadata$zza.zzb(string);
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (!this.zza.zzp.zza()) {
                this.zza.zzp = com.google.firebase.storage.StorageMetadata$zza.zzb(new HashMap());
            }
            ((Map)this.zza.zzp.zzb()).put(string, string2);
            return this;
        }

        public Builder setContentType(@Nullable String string) {
            this.zza.zzf = com.google.firebase.storage.StorageMetadata$zza.zzb(string);
            return this;
        }
    }

    static final class zza<T> {
        private final boolean zza;
        @Nullable
        private final T zzb;

        private zza(@Nullable T t, boolean bl) {
            this.zza = bl;
            this.zzb = t;
        }

        static <T> zza<T> zza(T t) {
            return new zza<T>(t, false);
        }

        static <T> zza<T> zzb(@Nullable T t) {
            return new zza<T>(t, true);
        }

        final boolean zza() {
            return this.zza;
        }

        @Nullable
        final T zzb() {
            return this.zzb;
        }
    }
}

