/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.CancellableTask;
import com.google.firebase.storage.ControllableTask;
import com.google.firebase.storage.OnPausedListener;
import com.google.firebase.storage.OnProgressListener;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzj;
import com.google.firebase.storage.zzk;
import com.google.firebase.storage.zzl;
import com.google.firebase.storage.zzm;
import com.google.firebase.storage.zzn;
import com.google.firebase.storage.zzo;
import com.google.firebase.storage.zzp;
import com.google.firebase.storage.zzs;
import com.google.firebase.storage.zzt;
import com.google.firebase.storage.zzx;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executor;

public abstract class StorageTask<TResult extends ProvideError>
extends ControllableTask<TResult> {
    private static final HashMap<Integer, HashSet<Integer>> zza = new HashMap();
    private static final HashMap<Integer, HashSet<Integer>> zzb = new HashMap();
    protected final Object mSyncObject = new Object();
    @VisibleForTesting
    private zzx<OnSuccessListener<? super TResult>, TResult> zzc = new zzx(this, 128, new zzj(this));
    @VisibleForTesting
    private zzx<OnFailureListener, TResult> zzd = new zzx(this, 320, new zzk(this));
    @VisibleForTesting
    private zzx<OnCompleteListener<TResult>, TResult> zze = new zzx(this, 448, new zzl(this));
    @VisibleForTesting
    private zzx<OnProgressListener<? super TResult>, TResult> zzf = new zzx(this, -465, new zzm(this));
    @VisibleForTesting
    private zzx<OnPausedListener<? super TResult>, TResult> zzg = new zzx(this, 16, new zzn(this));
    private volatile int zzh = 1;
    private TResult zzi;

    protected StorageTask() {
    }

    @VisibleForTesting
    final boolean zze() {
        if (this.zza(2, false)) {
            this.schedule();
            return true;
        }
        return false;
    }

    @VisibleForTesting
    void resetState() {
    }

    @VisibleForTesting
    abstract StorageReference zzb();

    @Hide
    @VisibleForTesting
    abstract void schedule();

    @Override
    public boolean resume() {
        if (this.zza(2, true)) {
            this.resetState();
            this.schedule();
            return true;
        }
        return false;
    }

    @Override
    public boolean pause() {
        return this.zza(new int[]{16, 8}, true);
    }

    @Override
    public boolean cancel() {
        return this.zza(new int[]{256, 32}, true);
    }

    public boolean isComplete() {
        return (this.zzh & 0x80) != 0 || (this.zzh & 0x140) != 0;
    }

    public boolean isSuccessful() {
        return (this.zzh & 0x80) != 0;
    }

    @Override
    public boolean isCanceled() {
        return this.zzh == 256;
    }

    @Override
    public boolean isInProgress() {
        return (this.zzh & 0xFFFFFE2F) != 0;
    }

    @Override
    public boolean isPaused() {
        return (this.zzh & 0x10) != 0;
    }

    public TResult getResult() {
        if (this.zza() == null) {
            throw new IllegalStateException();
        }
        Exception exception = this.zza().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.zza();
    }

    public <X extends Throwable> TResult getResult(@NonNull Class<X> clazz) throws X {
        if (this.zza() == null) {
            throw new IllegalStateException();
        }
        if (clazz.isInstance(this.zza().getError())) {
            throw (Throwable)clazz.cast(this.zza().getError());
        }
        Exception exception = this.zza().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.zza();
    }

    @Nullable
    public Exception getException() {
        if (this.zza() == null) {
            return null;
        }
        return this.zza().getError();
    }

    public TResult getSnapshot() {
        return this.zzg();
    }

    @VisibleForTesting
    final int zzf() {
        return this.zzh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @VisibleForTesting
    final TResult zzg() {
        Object object = this.mSyncObject;
        synchronized (object) {
            return this.zzd();
        }
    }

    @NonNull
    @VisibleForTesting
    abstract TResult zzd();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final boolean zza(int[] nArray, boolean bl) {
        HashMap<Integer, HashSet<Integer>> hashMap = bl ? zza : zzb;
        Object object = this.mSyncObject;
        synchronized (object) {
            Object object2 = nArray;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = object2[i];
                HashSet<Integer> hashSet = hashMap.get(this.zzh);
                if (hashSet == null || !hashSet.contains(n2)) continue;
                this.zzh = n2;
                switch (this.zzh) {
                    case 2: {
                        zzt.zza().zza(this);
                        this.onQueued();
                        break;
                    }
                    case 4: {
                        this.onProgress();
                        break;
                    }
                    case 16: {
                        this.onPaused();
                        break;
                    }
                    case 64: {
                        this.onFailure();
                        break;
                    }
                    case 128: {
                        this.onSuccess();
                        break;
                    }
                    case 256: {
                        this.onCanceled();
                    }
                }
                this.zzc.zza();
                this.zzd.zza();
                this.zze.zza();
                this.zzg.zza();
                this.zzf.zza();
                if (Log.isLoggable((String)"StorageTask", (int)3)) {
                    String string = StorageTask.zza(n2);
                    String string2 = StorageTask.zza(this.zzh);
                    Log.d((String)"StorageTask", (String)new StringBuilder(53 + String.valueOf(string).length() + String.valueOf(string2).length()).append("changed internal state to: ").append(string).append(" isUser: ").append(bl).append(" from state:").append(string2).toString());
                }
                return true;
            }
            object2 = StorageTask.zza(nArray);
            String string = StorageTask.zza(this.zzh);
            Log.w((String)"StorageTask", (String)new StringBuilder(62 + String.valueOf(object2).length() + String.valueOf(string).length()).append("unable to change internal state to: ").append((String)object2).append(" isUser: ").append(bl).append(" from state:").append(string).toString());
            return false;
        }
    }

    @VisibleForTesting
    final boolean zza(int n, boolean bl) {
        return this.zza(new int[]{n}, bl);
    }

    protected void onQueued() {
    }

    protected void onProgress() {
    }

    protected void onPaused() {
    }

    protected void onFailure() {
    }

    protected void onSuccess() {
    }

    protected void onCanceled() {
    }

    private final TResult zza() {
        if (this.zzi != null) {
            return this.zzi;
        }
        if (!this.isComplete()) {
            return null;
        }
        if (this.zzi == null) {
            this.zzi = this.zzg();
        }
        return this.zzi;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbq.zza(onPausedListener);
        this.zzg.zza(null, null, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Executor executor, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbq.zza(onPausedListener);
        zzbq.zza((Object)executor);
        this.zzg.zza(null, executor, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Activity activity, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbq.zza(onPausedListener);
        zzbq.zza((Object)activity);
        this.zzg.zza(activity, null, onPausedListener);
        return this;
    }

    public StorageTask<TResult> removeOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzbq.zza(onPausedListener);
        this.zzg.zza(onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbq.zza(onProgressListener);
        this.zzf.zza(null, null, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Executor executor, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbq.zza(onProgressListener);
        zzbq.zza((Object)executor);
        this.zzf.zza(null, executor, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Activity activity, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbq.zza(onProgressListener);
        zzbq.zza((Object)activity);
        this.zzf.zza(activity, null, onProgressListener);
        return this;
    }

    public StorageTask<TResult> removeOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzbq.zza(onProgressListener);
        this.zzf.zza(onProgressListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbq.zza(onSuccessListener);
        this.zzc.zza(null, null, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbq.zza((Object)executor);
        zzbq.zza(onSuccessListener);
        this.zzc.zza(null, executor, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Activity activity, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbq.zza((Object)activity);
        zzbq.zza(onSuccessListener);
        this.zzc.zza(activity, null, onSuccessListener);
        return this;
    }

    public StorageTask<TResult> removeOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzbq.zza(onSuccessListener);
        this.zzc.zza(onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzbq.zza((Object)onFailureListener);
        this.zzd.zza(null, null, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener onFailureListener) {
        zzbq.zza((Object)onFailureListener);
        zzbq.zza((Object)executor);
        this.zzd.zza(null, executor, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Activity activity, @NonNull OnFailureListener onFailureListener) {
        zzbq.zza((Object)onFailureListener);
        zzbq.zza((Object)activity);
        this.zzd.zza(activity, null, onFailureListener);
        return this;
    }

    public StorageTask<TResult> removeOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzbq.zza((Object)onFailureListener);
        this.zzd.zza(onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbq.zza(onCompleteListener);
        this.zze.zza(null, null, onCompleteListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull Executor executor, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbq.zza(onCompleteListener);
        zzbq.zza((Object)executor);
        this.zze.zza(null, executor, onCompleteListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnCompleteListener(@NonNull Activity activity, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbq.zza(onCompleteListener);
        zzbq.zza((Object)activity);
        this.zze.zza(activity, null, onCompleteListener);
        return this;
    }

    public StorageTask<TResult> removeOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzbq.zza(onCompleteListener);
        this.zze.zza(onCompleteListener);
        return this;
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.zza(null, continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        return this.zza(executor, continuation);
    }

    @NonNull
    private final <TContinuationResult> Task<TContinuationResult> zza(@Nullable Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zze.zza(null, executor, new zzo(this, continuation, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.zzb(null, continuation);
    }

    @NonNull
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.zzb(executor, continuation);
    }

    @NonNull
    private final <TContinuationResult> Task<TContinuationResult> zzb(@Nullable Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zze.zza(null, executor, new zzp(this, continuation, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @VisibleForTesting
    abstract void zzc();

    @VisibleForTesting
    final Runnable zzh() {
        return new zzs(this);
    }

    private final void zzi() {
        if (!(this.isComplete() || ((ControllableTask)this).isPaused() || this.zzh == 2 || this.zza(256, false))) {
            this.zza(64, false);
        }
    }

    private static String zza(int[] nArray) {
        if (nArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            stringBuilder.append(StorageTask.zza(n2)).append(", ");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2);
    }

    private static String zza(int n) {
        switch (n) {
            case 1: {
                return "INTERNAL_STATE_NOT_STARTED";
            }
            case 2: {
                return "INTERNAL_STATE_QUEUED";
            }
            case 4: {
                return "INTERNAL_STATE_IN_PROGRESS";
            }
            case 8: {
                return "INTERNAL_STATE_PAUSING";
            }
            case 16: {
                return "INTERNAL_STATE_PAUSED";
            }
            case 32: {
                return "INTERNAL_STATE_CANCELING";
            }
            case 64: {
                return "INTERNAL_STATE_FAILURE";
            }
            case 128: {
                return "INTERNAL_STATE_SUCCESS";
            }
            case 256: {
                return "INTERNAL_STATE_CANCELED";
            }
        }
        return "Unknown Internal State!";
    }

    static /* synthetic */ void zza(StorageTask storageTask) {
        storageTask.zzi();
    }

    static {
        zza.put(1, new HashSet<Integer>(Arrays.asList(16, 256)));
        zza.put(2, new HashSet<Integer>(Arrays.asList(8, 32)));
        zza.put(4, new HashSet<Integer>(Arrays.asList(8, 32)));
        zza.put(16, new HashSet<Integer>(Arrays.asList(2, 256)));
        zza.put(64, new HashSet<Integer>(Arrays.asList(2, 256)));
        zzb.put(1, new HashSet<Integer>(Arrays.asList(2, 64)));
        zzb.put(2, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        zzb.put(4, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        zzb.put(8, new HashSet<Integer>(Arrays.asList(16, 64, 128)));
        zzb.put(32, new HashSet<Integer>(Arrays.asList(256, 64, 128)));
    }

    public class SnapshotBase
    implements ProvideError {
        private final Exception zza;
        private /* synthetic */ StorageTask zzb;

        public SnapshotBase(@Nullable StorageTask storageTask, Exception exception) {
            this.zzb = storageTask;
            if (exception == null) {
                if (((CancellableTask)storageTask).isCanceled()) {
                    this.zza = StorageException.fromErrorStatus(Status.zze);
                    return;
                }
                if (storageTask.zzf() == 64) {
                    this.zza = StorageException.fromErrorStatus(Status.zzc);
                    return;
                }
                this.zza = null;
                return;
            }
            this.zza = exception;
        }

        @NonNull
        public StorageTask<TResult> getTask() {
            return this.zzb;
        }

        @NonNull
        public StorageReference getStorage() {
            return this.getTask().zzb();
        }

        @Override
        @Nullable
        public Exception getError() {
            return this.zza;
        }
    }

    public static interface ProvideError {
        public Exception getError();
    }
}

