/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzfbc;
import com.google.android.gms.internal.zzfbn;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzu;
import com.google.firebase.storage.zzw;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference zza;
    private zzfbc zzb;
    private volatile Exception zzc = null;
    private volatile int zzd = 0;
    private StreamProcessor zze;
    private long zzf = -1L;
    private long zzg;
    private long zzh;
    private InputStream zzi;
    private zzfbn zzj;
    private String zzk;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.zza = storageReference;
        this.zzb = new zzfbc(this.zza.getStorage().getApp(), this.zza.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzbq.zza((Object)streamProcessor);
        zzbq.zza((this.zze == null ? 1 : 0) != 0);
        this.zze = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    final StorageReference zzb() {
        return this.zza;
    }

    final long zza() {
        return this.zzf;
    }

    final void zza(long l) {
        this.zzg += l;
        if (this.zzh + 262144L <= this.zzg) {
            if (this.zzf() == 4) {
                this.zza(4, false);
                return;
            }
            this.zzh = this.zzg;
        }
    }

    @Override
    @Hide
    protected void schedule() {
        zzu.zzc(this.zzh());
    }

    private final InputStream zzi() throws Exception {
        this.zzb.zzb();
        if (this.zzj != null) {
            this.zzj.zzb();
        }
        try {
            this.zzj = this.zza.zza().zza(this.zza.zzb(), this.zzg);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            throw remoteException;
        }
        this.zzb.zza(this.zzj, false);
        this.zzd = this.zzj.zzg();
        this.zzc = this.zzj.zzf() != null ? this.zzj.zzf() : this.zzc;
        int n = this.zzd;
        if ((n == 308 || n >= 200 && n < 300) && this.zzc == null && this.zzf() == 4) {
            String string = this.zzj.zza("ETag");
            if (!TextUtils.isEmpty((CharSequence)string) && this.zzk != null && !this.zzk.equals(string)) {
                this.zzd = 409;
                throw new IOException("The ETag on the server changed.");
            }
            this.zzk = string;
            if (this.zzf == -1L) {
                this.zzf = this.zzj.zzi();
            }
            return this.zzj.zzc();
        }
        throw new IOException("Could not open resulting stream.");
    }

    @Override
    @Hide
    final void zzc() {
        if (this.zzc != null) {
            this.zza(64, false);
            return;
        }
        if (!this.zza(4, false)) {
            return;
        }
        zza zza2 = new zza(new zzw(this), this);
        this.zzi = new BufferedInputStream(zza2);
        try {
            zza2.zzb();
            if (this.zze != null) {
                try {
                    this.zze.doInBackground((TaskSnapshot)this.zzg(), this.zzi);
                }
                catch (Exception exception) {
                    Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                    this.zzc = exception;
                }
            }
        }
        catch (IOException iOException) {
            Log.d((String)"StreamDownloadTask", (String)"Initial opening of Stream failed", (Throwable)iOException);
            this.zzc = iOException;
        }
        if (this.zzi == null) {
            this.zzj.zzb();
            this.zzj = null;
        }
        if (this.zzc == null && this.zzf() == 4) {
            this.zza(4, false);
            this.zza(128, false);
            return;
        }
        if (!this.zza(this.zzf() == 32 ? 256 : 64, false)) {
            int n = this.zzf();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    @Hide
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    @Hide
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    protected void onCanceled() {
        this.zzb.zza();
        this.zzc = StorageException.fromErrorStatus(Status.zze);
    }

    @Override
    protected void onProgress() {
        this.zzh = this.zzg;
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzd() {
        StreamDownloadTask streamDownloadTask = this;
        return new TaskSnapshot(streamDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(streamDownloadTask.zzc, streamDownloadTask.zzd)), streamDownloadTask.zzh);
    }

    static /* synthetic */ InputStream zza(StreamDownloadTask streamDownloadTask) throws Exception {
        return streamDownloadTask.zzi();
    }

    static /* synthetic */ zzfbn zza(StreamDownloadTask streamDownloadTask, zzfbn zzfbn2) {
        streamDownloadTask.zzj = null;
        return null;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zza;
        private /* synthetic */ StreamDownloadTask zzb;

        TaskSnapshot(@Nullable StreamDownloadTask streamDownloadTask, Exception exception, long l) {
            this.zzb = streamDownloadTask;
            super(streamDownloadTask, exception);
            this.zza = l;
        }

        public long getBytesTransferred() {
            return this.zza;
        }

        public long getTotalByteCount() {
            return this.zzb.zza();
        }

        public InputStream getStream() {
            return this.zzb.zzi;
        }
    }

    static final class zza
    extends InputStream {
        @Nullable
        private StreamDownloadTask zza;
        @Nullable
        private InputStream zzb;
        private Callable<InputStream> zzc;
        private IOException zzd;
        private int zze;
        private int zzf;
        private boolean zzg;

        zza(@NonNull Callable<InputStream> callable, @Nullable StreamDownloadTask streamDownloadTask) {
            this.zza = streamDownloadTask;
            this.zzc = callable;
        }

        private final void zza() throws IOException {
            if (this.zza != null && this.zza.zzf() == 32) {
                throw new com.google.firebase.storage.zza();
            }
        }

        private final void zza(long l) {
            if (this.zza != null) {
                this.zza.zza(l);
            }
            this.zze = (int)((long)this.zze + l);
        }

        private final boolean zzb() throws IOException {
            this.zza();
            if (this.zzd != null) {
                try {
                    if (this.zzb != null) {
                        this.zzb.close();
                    }
                }
                catch (IOException iOException) {}
                this.zzb = null;
                if (this.zzf == this.zze) {
                    Log.i((String)"StreamDownloadTask", (String)"Encountered exception during stream operation. Aborting.", (Throwable)this.zzd);
                    return false;
                }
                int n = this.zze;
                Log.i((String)"StreamDownloadTask", (String)new StringBuilder(70).append("Encountered exception during stream operation. Retrying at ").append(n).toString(), (Throwable)this.zzd);
                this.zzf = this.zze;
                this.zzd = null;
            }
            if (this.zzg) {
                throw new IOException("Can't perform operation on closed stream");
            }
            if (this.zzb == null) {
                try {
                    this.zzb = this.zzc.call();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    if (exception instanceof IOException) {
                        throw (IOException)exception2;
                    }
                    throw new IOException("Unable to open stream", exception2);
                }
            }
            return true;
        }

        @Override
        public final int read() throws IOException {
            while (this.zzb()) {
                try {
                    int n = this.zzb.read();
                    if (n != -1) {
                        this.zza(1L);
                    }
                    return n;
                }
                catch (IOException iOException) {
                    this.zzd = iOException;
                }
            }
            throw this.zzd;
        }

        @Override
        public final int available() throws IOException {
            while (this.zzb()) {
                try {
                    return this.zzb.available();
                }
                catch (IOException iOException) {
                    this.zzd = iOException;
                }
            }
            throw this.zzd;
        }

        @Override
        public final void close() throws IOException {
            if (this.zzb != null) {
                this.zzb.close();
            }
            this.zzg = true;
            if (this.zza != null && this.zza.zzj != null) {
                this.zza.zzj.zzb();
                StreamDownloadTask.zza(this.zza, null);
            }
            this.zza();
        }

        @Override
        public final void mark(int n) {
        }

        @Override
        public final boolean markSupported() {
            return false;
        }

        @Override
        public final int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (this.zzb()) {
                try {
                    int n4;
                    while ((long)n2 > 262144L) {
                        n4 = this.zzb.read(byArray, n, 262144);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        this.zza(n4);
                        this.zza();
                    }
                    if (n2 > 0) {
                        n4 = this.zzb.read(byArray, n, n2);
                        if (n4 == -1) {
                            if (n3 == 0) {
                                return -1;
                            }
                            return n3;
                        }
                        n += n4;
                        n3 += n4;
                        n2 -= n4;
                        this.zza(n4);
                    }
                    if (n2 != 0) continue;
                    return n3;
                }
                catch (IOException iOException) {
                    this.zzd = iOException;
                }
            }
            throw this.zzd;
        }

        @Override
        public final long skip(long l) throws IOException {
            int n = 0;
            while (this.zzb()) {
                try {
                    long l2;
                    while (l > 262144L) {
                        l2 = this.zzb.skip(262144L);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zza(l2);
                        this.zza();
                    }
                    if (l > 0L) {
                        l2 = this.zzb.skip(l);
                        if (l2 < 0L) {
                            if (n == 0) {
                                return -1L;
                            }
                            return n;
                        }
                        n = (int)((long)n + l2);
                        l -= l2;
                        this.zza(l2);
                    }
                    if (l != 0L) continue;
                    return n;
                }
                catch (IOException iOException) {
                    this.zzd = iOException;
                }
            }
            throw this.zzd;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

