/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzfbb;
import com.google.android.gms.internal.zzfbc;
import com.google.android.gms.internal.zzfbh;
import com.google.android.gms.internal.zzfbn;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzad;
import com.google.firebase.storage.zzu;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference zza;
    private final Uri zzb;
    private final long zzc;
    private final zzfbb zzd;
    private final AtomicLong zze;
    private int zzf;
    private zzfbc zzg;
    private boolean zzh;
    private volatile StorageMetadata zzi;
    private volatile Uri zzj;
    private volatile Exception zzk;
    private volatile Exception zzl;
    private volatile int zzm;
    private volatile String zzn;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        this.zze = new AtomicLong(0L);
        this.zzf = 262144;
        this.zzj = null;
        this.zzk = null;
        this.zzl = null;
        this.zzm = 0;
        zzbq.zza((Object)storageReference);
        zzbq.zza((Object)byArray);
        this.zzc = byArray.length;
        this.zza = storageReference;
        this.zzi = storageMetadata;
        this.zzb = null;
        this.zzd = new zzfbb(new ByteArrayInputStream(byArray), 262144);
        this.zzh = true;
        this.zzg = new zzfbc(this.zza.getStorage().getApp(), this.zza.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        long l;
        InputStream inputStream;
        block10: {
            this.zze = new AtomicLong(0L);
            this.zzf = 262144;
            this.zzj = null;
            this.zzk = null;
            this.zzl = null;
            this.zzm = 0;
            zzbq.zza((Object)storageReference);
            zzbq.zza((Object)uri);
            this.zza = storageReference;
            this.zzi = storageMetadata;
            this.zzb = uri;
            inputStream = null;
            this.zzg = new zzfbc(this.zza.getStorage().getApp(), this.zza.getStorage().getMaxUploadRetryTimeMillis());
            l = -1L;
            try {
                ContentResolver contentResolver = this.zza.getStorage().getApp().getApplicationContext().getContentResolver();
                try {
                    ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.zzb, "r");
                    if (parcelFileDescriptor != null) {
                        l = parcelFileDescriptor.getStatSize();
                        parcelFileDescriptor.close();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                    l = -1L;
                }
                catch (IOException iOException) {
                    String string = String.valueOf(this.zzb.toString());
                    Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")), (Throwable)iOException);
                }
                inputStream = contentResolver.openInputStream(this.zzb);
                if (inputStream == null) break block10;
                if (l == -1L) {
                    try {
                        int n = inputStream.available();
                        if (n >= 0) {
                            l = n;
                        }
                    }
                    catch (IOException iOException) {}
                }
                inputStream = new BufferedInputStream(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = String.valueOf(this.zzb.toString());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
                this.zzk = fileNotFoundException;
            }
        }
        this.zzc = l;
        this.zzd = new zzfbb(inputStream, 262144);
        this.zzh = true;
        this.zzj = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        this.zze = new AtomicLong(0L);
        this.zzf = 262144;
        this.zzj = null;
        this.zzk = null;
        this.zzl = null;
        this.zzm = 0;
        zzbq.zza((Object)storageReference);
        zzbq.zza((Object)inputStream);
        this.zzc = -1L;
        this.zza = storageReference;
        this.zzi = storageMetadata;
        this.zzd = new zzfbb(inputStream, 262144);
        this.zzh = false;
        this.zzb = null;
        this.zzg = new zzfbc(this.zza.getStorage().getApp(), this.zza.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    final StorageReference zzb() {
        return this.zza;
    }

    final long zza() {
        return this.zzc;
    }

    @Override
    protected void schedule() {
        zzu.zzb(this.zzh());
    }

    @Override
    @Hide
    final void zzc() {
        zzfbn zzfbn2;
        UploadTask uploadTask;
        block24: {
            this.zzg.zzb();
            if (!this.zza(4, false)) {
                Log.d((String)"UploadTask", (String)"The upload cannot continue as it is not in a valid state.");
                return;
            }
            if (this.zza.getParent() == null) {
                this.zzk = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
            }
            if (this.zzk != null) {
                return;
            }
            if (this.zzj == null) {
                String string;
                uploadTask = this;
                String string2 = null;
                if (uploadTask.zzi != null) {
                    string2 = uploadTask.zzi.getContentType();
                }
                if (uploadTask.zzb != null && TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = uploadTask.zza.getStorage().getApp().getApplicationContext().getContentResolver().getType(uploadTask.zzb);
                }
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = "application/octet-stream";
                }
                try {
                    zzfbn2 = uploadTask.zza.zza().zza(uploadTask.zza.zzb(), uploadTask.zzi != null ? uploadTask.zzi.zza() : null, string2);
                }
                catch (RemoteException | JSONException throwable) {
                    Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
                    uploadTask.zzk = throwable;
                    break block24;
                }
                if (uploadTask.zzb(zzfbn2) && !TextUtils.isEmpty((CharSequence)(string = zzfbn2.zza("X-Goog-Upload-URL")))) {
                    uploadTask.zzj = Uri.parse((String)string);
                }
            } else {
                this.zza(false);
            }
        }
        boolean bl = this.zzi();
        while (bl) {
            block25: {
                uploadTask = this;
                try {
                    uploadTask.zzd.zzb(uploadTask.zzf);
                    int n = Math.min(uploadTask.zzf, uploadTask.zzd.zza());
                    try {
                        zzfbn2 = uploadTask.zza.zza().zza(uploadTask.zza.zzb(), uploadTask.zzj.toString(), uploadTask.zzd.zzb(), uploadTask.zze.get(), n, uploadTask.zzd.zzc());
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
                        uploadTask.zzk = remoteException;
                        break block25;
                    }
                    if (!uploadTask.zza(zzfbn2)) {
                        int n2 = uploadTask.zzf = 262144;
                        Log.d((String)"UploadTask", (String)new StringBuilder(35).append("Resetting chunk size to ").append(n2).toString());
                        break block25;
                    }
                    uploadTask.zze.getAndAdd(n);
                    if (!uploadTask.zzd.zzc()) {
                        uploadTask.zzd.zza(n);
                        if (uploadTask.zzf < 0x2000000) {
                            uploadTask.zzf <<= 1;
                            int n3 = uploadTask.zzf;
                            Log.d((String)"UploadTask", (String)new StringBuilder(36).append("Increasing chunk size to ").append(n3).toString());
                        }
                        break block25;
                    }
                    try {
                        uploadTask.zzi = new StorageMetadata.Builder(zzfbn2.zzd(), uploadTask.zza).build();
                    }
                    catch (RemoteException | JSONException throwable) {
                        String string = String.valueOf(zzfbn2.zze());
                        Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                        uploadTask.zzk = throwable;
                        break block25;
                    }
                    uploadTask.zza(4, false);
                    uploadTask.zza(128, false);
                }
                catch (IOException iOException) {
                    Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
                    uploadTask.zzk = iOException;
                }
            }
            if (!(bl = this.zzi())) continue;
            this.zza(4, false);
        }
        if (this.zzh && this.zzf() != 16) {
            try {
                this.zzd.zzd();
                return;
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to close stream.", (Throwable)iOException);
            }
        }
    }

    @Override
    protected void resetState() {
        this.zzk = null;
        this.zzl = null;
        this.zzm = 0;
        this.zzn = null;
    }

    private final boolean zzi() {
        if (this.zzf() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.zzk = new InterruptedException();
            this.zza(64, false);
            return false;
        }
        if (this.zzf() == 32) {
            this.zza(256, false);
            return false;
        }
        if (this.zzf() == 8) {
            this.zza(16, false);
            return false;
        }
        if (!this.zzj()) {
            return false;
        }
        if (this.zzj == null) {
            if (this.zzk == null) {
                this.zzk = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zza(64, false);
            return false;
        }
        if (this.zzk != null) {
            this.zza(64, false);
            return false;
        }
        if ((this.zzl != null || this.zzm < 200 || this.zzm >= 300) && !this.zza(true)) {
            if (this.zzj()) {
                this.zza(64, false);
            }
            return false;
        }
        return true;
    }

    private final boolean zzj() {
        if ("final".equals(this.zzn)) {
            if (this.zzk == null) {
                this.zzk = new IOException("The server has terminated the upload session", this.zzl);
            }
            this.zza(64, false);
            return false;
        }
        return true;
    }

    private final boolean zza(boolean bl) {
        zzfbn zzfbn2;
        try {
            zzfbn2 = this.zza.zza().zzb(this.zza.zzb(), this.zzj.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.zzk = remoteException;
            return false;
        }
        if ("final".equals(this.zzn)) {
            return false;
        }
        if (bl ? !this.zzb(zzfbn2) : !this.zza(zzfbn2)) {
            return false;
        }
        if ("final".equals(zzfbn2.zza("X-Goog-Upload-Status"))) {
            this.zzk = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = zzfbn2.zza("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.zze.get();
        if (l2 > l) {
            this.zzk = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if ((long)this.zzd.zza((int)(l - l2)) != l - l2) {
                    this.zzk = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.zze.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.zzk = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.zzk = iOException;
                return false;
            }
        }
        return true;
    }

    private final boolean zza(zzfbn zzfbn2) {
        zzfbn2.zza(zzfbh.zza(this.zza.getStorage().getApp()), this.zza.getStorage().getApp().getApplicationContext());
        return this.zzc(zzfbn2);
    }

    private final boolean zzb(zzfbn zzfbn2) {
        zzfbn zzfbn3 = zzfbn2;
        this.zzg.zza(zzfbn3, true);
        return this.zzc(zzfbn2);
    }

    private final boolean zzc(zzfbn zzfbn2) {
        int n = zzfbn2.zzg();
        this.zzm = zzfbc.zza(n) ? -2 : n;
        this.zzl = zzfbn2.zzf();
        this.zzn = zzfbn2.zza("X-Goog-Upload-Status");
        int n2 = this.zzm;
        return (n2 == 308 || n2 >= 200 && n2 < 300) && this.zzl == null;
    }

    @Override
    protected void onCanceled() {
        this.zzg.zza();
        zzfbn zzfbn2 = null;
        if (this.zzj != null) {
            try {
                zzfbn2 = this.zza.zza().zza(this.zza.zzb(), this.zzj.toString());
            }
            catch (RemoteException remoteException) {
                Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            }
        }
        if (zzfbn2 != null) {
            zzfbn zzfbn3 = zzfbn2;
            zzu.zza(new zzad(this, zzfbn3));
        }
        this.zzk = StorageException.fromErrorStatus(Status.zze);
        super.onCanceled();
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzd() {
        UploadTask uploadTask = this;
        Exception exception = uploadTask.zzk != null ? uploadTask.zzk : uploadTask.zzl;
        return new TaskSnapshot(uploadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, uploadTask.zzm)), uploadTask.zze.get(), uploadTask.zzj, uploadTask.zzi);
    }

    static /* synthetic */ StorageReference zza(UploadTask uploadTask) {
        return uploadTask.zza;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zza;
        private final Uri zzb;
        private final StorageMetadata zzc;
        private /* synthetic */ UploadTask zzd;

        TaskSnapshot(UploadTask uploadTask, Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            this.zzd = uploadTask;
            super(uploadTask, exception);
            this.zza = l;
            this.zzb = uri;
            this.zzc = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.zza;
        }

        public long getTotalByteCount() {
            return this.zzd.zza();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.zzb;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.zzc;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

