/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzfbi;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

@Hide
public final class zzfbn {
    private zzfbi zzoxv;
    private Exception zzleq;
    private int zzoxw;
    private Exception zzoxx;

    public zzfbn(@NonNull zzfbi zzfbi2) {
        this.zzoxv = zzfbi2;
    }

    public final void zzbo(String string, String string2) {
        try {
            this.zzoxv.zzbo(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string3.length() != 0 ? "Caught remote exception setting custom header:".concat(string3) : new String("Caught remote exception setting custom header:")), (Throwable)remoteException);
            return;
        }
    }

    @Nullable
    public final String zzst(String string) {
        try {
            return this.zzoxv.zzst(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public final void zze(@Nullable String string, @NonNull Context context) {
        try {
            boolean bl;
            Context context2 = context;
            zzfbn zzfbn2 = this;
            NetworkInfo networkInfo = ((ConnectivityManager)context2.getSystemService("connectivity")).getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                zzfbn2.zzoxw = -2;
                zzfbn2.zzoxx = new SocketException("Network subsystem is unavailable");
                bl = false;
            } else {
                bl = true;
            }
            if (!bl) {
                return;
            }
            this.zzoxv.zzsr(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zza(this.zzleq, "performRequest failed with a RemoteException");
            return;
        }
    }

    public final void reset() {
        try {
            this.zzoxw = 0;
            this.zzoxx = null;
            this.zzoxv.reset();
            return;
        }
        catch (RemoteException remoteException) {
            this.zza((Exception)((Object)remoteException), "reset failed with a RemoteException");
            return;
        }
    }

    public final void zzss(@Nullable String string) {
        try {
            this.zzoxv.zzss(string);
            return;
        }
        catch (RemoteException remoteException) {
            this.zza((Exception)((Object)remoteException), "performRequestStart failed with a RemoteException");
            return;
        }
    }

    public final void zzcon() {
        try {
            if (this.zzoxv != null) {
                this.zzoxv.zzcon();
            }
            return;
        }
        catch (RemoteException remoteException) {
            this.zza((Exception)((Object)remoteException), "performRequestEnd failed with a RemoteException");
            return;
        }
    }

    @Nullable
    public final InputStream getStream() {
        try {
            return (InputStream)zzn.zzy((IObjectWrapper)this.zzoxv.zzcoo());
        }
        catch (RemoteException remoteException) {
            this.zza((Exception)((Object)remoteException), "getStream failed with a RemoteException");
            return null;
        }
    }

    @NonNull
    public final JSONObject zzcov() throws RemoteException {
        return (JSONObject)zzn.zzy((IObjectWrapper)this.zzoxv.zzcop());
    }

    @Nullable
    public final String zzcoq() {
        try {
            this.zzoxv.zzcoq();
        }
        catch (RemoteException remoteException) {
            this.zza((Exception)((Object)remoteException), "getRawResult failed with a RemoteException");
        }
        return null;
    }

    @Nullable
    public final Exception getException() {
        try {
            if (this.zzoxx != null) {
                return this.zzoxx;
            }
            if (this.zzleq != null) {
                return this.zzleq;
            }
            return (Exception)zzn.zzy((IObjectWrapper)this.zzoxv.zzcor());
        }
        catch (RemoteException remoteException) {
            this.zza((Exception)((Object)remoteException), "getException failed with a RemoteException");
            return null;
        }
    }

    public final int getResultCode() {
        try {
            if (this.zzoxw != 0) {
                return this.zzoxw;
            }
            return this.zzoxv.getResultCode();
        }
        catch (RemoteException remoteException) {
            this.zza((Exception)((Object)remoteException), "getResultCode failed with a RemoteException");
            return 0;
        }
    }

    public final boolean zzcos() {
        try {
            if (this.zzoxw == -2 || this.zzoxx != null) {
                return false;
            }
            return this.zzoxv.zzcos();
        }
        catch (RemoteException remoteException) {
            this.zza((Exception)((Object)remoteException), "isResultSuccess failed with a RemoteException");
            return false;
        }
    }

    public final <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.getException();
        if (this.zzcos() && exception == null) {
            taskCompletionSource.setResult(TResult);
            return;
        }
        StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
        taskCompletionSource.setException((Exception)((Object)storageException));
    }

    public final int zzcot() {
        try {
            return this.zzoxv.zzcot();
        }
        catch (RemoteException remoteException) {
            this.zza((Exception)((Object)remoteException), "getResultingContentLength failed with a RemoteException");
            return 0;
        }
    }

    private final void zza(Exception exception, String string) {
        Log.e((String)"NetworkRequestProxy", (String)string, (Throwable)exception);
        this.zzleq = exception;
    }
}

