/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzfbd;
import com.google.android.gms.internal.zzfbh;
import com.google.android.gms.internal.zzfbm;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzd;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage zzouf = null;
    private StorageReference zzotm = null;
    private String zzoug = null;
    private String zzouh = null;
    private zza<String> zzoui = zza.zzcn("");
    private String zzouj = null;
    private String zzouk = null;
    private String zzoul = null;
    private long zzoum;
    private String zzoun = null;
    private zza<String> zzouo = zza.zzcn("");
    private zza<String> zzoup = zza.zzcn("");
    private zza<String> zzouq = zza.zzcn("");
    private zza<String> zzour = zza.zzcn("");
    private zza<Map<String, String>> zzous = zza.zzcn(Collections.emptyMap());
    private String[] zzout = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzbq.checkNotNull((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.zzouf = storageMetadata.zzouf;
        this.zzotm = storageMetadata.zzotm;
        this.zzoug = storageMetadata.zzoug;
        this.zzoui = storageMetadata.zzoui;
        this.zzouo = storageMetadata.zzouo;
        this.zzoup = storageMetadata.zzoup;
        this.zzouq = storageMetadata.zzouq;
        this.zzour = storageMetadata.zzour;
        this.zzous = storageMetadata.zzous;
        this.zzout = storageMetadata.zzout;
        if (bl) {
            this.zzoun = storageMetadata.zzoun;
            this.zzoum = storageMetadata.zzoum;
            this.zzoul = storageMetadata.zzoul;
            this.zzouk = storageMetadata.zzouk;
            this.zzouj = storageMetadata.zzouj;
            this.zzouh = storageMetadata.zzouh;
        }
    }

    public String getContentType() {
        return this.zzoui.getValue();
    }

    public String getCustomMetadata(@NonNull String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.zzous.getValue().get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        return this.zzous.getValue().keySet();
    }

    @NonNull
    public String getPath() {
        if (this.mPath != null) {
            return this.mPath;
        }
        return "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.zzoug;
    }

    @Nullable
    public String getGeneration() {
        return this.zzouh;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.zzouj;
    }

    public long getCreationTimeMillis() {
        return zzfbh.zzsq(this.zzouk);
    }

    public long getUpdatedTimeMillis() {
        return zzfbh.zzsq(this.zzoul);
    }

    public long getSizeBytes() {
        return this.zzoum;
    }

    @Nullable
    public String getMd5Hash() {
        return this.zzoun;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.zzout != null && this.zzotm != null) {
            try {
                String string = zzfbm.zzi(this.zzotm.getStorage().getApp()).zzu(this.zzotm.zzcnx());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    String[] stringArray = this.zzout;
                    int n = this.zzout.length;
                    for (int i = 0; i < n; ++i) {
                        String string2 = stringArray[i];
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.zzouo.getValue();
    }

    @Nullable
    public String getContentDisposition() {
        return this.zzoup.getValue();
    }

    @Nullable
    public String getContentEncoding() {
        return this.zzouq.getValue();
    }

    @Nullable
    public String getContentLanguage() {
        return this.zzour.getValue();
    }

    @Nullable
    public StorageReference getReference() {
        if (this.zzotm == null && this.zzouf != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(zzfbd.zzsn((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.zzouf);
        }
        return this.zzotm;
    }

    @NonNull
    final JSONObject zzcnu() throws JSONException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.zzoui.zzcnv()) {
            hashMap.put("contentType", this.getContentType());
        }
        if (this.zzous.zzcnv()) {
            hashMap.put("metadata", (String)new JSONObject(this.zzous.getValue()));
        }
        if (this.zzouo.zzcnv()) {
            hashMap.put("cacheControl", this.getCacheControl());
        }
        if (this.zzoup.zzcnv()) {
            hashMap.put("contentDisposition", this.getContentDisposition());
        }
        if (this.zzouq.zzcnv()) {
            hashMap.put("contentEncoding", this.getContentEncoding());
        }
        if (this.zzour.zzcnv()) {
            hashMap.put("contentLanguage", this.getContentLanguage());
        }
        return new JSONObject(hashMap);
    }

    private final void zzsm(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.zzout = string.split(",");
        }
    }

    /* synthetic */ StorageMetadata(StorageMetadata storageMetadata, boolean bl, zzd zzd2) {
        this(storageMetadata, bl);
    }

    public static class Builder {
        private StorageMetadata zzouu;
        private boolean zzouv;

        public Builder() {
            this.zzouu = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.zzouu = new StorageMetadata(storageMetadata, false, null);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.zzouu.zzotm = storageReference;
        }

        private Builder(JSONObject jSONObject) throws JSONException {
            this.zzouu = new StorageMetadata();
            if (jSONObject != null) {
                this.zzab(jSONObject);
                this.zzouv = true;
            }
        }

        @Nullable
        private static String zze(JSONObject jSONObject, String string) throws JSONException {
            if (jSONObject.has(string) && !jSONObject.isNull(string)) {
                return jSONObject.getString(string);
            }
            return null;
        }

        private final void zzab(JSONObject jSONObject) throws JSONException {
            String string;
            this.zzouu.zzouh = jSONObject.optString("generation");
            this.zzouu.mPath = jSONObject.optString("name");
            this.zzouu.zzoug = jSONObject.optString("bucket");
            this.zzouu.zzouj = jSONObject.optString("metageneration");
            this.zzouu.zzouk = jSONObject.optString("timeCreated");
            this.zzouu.zzoul = jSONObject.optString("updated");
            this.zzouu.zzoum = jSONObject.optLong("size");
            this.zzouu.zzoun = jSONObject.optString("md5Hash");
            this.zzouu.zzsm(jSONObject.optString("downloadTokens"));
            if (jSONObject.has("metadata") && !jSONObject.isNull("metadata")) {
                string = jSONObject.getJSONObject("metadata");
                Iterator iterator = string.keys();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    this.setCustomMetadata(string2, string.getString(string2));
                }
            }
            if ((string = Builder.zze(jSONObject, "contentType")) != null) {
                this.setContentType(string);
            }
            if ((string = Builder.zze(jSONObject, "cacheControl")) != null) {
                this.setCacheControl(string);
            }
            if ((string = Builder.zze(jSONObject, "contentDisposition")) != null) {
                this.setContentDisposition(string);
            }
            if ((string = Builder.zze(jSONObject, "contentEncoding")) != null) {
                this.setContentEncoding(string);
            }
            if ((string = Builder.zze(jSONObject, "contentLanguage")) != null) {
                this.setContentLanguage(string);
            }
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.zzouu, this.zzouv, null);
        }

        public Builder setContentLanguage(@Nullable String string) {
            this.zzouu.zzour = zza.zzco(string);
            return this;
        }

        public Builder setContentEncoding(@Nullable String string) {
            this.zzouu.zzouq = zza.zzco(string);
            return this;
        }

        public Builder setContentDisposition(@Nullable String string) {
            this.zzouu.zzoup = zza.zzco(string);
            return this;
        }

        public Builder setCacheControl(@Nullable String string) {
            this.zzouu.zzouo = zza.zzco(string);
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (!this.zzouu.zzous.zzcnv()) {
                this.zzouu.zzous = zza.zzco(new HashMap());
            }
            ((Map)this.zzouu.zzous.getValue()).put(string, string2);
            return this;
        }

        public Builder setContentType(@Nullable String string) {
            this.zzouu.zzoui = zza.zzco(string);
            return this;
        }
    }

    static final class zza<T> {
        private final boolean zzouw;
        @Nullable
        private final T value;

        private zza(@Nullable T t, boolean bl) {
            this.zzouw = bl;
            this.value = t;
        }

        static <T> zza<T> zzcn(T t) {
            return new zza<T>(t, false);
        }

        static <T> zza<T> zzco(@Nullable T t) {
            return new zza<T>(t, true);
        }

        final boolean zzcnv() {
            return this.zzouw;
        }

        @Nullable
        final T getValue() {
            return this.value;
        }
    }
}

