/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.storage.CancelException;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.StorageTaskScheduler;
import com.google.firebase.storage.internal.ExponentialBackoffSender;
import com.google.firebase.storage.network.GetNetworkRequest;
import com.google.firebase.storage.network.NetworkRequest;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    static final long PREFERRED_CHUNK_SIZE = 262144L;
    private static final String TAG = "StreamDownloadTask";
    private StorageReference storageRef;
    private ExponentialBackoffSender sender;
    private volatile Exception exception = null;
    private volatile int resultCode = 0;
    private StreamProcessor processor;
    private long totalBytes = -1L;
    private long bytesDownloaded;
    private long bytesDownloadedSnapped;
    private InputStream inputStream;
    private NetworkRequest request;
    private String eTagVerification;

    StreamDownloadTask(@NonNull StorageReference storageRef) {
        this.storageRef = storageRef;
        FirebaseStorage storage = this.storageRef.getStorage();
        this.sender = new ExponentialBackoffSender(storage.getApp().getApplicationContext(), storage.getAuthProvider(), storage.getMaxDownloadRetryTimeMillis());
    }

    StreamDownloadTask setStreamProcessor(@NonNull StreamProcessor processor) {
        Preconditions.checkNotNull((Object)processor);
        Preconditions.checkState((this.processor == null ? 1 : 0) != 0);
        this.processor = processor;
        return this;
    }

    @Override
    @NonNull
    StorageReference getStorage() {
        return this.storageRef;
    }

    long getTotalBytes() {
        return this.totalBytes;
    }

    void recordDownloadedBytes(long bytesDownloaded) {
        this.bytesDownloaded += bytesDownloaded;
        if (this.bytesDownloadedSnapped + 262144L <= this.bytesDownloaded) {
            if (this.getInternalState() == 4) {
                this.tryChangeState(4, false);
            } else {
                this.bytesDownloadedSnapped = this.bytesDownloaded;
            }
        }
    }

    @Override
    protected void schedule() {
        StorageTaskScheduler.getInstance().scheduleDownload(this.getRunnable());
    }

    private InputStream createDownloadStream() throws Exception {
        boolean success;
        this.sender.reset();
        if (this.request != null) {
            this.request.performRequestEnd();
        }
        this.request = new GetNetworkRequest(this.storageRef.getStorageUri(), this.storageRef.getApp(), this.bytesDownloaded);
        this.sender.sendWithExponentialBackoff(this.request, false);
        this.resultCode = this.request.getResultCode();
        this.exception = this.request.getException() != null ? this.request.getException() : this.exception;
        boolean bl = success = this.isValidHttpResponseCode(this.resultCode) && this.exception == null && this.getInternalState() == 4;
        if (success) {
            String newEtag = this.request.getResultString("ETag");
            if (!TextUtils.isEmpty((CharSequence)newEtag) && this.eTagVerification != null && !this.eTagVerification.equals(newEtag)) {
                this.resultCode = 409;
                throw new IOException("The ETag on the server changed.");
            }
            this.eTagVerification = newEtag;
            this.totalBytes = (long)this.request.getResultingContentLength() + this.bytesDownloaded;
            return this.request.getStream();
        }
        throw new IOException("Could not open resulting stream.");
    }

    @Override
    void run() {
        boolean success;
        if (this.exception != null) {
            this.tryChangeState(64, false);
            return;
        }
        if (!this.tryChangeState(4, false)) {
            return;
        }
        StreamProgressWrapper streamWrapper = new StreamProgressWrapper(new Callable<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                return StreamDownloadTask.this.createDownloadStream();
            }
        }, this);
        this.inputStream = new BufferedInputStream(streamWrapper);
        try {
            streamWrapper.ensureStream();
            if (this.processor != null) {
                try {
                    this.processor.doInBackground((TaskSnapshot)this.snapState(), this.inputStream);
                }
                catch (Exception e) {
                    Log.w((String)TAG, (String)"Exception occurred calling doInBackground.", (Throwable)e);
                    this.exception = e;
                }
            }
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"Initial opening of Stream failed", (Throwable)e);
            this.exception = e;
        }
        if (this.inputStream == null) {
            this.request.performRequestEnd();
            this.request = null;
        }
        boolean bl = success = this.exception == null && this.getInternalState() == 4;
        if (success) {
            this.tryChangeState(4, false);
            this.tryChangeState(128, false);
        } else if (!this.tryChangeState(this.getInternalState() == 32 ? 256 : 64, false)) {
            Log.w((String)TAG, (String)("Unable to change download task to final state from " + this.getInternalState()));
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    @NonNull
    TaskSnapshot snapStateImpl() {
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(this.exception, this.resultCode)), this.bytesDownloadedSnapped);
    }

    @Override
    protected void onCanceled() {
        this.sender.cancel();
        this.exception = StorageException.fromErrorStatus(Status.RESULT_CANCELED);
    }

    @Override
    protected void onProgress() {
        this.bytesDownloadedSnapped = this.bytesDownloaded;
    }

    private boolean isValidHttpResponseCode(int code) {
        return code == 308 || code >= 200 && code < 300;
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long mBytesDownloaded;

        TaskSnapshot(Exception error, long bytesDownloaded) {
            super(error);
            this.mBytesDownloaded = bytesDownloaded;
        }

        public long getBytesTransferred() {
            return this.mBytesDownloaded;
        }

        public long getTotalByteCount() {
            return StreamDownloadTask.this.getTotalBytes();
        }

        @NonNull
        public InputStream getStream() {
            return StreamDownloadTask.this.inputStream;
        }
    }

    static class StreamProgressWrapper
    extends InputStream {
        @Nullable
        private StreamDownloadTask mParentTask;
        @Nullable
        private InputStream mWrappedStream;
        private Callable<InputStream> mInputStreamCallable;
        private IOException mTemporaryException;
        private long mDownloadedBytes;
        private long mLastExceptionPosition;
        private boolean mStreamClosed;

        StreamProgressWrapper(@NonNull Callable<InputStream> inputStreamCallable, @Nullable StreamDownloadTask parentTask) {
            this.mParentTask = parentTask;
            this.mInputStreamCallable = inputStreamCallable;
        }

        private void checkCancel() throws IOException {
            if (this.mParentTask != null && this.mParentTask.getInternalState() == 32) {
                throw new CancelException();
            }
        }

        private void recordDownloadedBytes(long delta) {
            if (this.mParentTask != null) {
                this.mParentTask.recordDownloadedBytes(delta);
            }
            this.mDownloadedBytes += delta;
        }

        private boolean ensureStream() throws IOException {
            this.checkCancel();
            if (this.mTemporaryException != null) {
                try {
                    if (this.mWrappedStream != null) {
                        this.mWrappedStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mWrappedStream = null;
                if (this.mLastExceptionPosition == this.mDownloadedBytes) {
                    Log.i((String)StreamDownloadTask.TAG, (String)"Encountered exception during stream operation. Aborting.", (Throwable)this.mTemporaryException);
                    return false;
                }
                Log.i((String)StreamDownloadTask.TAG, (String)("Encountered exception during stream operation. Retrying at " + this.mDownloadedBytes), (Throwable)this.mTemporaryException);
                this.mLastExceptionPosition = this.mDownloadedBytes;
                this.mTemporaryException = null;
            }
            if (this.mStreamClosed) {
                throw new IOException("Can't perform operation on closed stream");
            }
            if (this.mWrappedStream == null) {
                try {
                    this.mWrappedStream = this.mInputStreamCallable.call();
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new IOException("Unable to open stream", e);
                }
            }
            return true;
        }

        @Override
        public int read() throws IOException {
            while (this.ensureStream()) {
                try {
                    int returnValue = this.mWrappedStream.read();
                    if (returnValue != -1) {
                        this.recordDownloadedBytes(1L);
                    }
                    return returnValue;
                }
                catch (IOException e) {
                    this.mTemporaryException = e;
                }
            }
            throw this.mTemporaryException;
        }

        @Override
        public int available() throws IOException {
            while (this.ensureStream()) {
                try {
                    return this.mWrappedStream.available();
                }
                catch (IOException e) {
                    this.mTemporaryException = e;
                }
            }
            throw this.mTemporaryException;
        }

        @Override
        public void close() throws IOException {
            if (this.mWrappedStream != null) {
                this.mWrappedStream.close();
            }
            this.mStreamClosed = true;
            if (this.mParentTask != null && this.mParentTask.request != null) {
                this.mParentTask.request.performRequestEnd();
                this.mParentTask.request = null;
            }
            this.checkCancel();
        }

        @Override
        public void mark(int readlimit) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read(@NonNull byte[] buffer, int byteOffset, int byteCount) throws IOException {
            int bytesRead = 0;
            while (this.ensureStream()) {
                try {
                    int deltaBytesRead;
                    while ((long)byteCount > 262144L) {
                        deltaBytesRead = this.mWrappedStream.read(buffer, byteOffset, 262144);
                        if (deltaBytesRead == -1) {
                            return bytesRead == 0 ? -1 : bytesRead;
                        }
                        bytesRead += deltaBytesRead;
                        byteOffset += deltaBytesRead;
                        byteCount -= deltaBytesRead;
                        this.recordDownloadedBytes(deltaBytesRead);
                        this.checkCancel();
                    }
                    if (byteCount > 0) {
                        deltaBytesRead = this.mWrappedStream.read(buffer, byteOffset, byteCount);
                        if (deltaBytesRead == -1) {
                            return bytesRead == 0 ? -1 : bytesRead;
                        }
                        byteOffset += deltaBytesRead;
                        bytesRead += deltaBytesRead;
                        byteCount -= deltaBytesRead;
                        this.recordDownloadedBytes(deltaBytesRead);
                    }
                    if (byteCount != 0) continue;
                    return bytesRead;
                }
                catch (IOException e) {
                    this.mTemporaryException = e;
                }
            }
            throw this.mTemporaryException;
        }

        @Override
        public long skip(long byteCount) throws IOException {
            long bytesSkipped = 0L;
            while (this.ensureStream()) {
                try {
                    long deltaBytesSkipped;
                    while (byteCount > 262144L) {
                        deltaBytesSkipped = this.mWrappedStream.skip(262144L);
                        if (deltaBytesSkipped < 0L) {
                            return bytesSkipped == 0L ? -1L : bytesSkipped;
                        }
                        bytesSkipped += deltaBytesSkipped;
                        byteCount -= deltaBytesSkipped;
                        this.recordDownloadedBytes(deltaBytesSkipped);
                        this.checkCancel();
                    }
                    if (byteCount > 0L) {
                        deltaBytesSkipped = this.mWrappedStream.skip(byteCount);
                        if (deltaBytesSkipped < 0L) {
                            return bytesSkipped == 0L ? -1L : bytesSkipped;
                        }
                        bytesSkipped += deltaBytesSkipped;
                        byteCount -= deltaBytesSkipped;
                        this.recordDownloadedBytes(deltaBytesSkipped);
                    }
                    if (byteCount != 0L) continue;
                    return bytesSkipped;
                }
                catch (IOException e) {
                    this.mTemporaryException = e;
                }
            }
            throw this.mTemporaryException;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(@NonNull TaskSnapshot var1, @NonNull InputStream var2) throws IOException;
    }
}

