/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage.network;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.FirebaseApp;
import com.google.firebase.storage.network.ResumableNetworkRequest;

public class ResumableUploadByteRequest
extends ResumableNetworkRequest {
    private final Uri uploadURL;
    private final byte[] chunk;
    private final long offset;
    private final boolean isFinal;
    private final int bytesToWrite;

    public ResumableUploadByteRequest(@NonNull Uri gsUri, @NonNull FirebaseApp app, @NonNull Uri uploadURL, @Nullable byte[] chunk, long offset, int bytesToWrite, boolean isFinal) {
        super(gsUri, app);
        if (chunk == null && bytesToWrite != -1) {
            this.mException = new IllegalArgumentException("contentType is null or empty");
        }
        if (offset < 0L) {
            this.mException = new IllegalArgumentException("offset cannot be negative");
        }
        this.bytesToWrite = bytesToWrite;
        this.uploadURL = uploadURL;
        this.chunk = bytesToWrite <= 0 ? null : chunk;
        this.offset = offset;
        this.isFinal = isFinal;
        super.setCustomHeader("X-Goog-Upload-Protocol", "resumable");
        if (this.isFinal && this.bytesToWrite > 0) {
            super.setCustomHeader("X-Goog-Upload-Command", "upload, finalize");
        } else if (this.isFinal) {
            super.setCustomHeader("X-Goog-Upload-Command", "finalize");
        } else {
            super.setCustomHeader("X-Goog-Upload-Command", "upload");
        }
        super.setCustomHeader("X-Goog-Upload-Offset", Long.toString(this.offset));
    }

    @Override
    @NonNull
    protected String getAction() {
        return "POST";
    }

    @Override
    @NonNull
    protected Uri getURL() {
        return this.uploadURL;
    }

    @Override
    @Nullable
    protected byte[] getOutputRaw() {
        return this.chunk;
    }

    @Override
    protected int getOutputRawSize() {
        return this.bytesToWrite > 0 ? this.bytesToWrite : 0;
    }
}

