/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzajl;
import com.google.android.gms.internal.zzajs;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.storage.FileDownloadTask;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.StreamDownloadTask;
import com.google.firebase.storage.UploadTask;
import com.google.firebase.storage.zza;
import com.google.firebase.storage.zzb;
import com.google.firebase.storage.zzc;
import com.google.firebase.storage.zzd;
import com.google.firebase.storage.zzf;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class StorageReference {
    private final Uri zzbUy;
    private final FirebaseStorage zzbUz;

    StorageReference(@NonNull Uri uri, @NonNull FirebaseStorage firebaseStorage) {
        zzaa.zzb((uri != null ? 1 : 0) != 0, (Object)"storageUri cannot be null");
        zzaa.zzb((firebaseStorage != null ? 1 : 0) != 0, (Object)"FirebaseApp cannot be null");
        this.zzbUy = uri;
        this.zzbUz = firebaseStorage;
    }

    @NonNull
    public StorageReference child(@NonNull String string) {
        Uri uri;
        zzaa.zzb((!TextUtils.isEmpty((CharSequence)string) ? 1 : 0) != 0, (Object)"childName cannot be null or empty");
        string = zzajl.zziJ((String)string);
        try {
            uri = this.zzbUy.buildUpon().appendEncodedPath(zzajl.zziH((String)string)).build();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = String.valueOf(string);
            Log.e((String)"StorageReference", (String)(string2.length() != 0 ? "Unable to create a valid default Uri. ".concat(string2) : new String("Unable to create a valid default Uri. ")), (Throwable)unsupportedEncodingException);
            throw new IllegalArgumentException("childName");
        }
        return new StorageReference(uri, this.zzbUz);
    }

    @Nullable
    public StorageReference getParent() {
        String string = this.zzbUy.getPath();
        if (string == null || string.equals("/")) {
            return null;
        }
        int n = string.lastIndexOf(47);
        string = n == -1 ? "/" : string.substring(0, n);
        Uri uri = this.zzbUy.buildUpon().path(string).build();
        return new StorageReference(uri, this.zzbUz);
    }

    @NonNull
    public StorageReference getRoot() {
        Uri uri = this.zzbUy.buildUpon().path("").build();
        return new StorageReference(uri, this.zzbUz);
    }

    @NonNull
    public String getName() {
        String string = this.zzbUy.getPath();
        assert (string != null);
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @NonNull
    public String getPath() {
        String string = this.zzbUy.getPath();
        assert (string != null);
        return string;
    }

    @NonNull
    public String getBucket() {
        return this.zzbUy.getAuthority();
    }

    @NonNull
    public FirebaseStorage getStorage() {
        return this.zzbUz;
    }

    @NonNull
    FirebaseApp getApp() {
        return this.getStorage().getApp();
    }

    @NonNull
    zzajs zzUT() throws RemoteException {
        return zzajs.zzi(this.getApp());
    }

    @NonNull
    public UploadTask putBytes(@NonNull byte[] byArray) {
        zzaa.zzb((byArray != null ? 1 : 0) != 0, (Object)"bytes cannot be null");
        UploadTask uploadTask = new UploadTask(this, null, byArray);
        uploadTask.zzUV();
        return uploadTask;
    }

    @NonNull
    public UploadTask putBytes(@NonNull byte[] byArray, @NonNull StorageMetadata storageMetadata) {
        zzaa.zzb((byArray != null ? 1 : 0) != 0, (Object)"bytes cannot be null");
        zzaa.zzb((storageMetadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask uploadTask = new UploadTask(this, storageMetadata, byArray);
        uploadTask.zzUV();
        return uploadTask;
    }

    @NonNull
    public UploadTask putFile(@NonNull Uri uri) {
        zzaa.zzb((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        UploadTask uploadTask = new UploadTask(this, null, uri, null);
        uploadTask.zzUV();
        return uploadTask;
    }

    @NonNull
    public UploadTask putFile(@NonNull Uri uri, @NonNull StorageMetadata storageMetadata) {
        zzaa.zzb((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        zzaa.zzb((storageMetadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask uploadTask = new UploadTask(this, storageMetadata, uri, null);
        uploadTask.zzUV();
        return uploadTask;
    }

    @NonNull
    public UploadTask putFile(@NonNull Uri uri, @Nullable StorageMetadata storageMetadata, @Nullable Uri uri2) {
        zzaa.zzb((uri != null ? 1 : 0) != 0, (Object)"uri cannot be null");
        zzaa.zzb((storageMetadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask uploadTask = new UploadTask(this, storageMetadata, uri, uri2);
        uploadTask.zzUV();
        return uploadTask;
    }

    @NonNull
    public UploadTask putStream(@NonNull InputStream inputStream) {
        zzaa.zzb((inputStream != null ? 1 : 0) != 0, (Object)"stream cannot be null");
        UploadTask uploadTask = new UploadTask(this, null, inputStream);
        uploadTask.zzUV();
        return uploadTask;
    }

    @NonNull
    public UploadTask putStream(@NonNull InputStream inputStream, @NonNull StorageMetadata storageMetadata) {
        zzaa.zzb((inputStream != null ? 1 : 0) != 0, (Object)"stream cannot be null");
        zzaa.zzb((storageMetadata != null ? 1 : 0) != 0, (Object)"metadata cannot be null");
        UploadTask uploadTask = new UploadTask(this, storageMetadata, inputStream);
        uploadTask.zzUV();
        return uploadTask;
    }

    @NonNull
    public List<UploadTask> getActiveUploadTasks() {
        return zzc.zzVb().zza(this);
    }

    @NonNull
    public List<FileDownloadTask> getActiveDownloadTasks() {
        return zzc.zzVb().zzb(this);
    }

    @NonNull
    public Task<StorageMetadata> getMetadata() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzd.zzVc().zzl(new zzb(this, (TaskCompletionSource<StorageMetadata>)taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<Uri> getDownloadUrl() {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Task<StorageMetadata> task = this.getMetadata();
        task.addOnSuccessListener((OnSuccessListener)new OnSuccessListener<StorageMetadata>(){

            public void zzb(StorageMetadata storageMetadata) {
                taskCompletionSource.setResult((Object)storageMetadata.getDownloadUrl());
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.zzb((StorageMetadata)object);
            }
        });
        task.addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception exception) {
                taskCompletionSource.setException(exception);
            }
        });
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<StorageMetadata> updateMetadata(@NonNull StorageMetadata storageMetadata) {
        zzaa.zzz((Object)storageMetadata);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzd.zzVc().zzl(new zzf(this, (TaskCompletionSource<StorageMetadata>)taskCompletionSource, storageMetadata));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<byte[]> getBytes(final long l) {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        StreamDownloadTask streamDownloadTask = new StreamDownloadTask(this);
        StorageTask cfr_ignored_0 = (StorageTask)((StorageTask)streamDownloadTask.zza(new StreamDownloadTask.StreamProcessor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doInBackground(StreamDownloadTask.TaskSnapshot taskSnapshot, InputStream inputStream) throws IOException {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int n = 0;
                    byte[] byArray = new byte[16384];
                    while (true) {
                        int n2 = inputStream.read(byArray, 0, 16384);
                        if (n2 == -1) break;
                        if ((long)(n += n2) > l) {
                            Log.e((String)"StorageReference", (String)"the maximum allowed buffer size was exceeded.");
                            throw new IndexOutOfBoundsException("the maximum allowed buffer size was exceeded.");
                        }
                        byteArrayOutputStream.write(byArray, 0, n2);
                    }
                    byteArrayOutputStream.flush();
                    taskCompletionSource.setResult((Object)byteArrayOutputStream.toByteArray());
                }
                finally {
                    inputStream.close();
                }
            }
        }).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<StreamDownloadTask.TaskSnapshot>(){

            public void zza(StreamDownloadTask.TaskSnapshot taskSnapshot) {
                if (!taskCompletionSource.getTask().isComplete()) {
                    Log.e((String)"StorageReference", (String)"getBytes 'succeeded', but failed to set a Result.");
                    taskCompletionSource.setException((Exception)((Object)StorageException.fromErrorStatus(Status.zzaly)));
                }
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.zza((StreamDownloadTask.TaskSnapshot)object);
            }
        })).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception exception) {
                StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, 0);
                assert (storageException != null);
                taskCompletionSource.setException((Exception)((Object)storageException));
            }
        });
        streamDownloadTask.zzUV();
        return taskCompletionSource.getTask();
    }

    @NonNull
    public FileDownloadTask getFile(@NonNull Uri uri) {
        FileDownloadTask fileDownloadTask = new FileDownloadTask(this, uri);
        fileDownloadTask.zzUV();
        return fileDownloadTask;
    }

    @NonNull
    public FileDownloadTask getFile(@NonNull File file) {
        return this.getFile(Uri.fromFile((File)file));
    }

    @NonNull
    public StreamDownloadTask getStream() {
        StreamDownloadTask streamDownloadTask = new StreamDownloadTask(this);
        streamDownloadTask.zzUV();
        return streamDownloadTask;
    }

    @NonNull
    public StreamDownloadTask getStream(@NonNull StreamDownloadTask.StreamProcessor streamProcessor) {
        StreamDownloadTask streamDownloadTask = new StreamDownloadTask(this);
        streamDownloadTask.zza(streamProcessor);
        streamDownloadTask.zzUV();
        return streamDownloadTask;
    }

    public Task<Void> delete() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzd.zzVc().zzl(new zza(this, (TaskCompletionSource<Void>)taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    Uri zzUU() {
        return this.zzbUy;
    }

    public String toString() {
        String string = String.valueOf(this.zzbUy.getAuthority());
        String string2 = String.valueOf(this.zzbUy.getPath());
        return new StringBuilder(5 + String.valueOf(string).length() + String.valueOf(string2).length()).append("gs://").append(string).append(string2).toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof StorageReference)) {
            return false;
        }
        StorageReference storageReference = (StorageReference)object;
        return storageReference.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

