/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.internal.zzajk;
import com.google.android.gms.internal.zzajt;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDownloadTask
extends StorageTask<TaskSnapshot> {
    private final Uri zzbTU;
    private long zzbTV;
    private StorageReference zzbTR;
    private zzajk zzbTT;
    private long zzawx = -1L;
    private String zzbTW = null;
    private volatile Exception zzbwC = null;
    private long zzbTX = 0L;
    private int mResultCode;

    FileDownloadTask(@NonNull StorageReference storageReference, @NonNull Uri uri) {
        this.zzbTR = storageReference;
        this.zzbTU = uri;
        this.zzbTT = new zzajk(this.zzbTR.getStorage().getApp(), this.zzbTR.getStorage().getMaxDownloadRetryTimeMillis());
    }

    long getTotalBytes() {
        return this.zzawx;
    }

    @Override
    @NonNull
    StorageReference getStorage() {
        return this.zzbTR;
    }

    @Override
    protected void schedule() {
        zzd.zzVc().zzn(this.zzVa());
    }

    @NonNull
    TaskSnapshot zzUP() {
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(this.zzbwC, this.mResultCode)), this.zzbTV);
    }

    @Override
    void run() {
        Object object;
        boolean bl;
        zzajt zzajt2;
        this.zzi(4, false);
        this.zzbTT.reset();
        try {
            zzajt2 = this.zzbTR.zzUT().zza(this.zzbTR.zzUU(), this.zzbTX);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FileDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            this.zzbwC = remoteException;
            this.zzi(64, false);
            return;
        }
        this.zzbTT.zza(zzajt2, false);
        this.mResultCode = zzajt2.getResultCode();
        this.zzbwC = zzajt2.getException() != null ? zzajt2.getException() : this.zzbwC;
        boolean bl2 = bl = this.zznK(this.mResultCode) && this.zzbwC == null && this.zzUW() == 4;
        if (bl) {
            this.zzawx = zzajt2.zzVu();
            object = zzajt2.zziN("ETag");
            if (!TextUtils.isEmpty((CharSequence)object) && this.zzbTW != null && !this.zzbTW.equals(object)) {
                Log.w((String)"FileDownloadTask", (String)"The file at the server has changed.  Restarting from the beginning.");
                this.zzbTX = 0L;
                this.zzbTW = null;
                zzajt2.zzVn();
                this.schedule();
                return;
            }
            this.zzbTW = object;
            InputStream inputStream = zzajt2.getStream();
            if (inputStream != null) {
                try {
                    int n;
                    FileOutputStream fileOutputStream;
                    File file = new File(this.zzbTU.getPath());
                    if (!file.exists()) {
                        if (this.zzbTX > 0L) {
                            String string = String.valueOf(file.getAbsolutePath());
                            Log.e((String)"FileDownloadTask", (String)(string.length() != 0 ? "The file downloading to has been deleted:".concat(string) : new String("The file downloading to has been deleted:")));
                            throw new IllegalStateException("expected a file to resume from.");
                        }
                        boolean bl3 = file.createNewFile();
                        if (!bl3) {
                            String string = String.valueOf(file.getAbsolutePath());
                            Log.w((String)"FileDownloadTask", (String)(string.length() != 0 ? "unable to create file:".concat(string) : new String("unable to create file:")));
                        }
                    }
                    if (this.zzbTX > 0L) {
                        String string = String.valueOf(file.getAbsolutePath());
                        Log.d((String)"FileDownloadTask", (String)(string.length() != 0 ? "Resuming download file ".concat(string) : new String("Resuming download file ")));
                        fileOutputStream = new FileOutputStream(file, true);
                    } else {
                        fileOutputStream = new FileOutputStream(file);
                    }
                    byte[] byArray = new byte[262144];
                    while ((n = inputStream.read(byArray)) != -1) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                        this.zzbTV += (long)n;
                        if (this.zzi(4, false)) continue;
                    }
                    fileOutputStream.flush();
                    ((OutputStream)fileOutputStream).close();
                    inputStream.close();
                }
                catch (Exception exception) {
                    Log.e((String)"FileDownloadTask", (String)"Exception occurred during file download", (Throwable)exception);
                    this.zzbwC = exception;
                }
            } else {
                this.zzbwC = new IllegalStateException("Unable to open Firebase Storage stream.");
            }
        }
        zzajt2.zzVn();
        boolean bl4 = bl = bl && this.zzbwC == null && this.zzUW() == 4;
        if (bl) {
            this.zzi(128, false);
        } else {
            object = new File(this.zzbTU.getPath());
            this.zzbTX = ((File)object).exists() ? ((File)object).length() : 0L;
            if (this.zzUW() == 8) {
                this.zzi(16, false);
            } else if (!this.zzi(this.zzUW() == 32 ? 256 : 64, false)) {
                int n = this.zzUW();
                Log.w((String)"FileDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
            }
        }
    }

    @Override
    protected void onCanceled() {
        this.zzbTT.cancel();
    }

    private boolean zznK(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError zzUQ() {
        return this.zzUP();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzbTV;

        TaskSnapshot(Exception exception, long l) {
            super(FileDownloadTask.this, exception);
            this.zzbTV = l;
        }

        public long getBytesTransferred() {
            return this.zzbTV;
        }

        public long getTotalByteCount() {
            return FileDownloadTask.this.getTotalBytes();
        }
    }
}

