/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzajk;
import com.google.android.gms.internal.zzajp;
import com.google.android.gms.internal.zzajt;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference zzbTR;
    private final Uri mUri;
    private final byte[] zzbjm;
    private final byte[] zzbVr = new byte[262144];
    private final long zzbVs;
    private final AtomicLong zzbVt = new AtomicLong(0L);
    private zzajk zzbTT;
    private InputStream zzbVu;
    private volatile StorageMetadata zzbUw;
    private volatile Uri zzbVv = null;
    private volatile Exception zzbwC = null;
    private volatile Exception zzbVw = null;
    private volatile int mResultCode = 0;
    private volatile String zzbVx;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        zzaa.zzz((Object)storageReference);
        zzaa.zzz((Object)byArray);
        this.zzbjm = byArray;
        this.zzbVs = this.zzbjm.length;
        this.zzbTR = storageReference;
        this.zzbUw = storageMetadata;
        this.mUri = null;
        this.zzbVu = new BufferedInputStream(new ByteArrayInputStream(this.zzbjm), 262144);
        this.zzbTT = new zzajk(this.zzbTR.getApp(), this.zzbTR.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        zzaa.zzz((Object)storageReference);
        zzaa.zzz((Object)uri);
        this.zzbjm = null;
        this.zzbTR = storageReference;
        this.zzbUw = storageMetadata;
        this.mUri = uri;
        InputStream inputStream = null;
        this.zzbTT = new zzajk(this.zzbTR.getApp(), this.zzbTR.getStorage().getMaxUploadRetryTimeMillis());
        long l = -1L;
        try {
            ContentResolver contentResolver = this.zzbTR.getStorage().getApp().getApplicationContext().getContentResolver();
            try {
                ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.mUri, "r");
                if (parcelFileDescriptor != null) {
                    l = parcelFileDescriptor.getStatSize();
                    parcelFileDescriptor.close();
                }
            }
            catch (NullPointerException nullPointerException) {
                Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                l = -1L;
            }
            catch (IOException iOException) {
                String string = String.valueOf(this.mUri.toString());
                Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")));
            }
            inputStream = contentResolver.openInputStream(this.mUri);
            if (inputStream != null) {
                inputStream = new BufferedInputStream(inputStream);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = String.valueOf(this.mUri.toString());
            Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
            this.zzbwC = fileNotFoundException;
        }
        this.zzbVs = l;
        this.zzbVu = inputStream;
        this.zzbVv = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        zzaa.zzz((Object)storageReference);
        zzaa.zzz((Object)inputStream);
        this.zzbVs = -1L;
        this.zzbjm = null;
        this.zzbTR = storageReference;
        this.zzbUw = storageMetadata;
        this.zzbVu = new BufferedInputStream(inputStream, 262144);
        this.mUri = null;
        this.zzbTT = new zzajk(this.zzbTR.getApp(), this.zzbTR.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    StorageReference getStorage() {
        return this.zzbTR;
    }

    long getTotalByteCount() {
        return this.zzbVs;
    }

    @Override
    protected void schedule() {
        zzd.zzVc().zzm(this.zzVa());
    }

    @Override
    void run() {
        this.zzbTT.reset();
        if (this.zzbTR.getParent() == null) {
            this.zzbwC = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
        }
        if (this.zzbwC != null) {
            this.zzi(64, false);
            return;
        }
        if (this.zzbVv == null) {
            this.zzVg();
        } else {
            this.zzaU(false);
        }
        while (this.zzVh()) {
            this.zzi(4, false);
            this.zzVj();
        }
    }

    @Override
    protected void resetState() {
        this.zzbwC = null;
        this.zzbVw = null;
        this.mResultCode = 0;
        this.zzbVx = null;
    }

    private void zzVg() {
        Object object;
        String string = null;
        if (this.zzbUw != null) {
            string = this.zzbUw.getContentType();
        }
        if (this.mUri != null && TextUtils.isEmpty((CharSequence)string)) {
            object = this.zzbTR.getStorage().getApp().getApplicationContext();
            string = object.getContentResolver().getType(this.mUri);
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "application/octet-stream";
        }
        try {
            object = this.zzbTR.zzUT().zza(this.zzbTR.zzUU(), this.zzbUw != null ? this.zzbUw.zzUS() : null, string);
        }
        catch (RemoteException | JSONException throwable) {
            Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
            this.zzbwC = throwable;
            return;
        }
        if (!this.zzb((zzajt)object)) {
            return;
        }
        String string2 = ((zzajt)object).zziN("X-Goog-Upload-URL");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzbVv = Uri.parse((String)string2);
        }
    }

    private boolean zzVh() {
        boolean bl;
        if (this.zzUW() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.zzbwC = new InterruptedException();
            this.zzi(64, false);
            return false;
        }
        if (this.zzUW() == 32) {
            this.zzi(256, false);
            return false;
        }
        if (this.zzUW() == 8) {
            this.zzi(16, false);
            return false;
        }
        if (!this.zzVi()) {
            return false;
        }
        if (this.zzbVv == null) {
            if (this.zzbwC == null) {
                this.zzbwC = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zzi(64, false);
            return false;
        }
        if (this.zzbwC != null) {
            this.zzi(64, false);
            return false;
        }
        boolean bl2 = bl = this.zzbVw != null || this.mResultCode < 200 || this.mResultCode >= 300;
        if (bl && !this.zzaU(true)) {
            if (this.zzVi()) {
                this.zzi(64, false);
            }
            return false;
        }
        return true;
    }

    private boolean zzVi() {
        if ("final".equals(this.zzbVx)) {
            if (this.zzbwC == null) {
                this.zzbwC = new IOException("The server has terminated the upload session");
            }
            this.zzi(64, false);
            return false;
        }
        return true;
    }

    private boolean zzaU(boolean bl) {
        zzajt zzajt2;
        try {
            zzajt2 = this.zzbTR.zzUT().zzb(this.zzbTR.zzUU(), this.zzbVv.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.zzbwC = remoteException;
            return false;
        }
        if ("final".equals(this.zzbVx)) {
            return false;
        }
        if (bl ? !this.zzb(zzajt2) : !this.zza(zzajt2)) {
            return false;
        }
        if ("final".equals(zzajt2.zziN("X-Goog-Upload-Status"))) {
            this.zzbwC = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = zzajt2.zziN("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.zzbVt.get();
        if (l2 > l) {
            this.zzbwC = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if (this.zzbVu.skip(l - l2) != l - l2) {
                    this.zzbwC = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.zzbVt.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.zzbwC = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.zzbwC = iOException;
                return false;
            }
        }
        return true;
    }

    private void zzVj() {
        zzajt zzajt2;
        int n;
        this.zzbVu.mark(this.zzbVr.length + 1);
        try {
            n = this.zzbVu.read(this.zzbVr);
        }
        catch (IOException iOException) {
            Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
            this.zzbwC = iOException;
            return;
        }
        try {
            zzajt2 = this.zzbTR.zzUT().zza(this.zzbTR.zzUU(), this.zzbVv.toString(), this.zzbVr, this.zzbVt.get(), n, (long)n != 262144L);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            this.zzbwC = remoteException;
            return;
        }
        if (!this.zza(zzajt2)) {
            try {
                this.zzbVu.reset();
            }
            catch (IOException iOException) {
                Log.w((String)"UploadTask", (String)"Unable to reset the stream for error recovery.", (Throwable)iOException);
                this.zzbwC = iOException;
            }
            return;
        }
        if (n != -1) {
            this.zzbVt.getAndAdd(n);
        }
        if ((long)n != 262144L) {
            try {
                this.zzbUw = new StorageMetadata.Builder(zzajt2.zzVw(), this.zzbTR).build();
            }
            catch (RemoteException | JSONException throwable) {
                String string = String.valueOf(zzajt2.zzVq());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                this.zzbwC = throwable;
                return;
            }
            this.zzi(4, false);
            this.zzi(128, false);
        }
    }

    private boolean zznK(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    private boolean zza(zzajt zzajt2) {
        zzajt2.zza(zzajp.zzh(this.zzbTR.getApp()), this.zzbTR.getApp().getApplicationContext());
        return this.zzc(zzajt2);
    }

    private boolean zzb(zzajt zzajt2) {
        this.zzbTT.zzd(zzajt2);
        return this.zzc(zzajt2);
    }

    private boolean zzc(zzajt zzajt2) {
        int n = zzajt2.getResultCode();
        this.mResultCode = this.zzbTT.zznO(n) ? -2 : n;
        this.zzbVw = zzajt2.getException();
        this.zzbVx = zzajt2.zziN("X-Goog-Upload-Status");
        return this.zznK(this.mResultCode) && this.zzbVw == null;
    }

    @Override
    protected void onCanceled() {
        this.zzbTT.cancel();
        zzajt zzajt2 = null;
        try {
            zzajt2 = this.zzbTR.zzUT().zza(this.zzbTR.zzUU(), this.zzbVv.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
        }
        if (zzajt2 != null) {
            final zzajt zzajt3 = zzajt2;
            zzd.zzVc().zzl(new Runnable(){

                @Override
                public void run() {
                    zzajt3.zza(zzajp.zzh(UploadTask.this.zzbTR.getApp()), UploadTask.this.zzbTR.getApp().getApplicationContext());
                }
            });
        }
        this.zzbwC = StorageException.fromErrorStatus(Status.zzalA);
        super.onCanceled();
    }

    @NonNull
    TaskSnapshot zzVk() {
        Exception exception = this.zzbwC != null ? this.zzbwC : this.zzbVw;
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, this.mResultCode)), this.zzbVt.get(), this.zzbVv, this.zzbUw);
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError zzUQ() {
        return this.zzVk();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzbVA;
        private final Uri zzbVv;
        private final StorageMetadata zzbUw;

        TaskSnapshot(Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            super(exception);
            this.zzbVA = l;
            this.zzbVv = uri;
            this.zzbUw = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.zzbVA;
        }

        public long getTotalByteCount() {
            return UploadTask.this.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.zzbVv;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.zzbUw;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

