/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzajp;
import com.google.firebase.FirebaseApp;
import com.google.firebase.storage.StorageReference;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class FirebaseStorage {
    private static final Map<FirebaseApp, FirebaseStorage> zzbTZ = new HashMap<FirebaseApp, FirebaseStorage>();
    private final FirebaseApp zzbSD;
    private long zzbUa = 600000L;
    private long zzbUb = 600000L;
    private long zzbUc = 120000L;

    private FirebaseStorage(@NonNull FirebaseApp firebaseApp) {
        this.zzbSD = firebaseApp;
    }

    @NonNull
    public static FirebaseStorage getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        zzaa.zzb((firebaseApp != null ? 1 : 0) != 0, (Object)"You must call FirebaseApp.initialize() first.");
        assert (firebaseApp != null);
        return FirebaseStorage.getInstance(firebaseApp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static FirebaseStorage getInstance(@NonNull FirebaseApp firebaseApp) {
        zzaa.zzb((firebaseApp != null ? 1 : 0) != 0, (Object)"Null is not a valid value for the FirebaseApp.");
        Map<FirebaseApp, FirebaseStorage> map = zzbTZ;
        synchronized (map) {
            FirebaseStorage firebaseStorage = zzbTZ.get(firebaseApp);
            if (firebaseStorage == null) {
                firebaseStorage = new FirebaseStorage(firebaseApp);
                zzbTZ.put(firebaseApp, firebaseStorage);
            }
            return firebaseStorage;
        }
    }

    public long getMaxDownloadRetryTimeMillis() {
        return this.zzbUb;
    }

    public void setMaxDownloadRetryTimeMillis(long l) {
        this.zzbUb = l;
    }

    public long getMaxUploadRetryTimeMillis() {
        return this.zzbUa;
    }

    public void setMaxUploadRetryTimeMillis(long l) {
        this.zzbUa = l;
    }

    public long getMaxOperationRetryTimeMillis() {
        return this.zzbUc;
    }

    public void setMaxOperationRetryTimeMillis(long l) {
        this.zzbUc = l;
    }

    @Nullable
    private String zzUR() {
        return this.zzbSD.getOptions().getStorageBucket();
    }

    @NonNull
    public StorageReference getReference() {
        String string = this.zzUR();
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalStateException("FirebaseApp was not initialized with a bucket name.");
        }
        Uri uri = new Uri.Builder().scheme("gs").authority(this.zzUR()).path("/").build();
        return this.zzv(uri);
    }

    @NonNull
    public StorageReference getReferenceFromUrl(@NonNull String string) {
        zzaa.zzb((!TextUtils.isEmpty((CharSequence)string) ? 1 : 0) != 0, (Object)"location must not be null or empty");
        String string2 = string.toLowerCase();
        if (string2.startsWith("gs://") || string2.startsWith("https://") || string2.startsWith("http://")) {
            try {
                Uri uri = zzajp.zzc(this.zzbSD, string);
                if (uri == null) {
                    throw new IllegalArgumentException("The storage Uri could not be parsed.");
                }
                return this.zzv(uri);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String string3 = String.valueOf(string);
                Log.e((String)"FirebaseStorage", (String)(string3.length() != 0 ? "Unable to parse location:".concat(string3) : new String("Unable to parse location:")), (Throwable)unsupportedEncodingException);
                throw new IllegalArgumentException("The storage Uri could not be parsed.");
            }
        }
        throw new IllegalArgumentException("The storage Uri could not be parsed.");
    }

    @NonNull
    public StorageReference getReference(@NonNull String string) {
        zzaa.zzb((!TextUtils.isEmpty((CharSequence)string) ? 1 : 0) != 0, (Object)"location must not be null or empty");
        String string2 = string.toLowerCase();
        if (string2.startsWith("gs://") || string2.startsWith("https://") || string2.startsWith("http://")) {
            throw new IllegalArgumentException("location should not be a full URL.");
        }
        return this.getReference().child(string);
    }

    @NonNull
    private StorageReference zzv(@NonNull Uri uri) {
        zzaa.zzb((Object)uri, (Object)"uri must not be null");
        String string = this.zzUR();
        zzaa.zzb((TextUtils.isEmpty((CharSequence)string) || uri.getAuthority().equalsIgnoreCase(string) ? 1 : 0) != 0, (Object)"The supplied bucketname is not available to this project.");
        return new StorageReference(uri, this);
    }

    @NonNull
    public FirebaseApp getApp() {
        return this.zzbSD;
    }
}

