/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzab;
import com.google.firebase.FirebaseException;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class StorageException
extends FirebaseException {
    public static final int ERROR_UNKNOWN = -13000;
    public static final int ERROR_OBJECT_NOT_FOUND = -13010;
    public static final int ERROR_BUCKET_NOT_FOUND = -13011;
    public static final int ERROR_PROJECT_NOT_FOUND = -13012;
    public static final int ERROR_QUOTA_EXCEEDED = -13013;
    public static final int ERROR_NOT_AUTHENTICATED = -13020;
    public static final int ERROR_NOT_AUTHORIZED = -13021;
    public static final int ERROR_RETRY_LIMIT_EXCEEDED = -13030;
    public static final int ERROR_INVALID_CHECKSUM = -13031;
    public static final int ERROR_CANCELED = -13040;
    static IOException bcf = new IOException("The operation was canceled.");
    private final int zzbym;
    private final int bcg;
    private String bch;
    private Throwable bci;

    StorageException(Status status) {
        this(StorageException.zzeu(status), null, 0);
    }

    StorageException(@Nullable Throwable throwable, int n) {
        this(StorageException.zza(throwable, n), throwable, n);
    }

    StorageException(int n, Throwable throwable, int n2) {
        this.bch = StorageException.zzady(n);
        this.bci = throwable;
        this.zzbym = n;
        this.bcg = n2;
        String string = this.bch;
        String string2 = String.valueOf(Integer.toString(this.zzbym));
        String string3 = String.valueOf(Integer.toString(this.bcg));
        Log.e((String)"StorageException", (String)new StringBuilder(52 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("StorageException has occurred.\n").append(string).append("\n Code: ").append(string2).append(" HttpResult: ").append(string3).toString());
        if (this.bci != null) {
            Log.e((String)"StorageException", (String)this.bci.getMessage(), (Throwable)this.bci);
        }
    }

    private static int zzeu(Status status) {
        if (status.isCanceled()) {
            return -13040;
        }
        if (status == Status.sj) {
            return -13030;
        }
        return -13000;
    }

    private static int zza(@Nullable Throwable throwable, int n) {
        if (throwable == bcf) {
            return -13040;
        }
        switch (n) {
            case -2: {
                return -13030;
            }
            case 401: {
                return -13020;
            }
            case 403: {
                return -13021;
            }
            case 404: {
                return -13010;
            }
        }
        return -13000;
    }

    @NonNull
    public static StorageException fromErrorStatus(@NonNull Status status) {
        zzab.zzaa((Object)status);
        zzab.zzbn((!status.isSuccess() ? 1 : 0) != 0);
        return new StorageException(status);
    }

    @Nullable
    public static StorageException fromExceptionAndHttpCode(@Nullable Throwable throwable, int n) {
        if (throwable instanceof StorageException) {
            return (StorageException)((Object)throwable);
        }
        if (StorageException.zzadx(n) && throwable == null) {
            return null;
        }
        return new StorageException(throwable, n);
    }

    @NonNull
    public static StorageException fromException(@NonNull Throwable throwable) {
        StorageException storageException = StorageException.fromExceptionAndHttpCode(throwable, 0);
        assert (storageException != null);
        return storageException;
    }

    private static boolean zzadx(int n) {
        return n == 0 || n >= 200 && n < 300;
    }

    static String zzady(int n) {
        switch (n) {
            case -13000: {
                return "An unknown error occurred, please check the HTTP result code and inner exception for server response.";
            }
            case -13010: {
                return "Object does not exist at location.";
            }
            case -13011: {
                return "Bucket does not exist.";
            }
            case -13012: {
                return "Project does not exist.";
            }
            case -13013: {
                return "Quota for bucket exceeded, please view quota on www.firebase.google.com/storage.";
            }
            case -13020: {
                return "User is not authenticated, please authenticate using Firebase Authentication and try again.";
            }
            case -13021: {
                return "User does not have permission to access this object.";
            }
            case -13030: {
                return "The operation retry limit has been exceeded.";
            }
            case -13031: {
                return "Object has a checksum which does not match. Please retry the operation.";
            }
            case -13040: {
                return "The operation was cancelled.";
            }
        }
        return "An unknown error occurred, please check the HTTP result code and inner exception for server response.";
    }

    public String getMessage() {
        return this.bch;
    }

    public Throwable getCause() {
        if (this.bci == this) {
            return null;
        }
        return this.bci;
    }

    public int getErrorCode() {
        return this.zzbym;
    }

    public int getHttpResultCode() {
        return this.bcg;
    }

    public boolean getIsRecoverableException() {
        return this.getErrorCode() == -13030;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorCode {
    }
}

