/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzame;
import com.google.android.gms.internal.zzami;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageMetadata {
    private String mPath = null;
    private FirebaseStorage bcj = null;
    private StorageReference bbS = null;
    private String bck = null;
    private String bcl = null;
    private String hG = null;
    private String bcm = null;
    private String bcn = null;
    private String bco = null;
    private long bcp;
    private String bcq = null;
    private String bcr = null;
    private String bcs = null;
    private String bct = null;
    private String bcu = null;
    private Map<String, String> bcv = null;
    private String[] bcw = null;

    public StorageMetadata() {
    }

    private StorageMetadata(@NonNull StorageMetadata storageMetadata, boolean bl) {
        zzab.zzaa((Object)storageMetadata);
        this.mPath = storageMetadata.mPath;
        this.bcj = storageMetadata.bcj;
        this.bbS = storageMetadata.bbS;
        this.bck = storageMetadata.bck;
        this.hG = storageMetadata.hG;
        this.bcr = storageMetadata.bcr;
        this.bcs = storageMetadata.bcs;
        this.bct = storageMetadata.bct;
        this.bcu = storageMetadata.bcu;
        if (storageMetadata.bcv != null) {
            this.bcv = new HashMap<String, String>(storageMetadata.bcv);
        }
        this.bcw = storageMetadata.bcw;
        if (bl) {
            this.bcq = storageMetadata.bcq;
            this.bcp = storageMetadata.bcp;
            this.bco = storageMetadata.bco;
            this.bcn = storageMetadata.bcn;
            this.bcm = storageMetadata.bcm;
            this.bcl = storageMetadata.bcl;
        }
    }

    public String getContentType() {
        return this.hG;
    }

    public String getCustomMetadata(@NonNull String string) {
        if (this.bcv == null || TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return this.bcv.get(string);
    }

    @NonNull
    public Set<String> getCustomMetadataKeys() {
        if (this.bcv == null) {
            return Collections.emptySet();
        }
        return this.bcv.keySet();
    }

    @NonNull
    public String getPath() {
        return this.mPath != null ? this.mPath : "";
    }

    @Nullable
    public String getName() {
        String string = this.getPath();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Nullable
    public String getBucket() {
        return this.bck;
    }

    @Nullable
    public String getGeneration() {
        return this.bcl;
    }

    @Nullable
    public String getMetadataGeneration() {
        return this.bcm;
    }

    public long getCreationTimeMillis() {
        return zzami.zzsr(this.bcn);
    }

    public long getUpdatedTimeMillis() {
        return zzami.zzsr(this.bco);
    }

    public long getSizeBytes() {
        return this.bcp;
    }

    @Nullable
    public String getMd5Hash() {
        return this.bcq;
    }

    @Nullable
    public Uri getDownloadUrl() {
        List<Uri> list = this.getDownloadUrls();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public List<Uri> getDownloadUrls() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        if (this.bcw != null && this.bbS != null) {
            try {
                String string = this.bbS.zzcyb().zzy(this.bbS.zzcyc());
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    for (String string2 : this.bcw) {
                        if (TextUtils.isEmpty((CharSequence)string2)) continue;
                        arrayList.add(Uri.parse((String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?alt=media&token=").append(string2).toString()));
                    }
                }
            }
            catch (RemoteException remoteException) {
                Log.e((String)"StorageMetadata", (String)"Unexpected error getting DownloadUrls.", (Throwable)remoteException);
            }
        }
        return arrayList;
    }

    @Nullable
    public String getCacheControl() {
        return this.bcr;
    }

    @Nullable
    public String getContentDisposition() {
        return this.bcs;
    }

    @Nullable
    public String getContentEncoding() {
        return this.bct;
    }

    @Nullable
    public String getContentLanguage() {
        return this.bcu;
    }

    @Nullable
    public StorageReference getReference() {
        if (this.bbS == null && this.bcj != null) {
            Uri uri;
            String string = this.getBucket();
            String string2 = this.getPath();
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            try {
                uri = new Uri.Builder().scheme("gs").authority(string).encodedPath(zzame.zzso((String)string2)).build();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)"StorageMetadata", (String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to create a valid default Uri. ").append(string).append(string2).toString(), (Throwable)unsupportedEncodingException);
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new StorageReference(uri, this.bcj);
        }
        return this.bbS;
    }

    @NonNull
    JSONObject zzcya() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.getContentType() != null) {
            jSONObject.put("contentType", (Object)this.getContentType());
        }
        if (this.bcv != null) {
            jSONObject.put("metadata", (Object)new JSONObject(this.bcv));
        }
        if (this.getCacheControl() != null) {
            jSONObject.put("cacheControl", (Object)this.getCacheControl());
        }
        if (this.getContentDisposition() != null) {
            jSONObject.put("contentDisposition", (Object)this.getContentDisposition());
        }
        if (this.getContentEncoding() != null) {
            jSONObject.put("'contentEncoding", (Object)this.getContentEncoding());
        }
        if (this.getContentLanguage() != null) {
            jSONObject.put("'contentLanguage", (Object)this.getContentLanguage());
        }
        return jSONObject;
    }

    private void zzsn(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.bcw = string.split(",");
        }
    }

    public static class Builder {
        StorageMetadata bcx;
        boolean bcy;

        public Builder() {
            this.bcx = new StorageMetadata();
        }

        public Builder(StorageMetadata storageMetadata) {
            this.bcx = new StorageMetadata(storageMetadata, false);
        }

        Builder(JSONObject jSONObject, StorageReference storageReference) throws JSONException {
            this(jSONObject);
            this.bcx.bbS = storageReference;
        }

        Builder(JSONObject jSONObject) throws JSONException {
            this.bcx = new StorageMetadata();
            if (jSONObject != null) {
                this.zzp(jSONObject);
                this.bcy = true;
            }
        }

        private void zzp(JSONObject jSONObject) throws JSONException {
            this.bcx.bcl = jSONObject.optString("generation");
            this.bcx.mPath = jSONObject.optString("name");
            this.bcx.bck = jSONObject.optString("bucket");
            this.bcx.bcm = jSONObject.optString("metageneration");
            this.bcx.bcn = jSONObject.optString("timeCreated");
            this.bcx.bco = jSONObject.optString("updated");
            this.bcx.bcp = jSONObject.optLong("size");
            this.bcx.bcq = jSONObject.optString("md5Hash");
            this.bcx.zzsn(jSONObject.optString("downloadTokens"));
            this.setContentType(jSONObject.optString("contentType"));
            if (jSONObject.has("metadata")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("metadata");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.setCustomMetadata(string, jSONObject2.getString(string));
                }
            }
            this.setCacheControl(jSONObject.optString("cacheControl"));
            this.setContentDisposition(jSONObject.optString("contentDisposition"));
            this.setContentEncoding(jSONObject.optString("'contentEncoding"));
            this.setContentLanguage(jSONObject.optString("'contentLanguage"));
        }

        public StorageMetadata build() {
            return new StorageMetadata(this.bcx, this.bcy);
        }

        public Builder setContentLanguage(String string) {
            this.bcx.bcu = string;
            return this;
        }

        public Builder setContentEncoding(String string) {
            this.bcx.bct = string;
            return this;
        }

        public Builder setContentDisposition(String string) {
            this.bcx.bcs = string;
            return this;
        }

        public Builder setCacheControl(String string) {
            this.bcx.bcr = string;
            return this;
        }

        public Builder setCustomMetadata(String string, String string2) {
            if (this.bcx.bcv == null) {
                this.bcx.bcv = new HashMap();
            }
            this.bcx.bcv.put(string, string2);
            return this;
        }

        public Builder setContentType(String string) {
            this.bcx.hG = string;
            return this;
        }
    }
}

