/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzamd;
import com.google.android.gms.internal.zzami;
import com.google.android.gms.internal.zzamm;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference bbS;
    private final Uri mUri;
    private final byte[] aqV;
    private final byte[] bds = new byte[262144];
    private final long bdt;
    private final AtomicLong bdu = new AtomicLong(0L);
    private zzamd bbU;
    private InputStream bdv;
    private volatile StorageMetadata bcx;
    private volatile Uri bdw = null;
    private volatile Exception aDS = null;
    private volatile Exception bdx = null;
    private volatile int mResultCode = 0;
    private volatile String bdy;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        zzab.zzaa((Object)storageReference);
        zzab.zzaa((Object)byArray);
        this.aqV = byArray;
        this.bdt = this.aqV.length;
        this.bbS = storageReference;
        this.bcx = storageMetadata;
        this.mUri = null;
        this.bdv = new BufferedInputStream(new ByteArrayInputStream(this.aqV), 262144);
        this.bbU = new zzamd(this.bbS.getApp(), this.bbS.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        zzab.zzaa((Object)storageReference);
        zzab.zzaa((Object)uri);
        this.aqV = null;
        this.bbS = storageReference;
        this.bcx = storageMetadata;
        this.mUri = uri;
        InputStream inputStream = null;
        this.bbU = new zzamd(this.bbS.getApp(), this.bbS.getStorage().getMaxUploadRetryTimeMillis());
        long l = -1L;
        try {
            ContentResolver contentResolver = this.bbS.getStorage().getApp().getApplicationContext().getContentResolver();
            try {
                ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.mUri, "r");
                if (parcelFileDescriptor != null) {
                    l = parcelFileDescriptor.getStatSize();
                    parcelFileDescriptor.close();
                }
            }
            catch (NullPointerException nullPointerException) {
                Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                l = -1L;
            }
            catch (IOException iOException) {
                String string = String.valueOf(this.mUri.toString());
                Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")));
            }
            inputStream = contentResolver.openInputStream(this.mUri);
            if (inputStream != null) {
                inputStream = new BufferedInputStream(inputStream);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = String.valueOf(this.mUri.toString());
            Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
            this.aDS = fileNotFoundException;
        }
        this.bdt = l;
        this.bdv = inputStream;
        this.bdw = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        zzab.zzaa((Object)storageReference);
        zzab.zzaa((Object)inputStream);
        this.bdt = -1L;
        this.aqV = null;
        this.bbS = storageReference;
        this.bcx = storageMetadata;
        this.bdv = new BufferedInputStream(inputStream, 262144);
        this.mUri = null;
        this.bbU = new zzamd(this.bbS.getApp(), this.bbS.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    StorageReference getStorage() {
        return this.bbS;
    }

    long getTotalByteCount() {
        return this.bdt;
    }

    @Override
    protected void schedule() {
        zzd.zzcyj().zzt(this.zzcjq());
    }

    @Override
    void run() {
        this.bbU.reset();
        if (this.bbS.getParent() == null) {
            this.aDS = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
        }
        if (this.aDS != null) {
            this.zzi(64, false);
            return;
        }
        if (this.bdw == null) {
            this.zzcyn();
        } else {
            this.zzcw(false);
        }
        while (this.zzcyo()) {
            this.zzi(4, false);
            this.zzcyq();
        }
    }

    @Override
    protected void resetState() {
        this.aDS = null;
        this.bdx = null;
        this.mResultCode = 0;
        this.bdy = null;
    }

    private void zzcyn() {
        Object object;
        String string = null;
        if (this.bcx != null) {
            string = this.bcx.getContentType();
        }
        if (this.mUri != null && TextUtils.isEmpty((CharSequence)string)) {
            object = this.bbS.getStorage().getApp().getApplicationContext();
            string = object.getContentResolver().getType(this.mUri);
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "application/octet-stream";
        }
        try {
            object = this.bbS.zzcyb().zza(this.bbS.zzcyc(), this.bcx != null ? this.bcx.zzcya() : null, string);
        }
        catch (RemoteException | JSONException throwable) {
            Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
            this.aDS = throwable;
            return;
        }
        if (!this.zzb((zzamm)object)) {
            return;
        }
        String string2 = ((zzamm)object).zzsu("X-Goog-Upload-URL");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.bdw = Uri.parse((String)string2);
        }
    }

    private boolean zzcyo() {
        boolean bl;
        if (this.zzcye() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.aDS = new InterruptedException();
            this.zzi(64, false);
            return false;
        }
        if (this.zzcye() == 32) {
            this.zzi(256, false);
            return false;
        }
        if (this.zzcye() == 8) {
            this.zzi(16, false);
            return false;
        }
        if (!this.zzcyp()) {
            return false;
        }
        if (this.bdw == null) {
            if (this.aDS == null) {
                this.aDS = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zzi(64, false);
            return false;
        }
        if (this.aDS != null) {
            this.zzi(64, false);
            return false;
        }
        boolean bl2 = bl = this.bdx != null || this.mResultCode < 200 || this.mResultCode >= 300;
        if (bl && !this.zzcw(true)) {
            if (this.zzcyp()) {
                this.zzi(64, false);
            }
            return false;
        }
        return true;
    }

    private boolean zzcyp() {
        if ("final".equals(this.bdy)) {
            if (this.aDS == null) {
                this.aDS = new IOException("The server has terminated the upload session");
            }
            this.zzi(64, false);
            return false;
        }
        return true;
    }

    private boolean zzcw(boolean bl) {
        zzamm zzamm2;
        try {
            zzamm2 = this.bbS.zzcyb().zzb(this.bbS.zzcyc(), this.bdw.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.aDS = remoteException;
            return false;
        }
        if ("final".equals(this.bdy)) {
            return false;
        }
        if (bl ? !this.zzb(zzamm2) : !this.zza(zzamm2)) {
            return false;
        }
        if ("final".equals(zzamm2.zzsu("X-Goog-Upload-Status"))) {
            this.aDS = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = zzamm2.zzsu("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.bdu.get();
        if (l2 > l) {
            this.aDS = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if (this.bdv.skip(l - l2) != l - l2) {
                    this.aDS = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.bdu.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.aDS = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.aDS = iOException;
                return false;
            }
        }
        return true;
    }

    private void zzcyq() {
        zzamm zzamm2;
        int n;
        this.bdv.mark(this.bds.length + 1);
        try {
            n = this.bdv.read(this.bds);
        }
        catch (IOException iOException) {
            Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
            this.aDS = iOException;
            return;
        }
        try {
            zzamm2 = this.bbS.zzcyb().zza(this.bbS.zzcyc(), this.bdw.toString(), this.bds, this.bdu.get(), n, (long)n != 262144L);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            this.aDS = remoteException;
            return;
        }
        if (!this.zza(zzamm2)) {
            try {
                this.bdv.reset();
            }
            catch (IOException iOException) {
                Log.w((String)"UploadTask", (String)"Unable to reset the stream for error recovery.", (Throwable)iOException);
                this.aDS = iOException;
            }
            return;
        }
        if (n != -1) {
            this.bdu.getAndAdd(n);
        }
        if ((long)n != 262144L) {
            try {
                this.bcx = new StorageMetadata.Builder(zzamm2.zzczd(), this.bbS).build();
            }
            catch (RemoteException | JSONException throwable) {
                String string = String.valueOf(zzamm2.zzcyx());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                this.aDS = throwable;
                return;
            }
            this.zzi(4, false);
            this.zzi(128, false);
        }
    }

    private boolean zzadw(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    private boolean zza(zzamm zzamm2) {
        zzamm2.zza(zzami.zzh(this.bbS.getApp()), this.bbS.getApp().getApplicationContext());
        return this.zzc(zzamm2);
    }

    private boolean zzb(zzamm zzamm2) {
        this.bbU.zzd(zzamm2);
        return this.zzc(zzamm2);
    }

    private boolean zzc(zzamm zzamm2) {
        int n = zzamm2.getResultCode();
        this.mResultCode = this.bbU.zzaea(n) ? -2 : n;
        this.bdx = zzamm2.getException();
        this.bdy = zzamm2.zzsu("X-Goog-Upload-Status");
        return this.zzadw(this.mResultCode) && this.bdx == null;
    }

    @Override
    protected void onCanceled() {
        this.bbU.cancel();
        zzamm zzamm2 = null;
        try {
            zzamm2 = this.bbS.zzcyb().zza(this.bbS.zzcyc(), this.bdw.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
        }
        if (zzamm2 != null) {
            final zzamm zzamm3 = zzamm2;
            zzd.zzcyj().zzs(new Runnable(){

                @Override
                public void run() {
                    zzamm3.zza(zzami.zzh(UploadTask.this.bbS.getApp()), UploadTask.this.bbS.getApp().getApplicationContext());
                }
            });
        }
        this.aDS = StorageException.fromErrorStatus(Status.sk);
        super.onCanceled();
    }

    @NonNull
    TaskSnapshot zzcyr() {
        Exception exception = this.aDS != null ? this.aDS : this.bdx;
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, this.mResultCode)), this.bdu.get(), this.bdw, this.bcx);
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError zzcxy() {
        return this.zzcyr();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long bdB;
        private final Uri bdw;
        private final StorageMetadata bcx;

        TaskSnapshot(Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            super(exception);
            this.bdB = l;
            this.bdw = uri;
            this.bcx = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.bdB;
        }

        public long getTotalByteCount() {
            return UploadTask.this.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.bdw;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.bcx;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

