/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzamg;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

public class zzamj {
    private zzamg bdB;
    private Exception aDy;
    private int bdC;
    private Exception bdD;

    public zzamj(@NonNull zzamg zzamg2) {
        this.bdB = zzamg2;
    }

    private boolean zzew(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            this.bdC = -2;
            this.bdD = new SocketException("Network subsystem is unavailable");
            return false;
        }
        return true;
    }

    @Nullable
    public String zztl(String string) {
        try {
            return this.bdB.zztl(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public void zza(@Nullable String string, @NonNull Context context) {
        try {
            if (!this.zzew(context)) {
                return;
            }
            this.bdB.zztj(string);
        }
        catch (RemoteException remoteException) {
            this.aDy = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequest failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void reset() {
        try {
            this.bdC = 0;
            this.bdD = null;
            this.bdB.reset();
        }
        catch (RemoteException remoteException) {
            this.aDy = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"reset failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void zztk(@Nullable String string) {
        try {
            this.bdB.zztk(string);
        }
        catch (RemoteException remoteException) {
            this.aDy = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestStart failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void zzcys() {
        try {
            this.bdB.zzcys();
        }
        catch (RemoteException remoteException) {
            this.aDy = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestEnd failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    @Nullable
    public InputStream getStream() {
        try {
            return (InputStream)zze.zzad((zzd)this.bdB.zzcyt());
        }
        catch (RemoteException remoteException) {
            this.aDy = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getStream failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @NonNull
    public JSONObject zzczb() throws RemoteException {
        return (JSONObject)zze.zzad((zzd)this.bdB.zzcyu());
    }

    @Nullable
    public String zzcyv() {
        try {
            this.bdB.zzcyv();
        }
        catch (RemoteException remoteException) {
            this.aDy = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getRawResult failed with a RemoteException:", (Throwable)remoteException);
        }
        return null;
    }

    @Nullable
    public Exception getException() {
        try {
            if (this.bdD != null) {
                return this.bdD;
            }
            return this.aDy != null ? this.aDy : (Exception)zze.zzad((zzd)this.bdB.zzcyx());
        }
        catch (RemoteException remoteException) {
            this.aDy = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getException failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    public int getResultCode() {
        try {
            if (this.bdC != 0) {
                return this.bdC;
            }
            return this.bdB.getResultCode();
        }
        catch (RemoteException remoteException) {
            this.aDy = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultCode failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }

    public boolean zzcyy() {
        try {
            if (this.bdC == -2 || this.bdD != null) {
                return false;
            }
            return this.bdB.zzcyy();
        }
        catch (RemoteException remoteException) {
            this.aDy = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"isResultSuccess failed with a RemoteException:", (Throwable)remoteException);
            return false;
        }
    }

    public <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.getException();
        if (this.zzcyy() && exception == null) {
            taskCompletionSource.setResult(TResult);
        } else {
            StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
            assert (storageException != null);
            taskCompletionSource.setException((Exception)((Object)storageException));
        }
    }

    public int zzcyz() {
        try {
            return this.bdB.zzcyz();
        }
        catch (RemoteException remoteException) {
            this.aDy = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultingContentLength failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }
}

