/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzama;
import com.google.android.gms.internal.zzamj;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.IOException;
import java.io.InputStream;

public class StreamDownloadTask
extends StorageTask<TaskSnapshot> {
    private StorageReference bbI;
    private zzama bbK;
    private volatile Exception aDy = null;
    private volatile int mResultCode = 0;
    private StreamProcessor bcR;
    private long bbM;
    private long EQ;
    private long bcS;
    private InputStream aJW;
    private zzamj bcT;

    StreamDownloadTask(@NonNull StorageReference storageReference) {
        this.bbI = storageReference;
        this.bbK = new zzama(this.bbI.getApp(), this.bbI.getStorage().getMaxDownloadRetryTimeMillis());
    }

    StreamDownloadTask zza(@NonNull StreamProcessor streamProcessor) {
        zzab.zzy((Object)streamProcessor);
        zzab.zzbn((this.bcR == null ? 1 : 0) != 0);
        this.bcR = streamProcessor;
        return this;
    }

    @Override
    @NonNull
    StorageReference getStorage() {
        return this.bbI;
    }

    long getTotalBytes() {
        return this.EQ;
    }

    private void zzcq(long l) {
        this.bbM += l;
        if (this.bcS + 262144L <= this.bbM) {
            this.zzi(4, false);
        }
    }

    @Override
    protected void schedule() {
        zzd.zzcyh().zzv(this.zzcjq());
    }

    @Override
    void run() {
        boolean bl;
        this.bbK.reset();
        if (this.aDy != null) {
            this.zzi(64, false);
            return;
        }
        if (!this.zzi(4, false)) {
            return;
        }
        try {
            this.bcT = this.bbI.zzcxz().zza(this.bbI.zzcya(), 0L);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"StreamDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            this.aDy = remoteException;
            this.zzi(64, false);
            return;
        }
        this.bbK.zza(this.bcT, false);
        this.mResultCode = this.bcT.getResultCode();
        this.aDy = this.bcT.getException() != null ? this.bcT.getException() : this.aDy;
        boolean bl2 = bl = this.zzaff(this.mResultCode) && this.aDy == null && this.zzcyc() == 4;
        if (bl) {
            this.EQ = this.bcT.zzcyz();
            InputStream inputStream = this.bcT.getStream();
            if (inputStream != null) {
                this.aJW = new zza(this, inputStream);
                if (this.bcR != null) {
                    try {
                        this.bcR.doInBackground((TaskSnapshot)this.zzcye(), this.aJW);
                    }
                    catch (Exception exception) {
                        Log.w((String)"StreamDownloadTask", (String)"Exception occurred calling doInBackground.", (Throwable)exception);
                        this.aDy = exception;
                    }
                }
            } else {
                this.aDy = new IOException("Could not open resulting stream.");
            }
        }
        if (this.aJW == null) {
            this.bcT.zzcys();
        }
        boolean bl3 = bl = bl && this.aDy == null && this.zzcyc() == 4;
        if (bl) {
            this.zzi(4, false);
            this.zzi(128, false);
        } else if (!this.zzi(this.zzcyc() == 32 ? 256 : 64, false)) {
            int n = this.zzcyc();
            Log.w((String)"StreamDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
        }
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException("this operation is not supported on StreamDownloadTask.");
    }

    @NonNull
    TaskSnapshot zzcyi() {
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(this.aDy, this.mResultCode)), this.bcS);
    }

    @Override
    protected void onCanceled() {
        this.bbK.cancel();
    }

    @Override
    protected void onProgress() {
        this.bcS = this.bbM;
    }

    private boolean zzaff(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError zzcxw() {
        return this.zzcyi();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long bbM;

        TaskSnapshot(Exception exception, long l) {
            super(exception);
            this.bbM = l;
        }

        public long getBytesTransferred() {
            return this.bbM;
        }

        public long getTotalByteCount() {
            return StreamDownloadTask.this.getTotalBytes();
        }

        public InputStream getStream() {
            return StreamDownloadTask.this.aJW;
        }
    }

    private static class zza
    extends InputStream {
        private StreamDownloadTask bcU;
        private InputStream bcV;
        private int bcW;

        public zza(@NonNull StreamDownloadTask streamDownloadTask, @NonNull InputStream inputStream) {
            this.bcU = streamDownloadTask;
            this.bcV = inputStream;
        }

        private void zzcyj() throws IOException {
            if (this.bcU.zzcyc() == 32) {
                throw StorageException.bbV;
            }
        }

        @Override
        public int read() throws IOException {
            this.zzcyj();
            int n = this.bcV.read();
            if (n != -1) {
                this.bcU.zzcq(1L);
            }
            return n;
        }

        @Override
        public int available() throws IOException {
            this.zzcyj();
            return this.bcV.available();
        }

        @Override
        public void close() throws IOException {
            this.bcV.close();
            if (this.bcU.bcT != null) {
                this.bcU.bcT.zzcys();
            }
            this.zzcyj();
        }

        @Override
        public void mark(int n) {
            this.bcW = n;
            this.bcV.mark(n);
        }

        @Override
        public boolean markSupported() {
            return this.bcV.markSupported();
        }

        @Override
        public int read(@NonNull byte[] byArray, int n, int n2) throws IOException {
            int n3;
            this.zzcyj();
            int n4 = 0;
            while ((long)n2 > 262144L) {
                n3 = this.bcV.read(byArray, n, 262144);
                if (n3 == -1) {
                    return n4 == 0 ? -1 : n4;
                }
                n4 += n3;
                n += n3;
                n2 -= n3;
                this.bcU.zzcq(n3);
                this.zzcyj();
                if ((long)n3 >= 262144L) continue;
                break;
            }
            if (n2 > 0) {
                n3 = this.bcV.read(byArray, n, n2);
                if (n3 == -1) {
                    return n4 == 0 ? -1 : n4;
                }
                n4 += n3;
                this.bcU.zzcq(n3);
            }
            return n4;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.zzcyj();
            this.bcU.zzcq(-this.bcW);
            this.bcV.reset();
        }

        @Override
        public long skip(long l) throws IOException {
            long l2;
            this.zzcyj();
            int n = 0;
            while (l > 262144L) {
                l2 = this.bcV.skip(262144L);
                n = (int)((long)n + l2);
                if (l2 < 262144L) {
                    this.bcU.zzcq(l2);
                    return n;
                }
                this.bcU.zzcq(262144L);
                l -= 262144L;
                this.zzcyj();
            }
            l2 = this.bcV.skip(l);
            n = (int)((long)n + l2);
            this.bcU.zzcq(l2);
            return n;
        }
    }

    public static interface StreamProcessor {
        public void doInBackground(TaskSnapshot var1, InputStream var2) throws IOException;
    }
}

