/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzama;
import com.google.android.gms.internal.zzamf;
import com.google.android.gms.internal.zzamj;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference bbI;
    private final Uri mUri;
    private final byte[] aqe;
    private final byte[] bdi = new byte[262144];
    private final long bdj;
    private final AtomicLong bdk = new AtomicLong(0L);
    private zzama bbK;
    private InputStream bdl;
    private volatile StorageMetadata bcn;
    private volatile Uri bdm = null;
    private volatile Exception aDy = null;
    private volatile Exception bdn = null;
    private volatile int mResultCode = 0;
    private volatile String bdo;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        zzab.zzy((Object)storageReference);
        zzab.zzy((Object)byArray);
        this.aqe = byArray;
        this.bdj = this.aqe.length;
        this.bbI = storageReference;
        this.bcn = storageMetadata;
        this.mUri = null;
        this.bdl = new BufferedInputStream(new ByteArrayInputStream(this.aqe), 262144);
        this.bbK = new zzama(this.bbI.getApp(), this.bbI.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        zzab.zzy((Object)storageReference);
        zzab.zzy((Object)uri);
        this.aqe = null;
        this.bbI = storageReference;
        this.bcn = storageMetadata;
        this.mUri = uri;
        InputStream inputStream = null;
        this.bbK = new zzama(this.bbI.getApp(), this.bbI.getStorage().getMaxUploadRetryTimeMillis());
        long l = -1L;
        try {
            ContentResolver contentResolver = this.bbI.getStorage().getApp().getApplicationContext().getContentResolver();
            try {
                ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.mUri, "r");
                if (parcelFileDescriptor != null) {
                    l = parcelFileDescriptor.getStatSize();
                    parcelFileDescriptor.close();
                }
            }
            catch (NullPointerException nullPointerException) {
                Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                l = -1L;
            }
            catch (IOException iOException) {
                String string = String.valueOf(this.mUri.toString());
                Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")));
            }
            inputStream = contentResolver.openInputStream(this.mUri);
            if (inputStream != null) {
                inputStream = new BufferedInputStream(inputStream);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = String.valueOf(this.mUri.toString());
            Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
            this.aDy = fileNotFoundException;
        }
        this.bdj = l;
        this.bdl = inputStream;
        this.bdm = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        zzab.zzy((Object)storageReference);
        zzab.zzy((Object)inputStream);
        this.bdj = -1L;
        this.aqe = null;
        this.bbI = storageReference;
        this.bcn = storageMetadata;
        this.bdl = new BufferedInputStream(inputStream, 262144);
        this.mUri = null;
        this.bbK = new zzama(this.bbI.getApp(), this.bbI.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    StorageReference getStorage() {
        return this.bbI;
    }

    long getTotalByteCount() {
        return this.bdj;
    }

    @Override
    protected void schedule() {
        zzd.zzcyh().zzu(this.zzcjq());
    }

    @Override
    void run() {
        this.bbK.reset();
        if (this.bbI.getParent() == null) {
            this.aDy = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
        }
        if (this.aDy != null) {
            this.zzi(64, false);
            return;
        }
        if (this.bdm == null) {
            this.zzcyl();
        } else {
            this.zzcx(false);
        }
        while (this.zzcym()) {
            this.zzi(4, false);
            this.zzcyo();
        }
    }

    @Override
    protected void resetState() {
        this.aDy = null;
        this.bdn = null;
        this.mResultCode = 0;
        this.bdo = null;
    }

    private void zzcyl() {
        Object object;
        String string = null;
        if (this.bcn != null) {
            string = this.bcn.getContentType();
        }
        if (this.mUri != null && TextUtils.isEmpty((CharSequence)string)) {
            object = this.bbI.getStorage().getApp().getApplicationContext();
            string = object.getContentResolver().getType(this.mUri);
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "application/octet-stream";
        }
        try {
            object = this.bbI.zzcxz().zza(this.bbI.zzcya(), this.bcn != null ? this.bcn.zzcxy() : null, string);
        }
        catch (RemoteException | JSONException throwable) {
            Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
            this.aDy = throwable;
            return;
        }
        if (!this.zzb((zzamj)object)) {
            return;
        }
        String string2 = ((zzamj)object).zztl("X-Goog-Upload-URL");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.bdm = Uri.parse((String)string2);
        }
    }

    private boolean zzcym() {
        boolean bl;
        if (this.zzcyc() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.aDy = new InterruptedException();
            this.zzi(64, false);
            return false;
        }
        if (this.zzcyc() == 32) {
            this.zzi(256, false);
            return false;
        }
        if (this.zzcyc() == 8) {
            this.zzi(16, false);
            return false;
        }
        if (!this.zzcyn()) {
            return false;
        }
        if (this.bdm == null) {
            if (this.aDy == null) {
                this.aDy = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zzi(64, false);
            return false;
        }
        if (this.aDy != null) {
            this.zzi(64, false);
            return false;
        }
        boolean bl2 = bl = this.bdn != null || this.mResultCode < 200 || this.mResultCode >= 300;
        if (bl && !this.zzcx(true)) {
            if (this.zzcyn()) {
                this.zzi(64, false);
            }
            return false;
        }
        return true;
    }

    private boolean zzcyn() {
        if ("final".equals(this.bdo)) {
            if (this.aDy == null) {
                this.aDy = new IOException("The server has terminated the upload session");
            }
            this.zzi(64, false);
            return false;
        }
        return true;
    }

    private boolean zzcx(boolean bl) {
        zzamj zzamj2;
        try {
            zzamj2 = this.bbI.zzcxz().zzb(this.bbI.zzcya(), this.bdm.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.aDy = remoteException;
            return false;
        }
        if ("final".equals(this.bdo)) {
            return false;
        }
        if (bl ? !this.zzb(zzamj2) : !this.zza(zzamj2)) {
            return false;
        }
        if ("final".equals(zzamj2.zztl("X-Goog-Upload-Status"))) {
            this.aDy = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = zzamj2.zztl("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.bdk.get();
        if (l2 > l) {
            this.aDy = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if (this.bdl.skip(l - l2) != l - l2) {
                    this.aDy = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.bdk.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.aDy = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.aDy = iOException;
                return false;
            }
        }
        return true;
    }

    private void zzcyo() {
        zzamj zzamj2;
        int n;
        this.bdl.mark(this.bdi.length + 1);
        try {
            n = this.bdl.read(this.bdi);
        }
        catch (IOException iOException) {
            Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
            this.aDy = iOException;
            return;
        }
        try {
            zzamj2 = this.bbI.zzcxz().zza(this.bbI.zzcya(), this.bdm.toString(), this.bdi, this.bdk.get(), n, (long)n != 262144L);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            this.aDy = remoteException;
            return;
        }
        if (!this.zza(zzamj2)) {
            try {
                this.bdl.reset();
            }
            catch (IOException iOException) {
                Log.w((String)"UploadTask", (String)"Unable to reset the stream for error recovery.", (Throwable)iOException);
                this.aDy = iOException;
            }
            return;
        }
        if (n != -1) {
            this.bdk.getAndAdd(n);
        }
        if ((long)n != 262144L) {
            try {
                this.bcn = new StorageMetadata.Builder(zzamj2.zzczb(), this.bbI).build();
            }
            catch (RemoteException | JSONException throwable) {
                String string = String.valueOf(zzamj2.zzcyv());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                this.aDy = throwable;
                return;
            }
            this.zzi(4, false);
            this.zzi(128, false);
        }
    }

    private boolean zzaff(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    private boolean zza(zzamj zzamj2) {
        zzamj2.zza(zzamf.zzh(this.bbI.getApp()), this.bbI.getApp().getApplicationContext());
        return this.zzc(zzamj2);
    }

    private boolean zzb(zzamj zzamj2) {
        this.bbK.zzd(zzamj2);
        return this.zzc(zzamj2);
    }

    private boolean zzc(zzamj zzamj2) {
        int n = zzamj2.getResultCode();
        this.mResultCode = this.bbK.zzafj(n) ? -2 : n;
        this.bdn = zzamj2.getException();
        this.bdo = zzamj2.zztl("X-Goog-Upload-Status");
        return this.zzaff(this.mResultCode) && this.bdn == null;
    }

    @Override
    protected void onCanceled() {
        this.bbK.cancel();
        zzamj zzamj2 = null;
        try {
            zzamj2 = this.bbI.zzcxz().zza(this.bbI.zzcya(), this.bdm.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
        }
        if (zzamj2 != null) {
            final zzamj zzamj3 = zzamj2;
            zzd.zzcyh().zzt(new Runnable(){

                @Override
                public void run() {
                    zzamj3.zza(zzamf.zzh(UploadTask.this.bbI.getApp()), UploadTask.this.bbI.getApp().getApplicationContext());
                }
            });
        }
        this.aDy = StorageException.fromErrorStatus(Status.su);
        super.onCanceled();
    }

    @NonNull
    TaskSnapshot zzcyp() {
        Exception exception = this.aDy != null ? this.aDy : this.bdn;
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, this.mResultCode)), this.bdk.get(), this.bdm, this.bcn);
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError zzcxw() {
        return this.zzcyp();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long bdr;
        private final Uri bdm;
        private final StorageMetadata bcn;

        TaskSnapshot(Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            super(exception);
            this.bdr = l;
            this.bdm = uri;
            this.bcn = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.bdr;
        }

        public long getTotalByteCount() {
            return UploadTask.this.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.bdm;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.bcn;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

