/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.internal.zzanm;
import com.google.android.gms.internal.zzanv;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDownloadTask
extends StorageTask<TaskSnapshot> {
    private final Uri biG;
    private long biH;
    private StorageReference biD;
    private zzanm biF;
    private long IH = -1L;
    private String biI = null;
    private volatile Exception aJM = null;
    private long biJ = 0L;
    private int mResultCode;

    FileDownloadTask(@NonNull StorageReference storageReference, @NonNull Uri uri) {
        this.biD = storageReference;
        this.biG = uri;
        this.biF = new zzanm(this.biD.getStorage().getApp(), this.biD.getStorage().getMaxDownloadRetryTimeMillis());
    }

    long getTotalBytes() {
        return this.IH;
    }

    @Override
    @NonNull
    StorageReference getStorage() {
        return this.biD;
    }

    @Override
    protected void schedule() {
        zzd.at().zzv(this.zzcnk());
    }

    @NonNull
    TaskSnapshot ah() {
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(this.aJM, this.mResultCode)), this.biH);
    }

    @Override
    void run() {
        Object object;
        boolean bl;
        zzanv zzanv2;
        this.zzi(4, false);
        this.biF.reset();
        try {
            zzanv2 = this.biD.al().zza(this.biD.am(), this.biJ);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FileDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            this.aJM = remoteException;
            this.zzi(64, false);
            return;
        }
        this.biF.zza(zzanv2, false);
        this.mResultCode = zzanv2.getResultCode();
        this.aJM = zzanv2.getException() != null ? zzanv2.getException() : this.aJM;
        boolean bl2 = bl = this.zzagp(this.mResultCode) && this.aJM == null && this.ao() == 4;
        if (bl) {
            this.IH = zzanv2.aL();
            object = zzanv2.zzul("ETag");
            if (!TextUtils.isEmpty((CharSequence)object) && this.biI != null && !this.biI.equals(object)) {
                Log.w((String)"FileDownloadTask", (String)"The file at the server has changed.  Restarting from the beginning.");
                this.biJ = 0L;
                this.biI = null;
                zzanv2.aE();
                this.schedule();
                return;
            }
            this.biI = object;
            InputStream inputStream = zzanv2.getStream();
            if (inputStream != null) {
                try {
                    int n;
                    FileOutputStream fileOutputStream;
                    File file = new File(this.biG.getPath());
                    if (!file.exists()) {
                        if (this.biJ > 0L) {
                            String string = String.valueOf(file.getAbsolutePath());
                            Log.e((String)"FileDownloadTask", (String)(string.length() != 0 ? "The file downloading to has been deleted:".concat(string) : new String("The file downloading to has been deleted:")));
                            throw new IllegalStateException("expected a file to resume from.");
                        }
                        boolean bl3 = file.createNewFile();
                        if (!bl3) {
                            String string = String.valueOf(file.getAbsolutePath());
                            Log.w((String)"FileDownloadTask", (String)(string.length() != 0 ? "unable to create file:".concat(string) : new String("unable to create file:")));
                        }
                    }
                    if (this.biJ > 0L) {
                        String string = String.valueOf(file.getAbsolutePath());
                        Log.d((String)"FileDownloadTask", (String)(string.length() != 0 ? "Resuming download file ".concat(string) : new String("Resuming download file ")));
                        fileOutputStream = new FileOutputStream(file, true);
                    } else {
                        fileOutputStream = new FileOutputStream(file);
                    }
                    byte[] byArray = new byte[262144];
                    while ((n = inputStream.read(byArray)) != -1) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                        this.biH += (long)n;
                        if (this.zzi(4, false)) continue;
                    }
                    fileOutputStream.flush();
                    ((OutputStream)fileOutputStream).close();
                    inputStream.close();
                }
                catch (Exception exception) {
                    Log.e((String)"FileDownloadTask", (String)"Exception occurred during file download", (Throwable)exception);
                    this.aJM = exception;
                }
            } else {
                this.aJM = new IllegalStateException("Unable to open Firebase Storage stream.");
            }
        }
        zzanv2.aE();
        boolean bl4 = bl = bl && this.aJM == null && this.ao() == 4;
        if (bl) {
            this.zzi(128, false);
        } else {
            object = new File(this.biG.getPath());
            this.biJ = ((File)object).exists() ? ((File)object).length() : 0L;
            if (this.ao() == 8) {
                this.zzi(16, false);
            } else if (!this.zzi(this.ao() == 32 ? 256 : 64, false)) {
                int n = this.ao();
                Log.w((String)"FileDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
            }
        }
    }

    @Override
    protected void onCanceled() {
        this.biF.cancel();
    }

    private boolean zzagp(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError ai() {
        return this.ah();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long biH;

        TaskSnapshot(Exception exception, long l) {
            super(FileDownloadTask.this, exception);
            this.biH = l;
        }

        public long getBytesTransferred() {
            return this.biH;
        }

        public long getTotalByteCount() {
            return FileDownloadTask.this.getTotalBytes();
        }
    }
}

