/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.firebase.storage.ControllableTask;
import com.google.firebase.storage.OnPausedListener;
import com.google.firebase.storage.OnProgressListener;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.zzc;
import com.google.firebase.storage.zze;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executor;

public abstract class StorageTask<TResult extends ProvideError>
extends ControllableTask<TResult> {
    private static final HashMap<Integer, HashSet<Integer>> bjq = new HashMap();
    private static final HashMap<Integer, HashSet<Integer>> bjr = new HashMap();
    protected final Object mSyncObject = new Object();
    private final zze<OnSuccessListener<? super TResult>, TResult> bjs = new zze(this, 128, new zze.zza<OnSuccessListener<? super TResult>, TResult>(){

        public void zza(@NonNull OnSuccessListener<? super TResult> onSuccessListener, @NonNull TResult TResult) {
            zzc.as().zzb(StorageTask.this);
            onSuccessListener.onSuccess(TResult);
        }

        @Override
        public /* synthetic */ void zzl(@NonNull Object object, @NonNull Object object2) {
            this.zza((OnSuccessListener)object, (ProvideError)object2);
        }
    });
    private final zze<OnFailureListener, TResult> bjt = new zze(this, 320, new zze.zza<OnFailureListener, TResult>(){

        public void zza(@NonNull OnFailureListener onFailureListener, @NonNull TResult TResult) {
            zzc.as().zzb(StorageTask.this);
            onFailureListener.onFailure(TResult.getError());
        }

        @Override
        public /* synthetic */ void zzl(@NonNull Object object, @NonNull Object object2) {
            this.zza((OnFailureListener)object, (ProvideError)object2);
        }
    });
    private final zze<OnProgressListener<? super TResult>, TResult> bju = new zze(this, -465, new zze.zza<OnProgressListener<? super TResult>, TResult>(){

        public void zza(@NonNull OnProgressListener<? super TResult> onProgressListener, @NonNull TResult TResult) {
            onProgressListener.onProgress(TResult);
        }

        @Override
        public /* synthetic */ void zzl(@NonNull Object object, @NonNull Object object2) {
            this.zza((OnProgressListener)object, (ProvideError)object2);
        }
    });
    private final zze<OnPausedListener<? super TResult>, TResult> bjv = new zze(this, 16, new zze.zza<OnPausedListener<? super TResult>, TResult>(){

        public void zza(@NonNull OnPausedListener<? super TResult> onPausedListener, @NonNull TResult TResult) {
            onPausedListener.onPaused(TResult);
        }

        @Override
        public /* synthetic */ void zzl(@NonNull Object object, @NonNull Object object2) {
            this.zza((OnPausedListener)object, (ProvideError)object2);
        }
    });
    private int zzbwl = 1;
    private TResult bjw;

    protected StorageTask() {
    }

    boolean an() {
        if (this.zzi(2, false)) {
            this.schedule();
            return true;
        }
        return false;
    }

    void resetState() {
    }

    abstract StorageReference getStorage();

    abstract void schedule();

    @Override
    public boolean resume() {
        if (this.zzi(2, true)) {
            this.resetState();
            this.schedule();
            return true;
        }
        return false;
    }

    @Override
    public boolean pause() {
        return this.zzi(16, true) || this.zzi(8, true);
    }

    @Override
    public boolean cancel() {
        return this.zzi(256, true) || this.zzi(32, true);
    }

    public boolean isComplete() {
        return (this.ao() & 0x80) != 0 || (this.ao() & 0x140) != 0;
    }

    public boolean isSuccessful() {
        return (this.ao() & 0x80) != 0;
    }

    @Override
    public boolean isCanceled() {
        return this.ao() == 256;
    }

    @Override
    public boolean isInProgress() {
        return (this.ao() & 0xFFFFFE2F) != 0;
    }

    @Override
    public boolean isPaused() {
        return (this.ao() & 0x10) != 0;
    }

    public TResult getResult() {
        if (this.ar() == null) {
            throw new IllegalStateException();
        }
        Exception exception = this.ar().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.ar();
    }

    public <X extends Throwable> TResult getResult(@NonNull Class<X> clazz) throws X {
        if (this.ar() == null) {
            throw new IllegalStateException();
        }
        if (clazz.isInstance(this.ar().getError())) {
            throw (Throwable)clazz.cast(this.ar().getError());
        }
        Exception exception = this.ar().getError();
        if (exception != null) {
            throw new RuntimeExecutionException((Throwable)exception);
        }
        return this.ar();
    }

    @Nullable
    public Exception getException() {
        if (this.ar() == null) {
            return null;
        }
        return this.ar().getError();
    }

    public TResult getSnapshot() {
        return this.aq();
    }

    int ao() {
        return this.zzbwl;
    }

    Object ap() {
        return this.mSyncObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    TResult aq() {
        Object object = this.mSyncObject;
        synchronized (object) {
            return this.ai();
        }
    }

    @NonNull
    abstract TResult ai();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzi(int n, boolean bl) {
        Object object;
        Object object2;
        if (Log.isLoggable((String)"StorageTask", (int)3)) {
            object2 = String.valueOf(this.zzags(n));
            object = String.valueOf(this.zzags(this.zzbwl));
            Log.d((String)"StorageTask", (String)new StringBuilder(54 + String.valueOf(object2).length() + String.valueOf(object).length()).append("changing internal state to: ").append((String)object2).append(" isUser: ").append(bl).append(" from state:").append((String)object).toString());
        }
        object2 = this.mSyncObject;
        synchronized (object2) {
            object = bl ? bjq : bjr;
            HashSet<Integer> hashSet = ((HashMap)object).get(this.ao());
            if (hashSet != null && hashSet.contains(n)) {
                this.zzbwl = n;
                switch (this.zzbwl) {
                    case 2: {
                        zzc.as().zza(this);
                        this.onQueued();
                        break;
                    }
                    case 4: {
                        this.onProgress();
                        break;
                    }
                    case 16: {
                        this.onPaused();
                        break;
                    }
                    case 64: {
                        this.onFailure();
                        break;
                    }
                    case 128: {
                        this.onSuccess();
                        break;
                    }
                    case 256: {
                        this.onCanceled();
                    }
                }
                this.bjs.aw();
                this.bjt.aw();
                this.bjv.aw();
                this.bju.aw();
                return true;
            }
            String string = String.valueOf(this.zzags(n));
            String string2 = String.valueOf(this.zzags(this.zzbwl));
            Log.w((String)"StorageTask", (String)new StringBuilder(62 + String.valueOf(string).length() + String.valueOf(string2).length()).append("unable to change internal state to: ").append(string).append(" isUser: ").append(bl).append(" from state:").append(string2).toString());
            return false;
        }
    }

    protected void onQueued() {
    }

    protected void onProgress() {
    }

    protected void onPaused() {
    }

    protected void onFailure() {
    }

    protected void onSuccess() {
    }

    protected void onCanceled() {
    }

    private TResult ar() {
        if (this.bjw != null) {
            return this.bjw;
        }
        if (!this.isComplete()) {
            return null;
        }
        if (this.bjw == null) {
            this.bjw = this.aq();
        }
        return this.bjw;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzac.zzy(onPausedListener);
        this.bjv.zza(null, null, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Executor executor, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzac.zzy(onPausedListener);
        zzac.zzy((Object)executor);
        this.bjv.zza(null, executor, onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnPausedListener(@NonNull Activity activity, @NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzac.zzy(onPausedListener);
        zzac.zzy((Object)activity);
        this.bjv.zza(activity, null, onPausedListener);
        return this;
    }

    public StorageTask<TResult> removeOnPausedListener(@NonNull OnPausedListener<? super TResult> onPausedListener) {
        zzac.zzy(onPausedListener);
        this.bjv.zzcj(onPausedListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzac.zzy(onProgressListener);
        this.bju.zza(null, null, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Executor executor, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzac.zzy(onProgressListener);
        zzac.zzy((Object)executor);
        this.bju.zza(null, executor, onProgressListener);
        return this;
    }

    @Override
    public StorageTask<TResult> addOnProgressListener(@NonNull Activity activity, @NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzac.zzy(onProgressListener);
        zzac.zzy((Object)activity);
        this.bju.zza(activity, null, onProgressListener);
        return this;
    }

    public StorageTask<TResult> removeOnProgressListener(@NonNull OnProgressListener<? super TResult> onProgressListener) {
        zzac.zzy(onProgressListener);
        this.bju.zzcj(onProgressListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzac.zzy(onSuccessListener);
        this.bjs.zza(null, null, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzac.zzy((Object)executor);
        zzac.zzy(onSuccessListener);
        this.bjs.zza(null, executor, onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnSuccessListener(@NonNull Activity activity, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzac.zzy((Object)activity);
        zzac.zzy(onSuccessListener);
        this.bjs.zza(activity, null, onSuccessListener);
        return this;
    }

    public StorageTask<TResult> removeOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzac.zzy(onSuccessListener);
        this.bjs.zzcj(onSuccessListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzac.zzy((Object)onFailureListener);
        this.bjt.zza(null, null, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener onFailureListener) {
        zzac.zzy((Object)onFailureListener);
        zzac.zzy((Object)executor);
        this.bjt.zza(null, executor, onFailureListener);
        return this;
    }

    @NonNull
    public StorageTask<TResult> addOnFailureListener(@NonNull Activity activity, @NonNull OnFailureListener onFailureListener) {
        zzac.zzy((Object)onFailureListener);
        zzac.zzy((Object)activity);
        this.bjt.zza(activity, null, onFailureListener);
        return this;
    }

    public StorageTask<TResult> removeOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        zzac.zzy((Object)onFailureListener);
        this.bjt.zzcj(onFailureListener);
        return this;
    }

    abstract void run();

    Runnable zzcnk() {
        return new Runnable(){

            @Override
            public void run() {
                StorageTask.this.run();
            }
        };
    }

    private String zzags(int n) {
        switch (n) {
            case 1: {
                return "INTERNAL_STATE_NOT_STARTED";
            }
            case 2: {
                return "INTERNAL_STATE_QUEUED";
            }
            case 4: {
                return "INTERNAL_STATE_IN_PROGRESS";
            }
            case 8: {
                return "INTERNAL_STATE_PAUSING";
            }
            case 16: {
                return "INTERNAL_STATE_PAUSED";
            }
            case 32: {
                return "INTERNAL_STATE_CANCELING";
            }
            case 64: {
                return "INTERNAL_STATE_FAILURE";
            }
            case 128: {
                return "INTERNAL_STATE_SUCCESS";
            }
            case 256: {
                return "INTERNAL_STATE_CANCELED";
            }
        }
        return "Unknown Internal State!";
    }

    static {
        bjq.put(1, new HashSet<Integer>(Arrays.asList(16, 256)));
        bjq.put(2, new HashSet<Integer>(Arrays.asList(8, 32)));
        bjq.put(4, new HashSet<Integer>(Arrays.asList(8, 32)));
        bjq.put(16, new HashSet<Integer>(Arrays.asList(2, 256)));
        bjq.put(64, new HashSet<Integer>(Arrays.asList(2, 256)));
        bjr.put(1, new HashSet<Integer>(Collections.singletonList(2)));
        bjr.put(2, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        bjr.put(4, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        bjr.put(8, new HashSet<Integer>(Arrays.asList(16, 64, 128)));
        bjr.put(32, new HashSet<Integer>(Arrays.asList(256, 64, 128)));
    }

    class SnapshotBase
    implements ProvideError {
        private final Exception bjy;

        public SnapshotBase(Exception exception) {
            this.bjy = exception;
        }

        @NonNull
        public StorageTask<TResult> getTask() {
            return StorageTask.this;
        }

        @NonNull
        public StorageReference getStorage() {
            return this.getTask().getStorage();
        }

        @Override
        @Nullable
        public Exception getError() {
            return this.bjy;
        }
    }

    protected static interface ProvideError {
        public Exception getError();
    }
}

