/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzaoj;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

public class zzaom {
    private zzaoj bnN;
    private Exception aMX;
    private int bnO;
    private Exception bnP;

    public zzaom(@NonNull zzaoj zzaoj2) {
        this.bnN = zzaoj2;
    }

    public void zzby(String string, String string2) {
        try {
            this.bnN.zzby(string, string2);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string3.length() != 0 ? "Caught remote exception setting custom header:".concat(string3) : new String("Caught remote exception setting custom header:")), (Throwable)remoteException);
        }
    }

    private boolean zzez(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            this.bnO = -2;
            this.bnP = new SocketException("Network subsystem is unavailable");
            return false;
        }
        return true;
    }

    @Nullable
    public String zzul(String string) {
        try {
            return this.bnN.zzul(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public void zza(@Nullable String string, @NonNull Context context) {
        try {
            if (!this.zzez(context)) {
                return;
            }
            this.bnN.zzuj(string);
        }
        catch (RemoteException remoteException) {
            this.aMX = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequest failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void reset() {
        try {
            this.bnO = 0;
            this.bnP = null;
            this.bnN.reset();
        }
        catch (RemoteException remoteException) {
            this.aMX = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"reset failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void zzuk(@Nullable String string) {
        try {
            this.bnN.zzuk(string);
        }
        catch (RemoteException remoteException) {
            this.aMX = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestStart failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void aH() {
        try {
            this.bnN.aH();
        }
        catch (RemoteException remoteException) {
            this.aMX = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestEnd failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    @Nullable
    public InputStream getStream() {
        try {
            return (InputStream)zze.zzae((zzd)this.bnN.aI());
        }
        catch (RemoteException remoteException) {
            this.aMX = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getStream failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @NonNull
    public JSONObject aQ() throws RemoteException {
        return (JSONObject)zze.zzae((zzd)this.bnN.aJ());
    }

    @Nullable
    public String aK() {
        try {
            this.bnN.aK();
        }
        catch (RemoteException remoteException) {
            this.aMX = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getRawResult failed with a RemoteException:", (Throwable)remoteException);
        }
        return null;
    }

    @Nullable
    public Exception getException() {
        try {
            if (this.bnP != null) {
                return this.bnP;
            }
            return this.aMX != null ? this.aMX : (Exception)zze.zzae((zzd)this.bnN.aM());
        }
        catch (RemoteException remoteException) {
            this.aMX = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getException failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    public int getResultCode() {
        try {
            if (this.bnO != 0) {
                return this.bnO;
            }
            return this.bnN.getResultCode();
        }
        catch (RemoteException remoteException) {
            this.aMX = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultCode failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }

    public boolean aN() {
        try {
            if (this.bnO == -2 || this.bnP != null) {
                return false;
            }
            return this.bnN.aN();
        }
        catch (RemoteException remoteException) {
            this.aMX = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"isResultSuccess failed with a RemoteException:", (Throwable)remoteException);
            return false;
        }
    }

    public <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.getException();
        if (this.aN() && exception == null) {
            taskCompletionSource.setResult(TResult);
        } else {
            StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
            assert (storageException != null);
            taskCompletionSource.setException((Exception)((Object)storageException));
        }
    }

    public int aO() {
        try {
            return this.bnN.aO();
        }
        catch (RemoteException remoteException) {
            this.aMX = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultingContentLength failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }
}

