/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.internal.zzaod;
import com.google.android.gms.internal.zzaom;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDownloadTask
extends StorageTask<TaskSnapshot> {
    private final Uri blT;
    private long blU;
    private StorageReference blQ;
    private zzaod blS;
    private long Ks = -1L;
    private String blV = null;
    private volatile Exception aMX = null;
    private long blW = 0L;
    private int mResultCode;

    FileDownloadTask(@NonNull StorageReference storageReference, @NonNull Uri uri) {
        this.blQ = storageReference;
        this.blT = uri;
        this.blS = new zzaod(this.blQ.getStorage().getApp(), this.blQ.getStorage().getMaxDownloadRetryTimeMillis());
    }

    long getTotalBytes() {
        return this.Ks;
    }

    @Override
    @NonNull
    StorageReference getStorage() {
        return this.blQ;
    }

    @Override
    protected void schedule() {
        zzd.aw().zzv(this.zzcnk());
    }

    @NonNull
    TaskSnapshot aj() {
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(this.aMX, this.mResultCode)), this.blU);
    }

    @Override
    void run() {
        Object object;
        boolean bl;
        zzaom zzaom2;
        if (!this.zzf(4, false)) {
            return;
        }
        this.blS.reset();
        try {
            zzaom2 = this.blQ.an().zza(this.blQ.ao(), this.blW);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FileDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
            this.aMX = remoteException;
            this.zzf(64, false);
            return;
        }
        this.blS.zza(zzaom2, false);
        this.mResultCode = zzaom2.getResultCode();
        this.aMX = zzaom2.getException() != null ? zzaom2.getException() : this.aMX;
        boolean bl2 = bl = this.zzagg(this.mResultCode) && this.aMX == null && this.aq() == 4;
        if (bl) {
            this.Ks = zzaom2.aO();
            object = zzaom2.zzul("ETag");
            if (!TextUtils.isEmpty((CharSequence)object) && this.blV != null && !this.blV.equals(object)) {
                Log.w((String)"FileDownloadTask", (String)"The file at the server has changed.  Restarting from the beginning.");
                this.blW = 0L;
                this.blV = null;
                zzaom2.aH();
                this.schedule();
                return;
            }
            this.blV = object;
            InputStream inputStream = zzaom2.getStream();
            if (inputStream != null) {
                try {
                    int n;
                    FileOutputStream fileOutputStream;
                    File file = new File(this.blT.getPath());
                    if (!file.exists()) {
                        if (this.blW > 0L) {
                            String string = String.valueOf(file.getAbsolutePath());
                            Log.e((String)"FileDownloadTask", (String)(string.length() != 0 ? "The file downloading to has been deleted:".concat(string) : new String("The file downloading to has been deleted:")));
                            throw new IllegalStateException("expected a file to resume from.");
                        }
                        boolean bl3 = file.createNewFile();
                        if (!bl3) {
                            String string = String.valueOf(file.getAbsolutePath());
                            Log.w((String)"FileDownloadTask", (String)(string.length() != 0 ? "unable to create file:".concat(string) : new String("unable to create file:")));
                        }
                    }
                    if (this.blW > 0L) {
                        String string = String.valueOf(file.getAbsolutePath());
                        Log.d((String)"FileDownloadTask", (String)(string.length() != 0 ? "Resuming download file ".concat(string) : new String("Resuming download file ")));
                        fileOutputStream = new FileOutputStream(file, true);
                    } else {
                        fileOutputStream = new FileOutputStream(file);
                    }
                    byte[] byArray = new byte[262144];
                    while ((n = inputStream.read(byArray)) != -1) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                        this.blU += (long)n;
                        if (this.zzf(4, false)) continue;
                    }
                    fileOutputStream.flush();
                    ((OutputStream)fileOutputStream).close();
                    inputStream.close();
                }
                catch (Exception exception) {
                    Log.e((String)"FileDownloadTask", (String)"Exception occurred during file download", (Throwable)exception);
                    this.aMX = exception;
                }
            } else {
                this.aMX = new IllegalStateException("Unable to open Firebase Storage stream.");
            }
        }
        zzaom2.aH();
        boolean bl4 = bl = bl && this.aMX == null && this.aq() == 4;
        if (bl) {
            this.zzf(128, false);
        } else {
            object = new File(this.blT.getPath());
            this.blW = ((File)object).exists() ? ((File)object).length() : 0L;
            if (this.aq() == 8) {
                this.zzf(16, false);
            } else if (!this.zzf(this.aq() == 32 ? 256 : 64, false)) {
                int n = this.aq();
                Log.w((String)"FileDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n).toString());
            }
        }
    }

    @Override
    protected void onCanceled() {
        this.blS.cancel();
    }

    private boolean zzagg(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError ak() {
        return this.aj();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long blU;

        TaskSnapshot(Exception exception, long l) {
            super(FileDownloadTask.this, exception);
            this.blU = l;
        }

        public long getBytesTransferred() {
            return this.blU;
        }

        public long getTotalByteCount() {
            return FileDownloadTask.this.getTotalBytes();
        }
    }
}

