/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin;

import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import com.google.common.base.Ascii;
import com.google.firebase.perf.plugin.FirebasePerfExtension;
import com.google.firebase.perf.plugin.FirebasePerfTransform;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirebasePerfPlugin
implements Plugin<Project> {
    public static final String FIREBASE_PERF_TAG = "FirebasePerformancePlugin";
    public static final String FIREBASE_PERF_EXTENSION_NAME = "FirebasePerformance";
    public static final String FIREBASE_PERF_INSTRUMENTATION_ENABLED_KEY = "firebasePerformanceInstrumentationEnabled";
    private static final Logger logger = LoggerFactory.getLogger((String)"FirebasePerformancePlugin");
    private boolean foundAppPlugin = false;

    public void apply(Project project) {
        project.getPluginManager().withPlugin("com.android.application", androidPlugin -> {
            this.foundAppPlugin = true;
            AppExtension androidExt = (AppExtension)project.getExtensions().getByType(AppExtension.class);
            FirebasePerfPlugin.registerExtension(androidExt);
            if (FirebasePerfPlugin.isPluginDisabledByProjectPropertyValue(project)) {
                logger.info(String.format("%s is disabled globally for the project by specifying '%s=false' flag in the 'gradle.properties' file.", FIREBASE_PERF_TAG, FIREBASE_PERF_INSTRUMENTATION_ENABLED_KEY));
            } else {
                FirebasePerfPlugin.perform(project, androidExt);
            }
        });
        project.afterEvaluate(project2 -> {
            if (!this.foundAppPlugin) {
                throw new IllegalStateException("FirebasePerformancePlugin must only be used with Android application projects. Need to apply the 'com.android.application' plugin with this plugin.");
            }
        });
    }

    private static void perform(Project project, AppExtension androidExt) {
        androidExt.registerTransform((Transform)new FirebasePerfTransform(project), new Object[0]);
    }

    private static void registerExtension(AppExtension androidExt) {
        androidExt.getBuildTypes().all(buildType -> ((ExtensionAware)buildType).getExtensions().add(FIREBASE_PERF_EXTENSION_NAME, FirebasePerfExtension.class));
        androidExt.getProductFlavors().all(productFlavor -> ((ExtensionAware)productFlavor).getExtensions().add(FIREBASE_PERF_EXTENSION_NAME, FirebasePerfExtension.class));
    }

    private static boolean isPluginDisabledByProjectPropertyValue(Project project) {
        Optional<Boolean> parsedPropVal = FirebasePerfPlugin.getProjectPropertyValue(project);
        return parsedPropVal.isPresent() && Boolean.FALSE.equals(parsedPropVal.get());
    }

    static Optional<Boolean> getProjectPropertyValue(Project project) {
        if (!project.hasProperty(FIREBASE_PERF_INSTRUMENTATION_ENABLED_KEY)) {
            return Optional.empty();
        }
        String propVal = project.property(FIREBASE_PERF_INSTRUMENTATION_ENABLED_KEY).toString();
        Optional<Boolean> parsedPropVal = FirebasePerfPlugin.parseBoolean(propVal);
        if (parsedPropVal.isPresent()) {
            return parsedPropVal;
        }
        throw new IllegalStateException(String.format("Could not get unknown value '%s' for the project property '%s' defined in the 'gradle.properties' file. Correct format is either '%s=false' or '%s=true'.", propVal, FIREBASE_PERF_INSTRUMENTATION_ENABLED_KEY, FIREBASE_PERF_INSTRUMENTATION_ENABLED_KEY, FIREBASE_PERF_INSTRUMENTATION_ENABLED_KEY));
    }

    private static Optional<Boolean> parseBoolean(String s) {
        if (s != null && (Ascii.equalsIgnoreCase((CharSequence)s, (CharSequence)"true") || Ascii.equalsIgnoreCase((CharSequence)s, (CharSequence)"false"))) {
            return Optional.of(Boolean.parseBoolean(s));
        }
        return Optional.empty();
    }

    public static Logger getLogger() {
        return logger;
    }

    public static String getPluginVersion() {
        return FirebasePerfPlugin.getPluginVersion(FirebasePerfPlugin.class.getClassLoader(), "com/google/firebase/perf/plugin/project.properties");
    }

    static String getPluginVersion(ClassLoader classLoader, String projectPropsResFile) {
        Properties properties = new Properties();
        if (classLoader != null) {
            try (BufferedInputStream stream = new BufferedInputStream(classLoader.getResourceAsStream(projectPropsResFile));){
                properties.load(stream);
            }
            catch (IOException e) {
                logger.warn(String.format("Could not load '%s' file.", projectPropsResFile), (Throwable)e);
            }
        }
        return properties.getProperty("pluginVersion", "unknown");
    }
}

