/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin;

import android.support.annotation.NonNull;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.api.variant.VariantInfo;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.builder.model.ProductFlavor;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.firebase.perf.plugin.FirebasePerfExtension;
import com.google.firebase.perf.plugin.FirebasePerfPlugin;
import com.google.firebase.perf.plugin.instrumentation.Instrument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.slf4j.Logger;

public class FirebasePerfTransform
extends Transform {
    private static final Logger logger = FirebasePerfPlugin.getLogger();
    private final Project project;
    private final AppExtension androidExt;
    private final Set<QualifiedContent.ContentType> typeClasses;
    private final Set<QualifiedContent.Scope> scopes;
    private Instrument firebasePerfInstrumentation;
    private final Map<String, Boolean> variantsToInstrumentationEnabled = new HashMap<String, Boolean>();
    private boolean instrumentationEnabled = true;
    private boolean applyToVariantUsed = false;

    public FirebasePerfTransform(Project project) {
        this.project = project;
        this.androidExt = (AppExtension)project.getExtensions().getByType(AppExtension.class);
        this.typeClasses = ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES);
        this.scopes = ImmutableSet.of((Object)QualifiedContent.Scope.EXTERNAL_LIBRARIES, (Object)QualifiedContent.Scope.PROJECT, (Object)QualifiedContent.Scope.SUB_PROJECTS);
    }

    @NonNull
    public String getName() {
        return "FirebasePerformancePlugin";
    }

    @NonNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        return this.typeClasses;
    }

    @NonNull
    public Set<QualifiedContent.Scope> getScopes() {
        return this.scopes;
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean applyToVariant(VariantInfo variant) {
        this.applyToVariantUsed = true;
        boolean enabled = this.instrumentationEnabledFor(variant.getFullVariantName(), variant.getBuildTypeName(), (List<String>)variant.getFlavorNames());
        logger.info(String.format("applyToVariant(%s): %s", variant, enabled));
        return enabled;
    }

    @NonNull
    public Map<String, Object> getParameterInputs() {
        if (!this.applyToVariantUsed) {
            this.androidExt.getApplicationVariants().all(this::updateInstrumentationEnabledFor);
        }
        return ImmutableMap.copyOf(this.variantsToInstrumentationEnabled);
    }

    private void updateInstrumentationEnabledFor(ApplicationVariant applicationVariant) {
        String variant = applicationVariant.getName();
        ArrayList<String> productFlavors = new ArrayList<String>();
        for (ProductFlavor flavor : applicationVariant.getProductFlavors()) {
            productFlavors.add(flavor.getName());
        }
        this.variantsToInstrumentationEnabled.put(variant, this.instrumentationEnabledFor(variant, applicationVariant.getBuildType().getName(), productFlavors));
    }

    private boolean instrumentationEnabledFor(String variant, String buildType, List<String> flavors) {
        Optional<Boolean> parsedPropVal = this.getProjectPropertyExtensionValue();
        if (parsedPropVal.isPresent()) {
            logger.info(String.format("Firebase Performance Instrumentation is %s per the Project Property specified in the 'gradle.properties' file.", parsedPropVal.get() != false ? "enabled" : "disabled"));
            return parsedPropVal.get();
        }
        Optional<Boolean> parsedBuildTypeVal = this.getBuildTypeExtensionValue(buildType);
        if (parsedBuildTypeVal.isPresent()) {
            logger.info(String.format(" Firebase Performance Instrumentation is %s for %s variant per the Extension Property specified (for buildType=%s) in the 'build.gradle' file.", parsedBuildTypeVal.get() != false ? "enabled" : "disabled", variant, buildType));
            return parsedBuildTypeVal.get();
        }
        Optional<Boolean> parsedFlavorsVal = this.getProductFlavorsExtensionValue(flavors);
        if (parsedFlavorsVal.isPresent()) {
            logger.info(String.format(" Firebase Performance Instrumentation is %s for %s variant per the Extension Property specified (for flavors=%s) in the 'build.gradle' file.", parsedFlavorsVal.get() != false ? "enabled" : "disabled", variant, flavors));
            return parsedFlavorsVal.get();
        }
        logger.info(String.format("Firebase Performance Instrumentation is %s by default for %s variant.", this.instrumentationEnabled ? "enabled" : "disabled", variant));
        return this.instrumentationEnabled;
    }

    private Optional<Boolean> getProjectPropertyExtensionValue() {
        return FirebasePerfPlugin.getProjectPropertyValue(this.project);
    }

    private Optional<Boolean> getBuildTypeExtensionValue(String buildType) {
        BuildType dslBuildType = (BuildType)this.androidExt.getBuildTypes().getByName(buildType);
        FirebasePerfExtension buildTypeExt = (FirebasePerfExtension)((ExtensionAware)dslBuildType).getExtensions().getByType(FirebasePerfExtension.class);
        return buildTypeExt != null ? buildTypeExt.isInstrumentationEnabled() : Optional.empty();
    }

    private Optional<Boolean> getProductFlavorsExtensionValue(List<String> flavors) {
        for (String flavor : flavors) {
            com.android.build.gradle.internal.dsl.ProductFlavor dslFlavor = (com.android.build.gradle.internal.dsl.ProductFlavor)this.androidExt.getProductFlavors().getByName(flavor);
            FirebasePerfExtension flavorExt = (FirebasePerfExtension)((ExtensionAware)dslFlavor).getExtensions().getByType(FirebasePerfExtension.class);
            if (flavorExt == null || !flavorExt.isInstrumentationEnabled().isPresent()) continue;
            return flavorExt.isInstrumentationEnabled();
        }
        return Optional.empty();
    }

    public void transform(TransformInvocation invocation) throws IOException {
        Collection transformInputs = invocation.getInputs();
        Collection referencedInputs = invocation.getReferencedInputs();
        TransformOutputProvider outputProvider = invocation.getOutputProvider();
        boolean incremental = invocation.isIncremental();
        String variantName = invocation.getContext().getVariantName();
        this.instrumentationEnabled = this.applyToVariantUsed || this.variantsToInstrumentationEnabled.getOrDefault(variantName, this.instrumentationEnabled) != false;
        logger.info(String.format("Executing transform for build variant: %s; instrumentationEnabled: %b, applyToVariantUsed: %b", invocation.getContext().getVariantName(), this.instrumentationEnabled, this.applyToVariantUsed));
        List<URL> runtimeCP = this.buildRuntimeClasspath(transformInputs, referencedInputs);
        logger.debug("Effective app classpath at runtime:");
        for (URL url : runtimeCP) {
            logger.debug("- " + url);
        }
        try (URLClassLoader cl = new URLClassLoader(runtimeCP.toArray(new URL[0]), null);){
            logger.info("Transforming with incremental: " + incremental);
            if (!incremental) {
                outputProvider.deleteAll();
            }
            this.firebasePerfInstrumentation = new Instrument(cl);
            for (TransformInput transformInput : transformInputs) {
                this.transformDirectoryInputs(transformInput, incremental, outputProvider);
                this.transformJarInputs(transformInput, incremental, outputProvider);
            }
        }
    }

    private void transformJarInputs(TransformInput transformInput, boolean incremental, TransformOutputProvider outputProvider) throws IOException {
        for (JarInput jarInput : transformInput.getJarInputs()) {
            boolean doXForm;
            logger.debug("Transforming JarInput: " + jarInput);
            String uniqueName = this.generateUniqueNameFor(jarInput);
            File outDir = outputProvider.getContentLocation(uniqueName, jarInput.getContentTypes(), jarInput.getScopes(), Format.DIRECTORY);
            logger.debug("Jar input: " + jarInput.getFile());
            logger.debug("Directory output: " + outDir);
            boolean bl = doXForm = !incremental || Status.ADDED.equals((Object)jarInput.getStatus()) || Status.CHANGED.equals((Object)jarInput.getStatus());
            if (doXForm) {
                if (this.instrumentationEnabled) {
                    this.performTransformationFor(jarInput, outDir);
                    continue;
                }
                this.performDummyTransformationFor(jarInput, outputProvider.getContentLocation(uniqueName, jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR));
                continue;
            }
            if (Status.REMOVED.equals((Object)jarInput.getStatus())) {
                FileUtils.deleteQuietly((File)outDir);
                continue;
            }
            logger.debug("Skipping transforming: " + jarInput.getFile());
        }
    }

    private void transformDirectoryInputs(TransformInput transformInput, boolean incremental, TransformOutputProvider outputProvider) throws IOException {
        for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
            logger.debug("Transforming DirectoryInput: " + directoryInput);
            String uniqueName = this.generateUniqueNameFor(directoryInput);
            File outDir = outputProvider.getContentLocation(uniqueName, directoryInput.getContentTypes(), directoryInput.getScopes(), Format.DIRECTORY);
            logger.debug("Directory input: " + directoryInput.getFile());
            logger.debug("Directory output: " + outDir);
            if (!outDir.mkdirs() && !outDir.isDirectory()) continue;
            if (this.instrumentationEnabled) {
                this.performTransformationFor(directoryInput, outDir, incremental ? directoryInput.getChangedFiles() : null);
                continue;
            }
            this.performDummyTransformationFor(directoryInput, outDir);
        }
    }

    private List<URL> buildRuntimeClasspath(Collection<TransformInput> transformInputs, Collection<TransformInput> referencedInputs) {
        ArrayList<File> classPaths = new ArrayList<File>(this.androidExt.getBootClasspath());
        for (Collection transformInputCollection : Arrays.asList(transformInputs, referencedInputs)) {
            for (TransformInput transformInput : transformInputCollection) {
                List<Collection> allQualifiedContents = Arrays.asList(transformInput.getDirectoryInputs(), transformInput.getJarInputs());
                for (Collection qualifiedContentCollection : allQualifiedContents) {
                    for (QualifiedContent qualifiedContent : qualifiedContentCollection) {
                        classPaths.add(qualifiedContent.getFile());
                    }
                }
            }
        }
        return classPaths.stream().map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                logger.error("Unable to instrument classes due to file: " + file);
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    private String generateUniqueNameFor(JarInput jarInput) {
        File jar = jarInput.getFile();
        String jarName = jar.getName();
        int lastIndex = jarName.lastIndexOf(46);
        if (lastIndex != -1) {
            return DigestUtils.md5Hex((String)jar.getPath()) + "-" + jarName.substring(0, lastIndex);
        }
        return DigestUtils.md5Hex((String)jar.getPath()) + "-" + jarName;
    }

    private String generateUniqueNameFor(DirectoryInput directoryInput) {
        return DigestUtils.md5Hex((String)directoryInput.getFile().getPath());
    }

    private void performTransformationFor(JarInput jarInput, File outDir) throws IOException {
        if (outDir.mkdirs() || outDir.isDirectory()) {
            this.firebasePerfInstrumentation.instrumentClassesInJar(jarInput.getFile(), outDir);
        }
    }

    private void performTransformationFor(DirectoryInput directoryInput, File outDir, Map<File, Status> changedFiles) throws IOException {
        this.firebasePerfInstrumentation.instrumentClassesInDir(directoryInput.getFile(), 0, outDir + "/", changedFiles);
    }

    private void performDummyTransformationFor(JarInput jarInput, File outJar) throws IOException {
        block25: {
            if (outJar.getParentFile().mkdirs() || outJar.getParentFile().isDirectory()) {
                try (FileInputStream fis = new FileInputStream(jarInput.getFile());
                     FileOutputStream fos = new FileOutputStream(outJar);){
                    IOUtils.copy((InputStream)fis, (OutputStream)fos);
                    break block25;
                }
            }
            throw new IOException("Couldn't create transform output: " + outJar.getParentFile());
        }
    }

    private void performDummyTransformationFor(DirectoryInput directoryInput, File outDir) throws IOException {
        FileUtils.deleteDirectory((File)outDir);
        FileUtils.copyDirectory((File)directoryInput.getFile(), (File)outDir);
    }
}

