/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin;

import com.android.build.api.instrumentation.AsmClassVisitorFactory;
import com.android.build.api.instrumentation.ClassContext;
import com.android.build.api.instrumentation.ClassData;
import com.android.build.api.instrumentation.FramesComputationMode;
import com.android.build.api.instrumentation.InstrumentationParameters;
import com.android.build.api.instrumentation.InstrumentationScope;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.ApplicationVariant;
import com.google.firebase.perf.plugin.InstrumentationFlagState;
import com.google.firebase.perf.plugin.instrumentation.Instrument;
import com.google.firebase.perf.plugin.instrumentation.InstrumentationConfigFactory;
import com.google.firebase.perf.plugin.instrumentation.InstrumentationVisitor;
import java.lang.reflect.InvocationTargetException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.objectweb.asm.ClassVisitor;

public abstract class FirebasePerfClassVisitorFactory
implements AsmClassVisitorFactory<InstrumentationParameters.None> {
    private static String REMOVED_ANDROID_COMPONENTS_EXTENSION_CLASS = "com.android.build.api.extension.AndroidComponentsExtension";
    private static String REMOVED_VARIANT_SELECTOR_CLASS = "com.android.build.api.extension.VariantSelector";

    @Nonnull
    public ClassVisitor createClassVisitor(@Nonnull ClassContext classContext, @Nonnull ClassVisitor classVisitor) {
        return new InstrumentationVisitor((Integer)this.getInstrumentationContext().getApiVersion().get(), classVisitor, new InstrumentationConfigFactory().newClassDataBasedInstrumentationConfig(classContext));
    }

    public boolean isInstrumentable(@Nonnull ClassData classData) {
        return Instrument.isClassInstrumentable(classData.getClassName());
    }

    public static void registerForProject(Project project, InstrumentationFlagState instrumentationFlagState, boolean useInstrumentationApi) {
        AndroidComponentsExtension androidComponents = (AndroidComponentsExtension)project.getExtensions().getByType(AndroidComponentsExtension.class);
        androidComponents.onVariants(androidComponents.selector().all(), variant -> FirebasePerfClassVisitorFactory.registerForVariant((ApplicationVariant)variant, instrumentationFlagState, useInstrumentationApi));
    }

    public static void registerForProjectWithDeprecatedVariantApi(Project project, InstrumentationFlagState instrumentationFlagState) throws ClassNotFoundException {
        try {
            Class<?> AndroidComponentsExtension2 = FirebasePerfClassVisitorFactory.class.getClassLoader().loadClass(REMOVED_ANDROID_COMPONENTS_EXTENSION_CLASS);
            Class<?> VariantSelector2 = FirebasePerfClassVisitorFactory.class.getClassLoader().loadClass(REMOVED_VARIANT_SELECTOR_CLASS);
            Object androidComponents = project.getExtensions().getByType(AndroidComponentsExtension2);
            Object selector = AndroidComponentsExtension2.getMethod("selector", new Class[0]).invoke(androidComponents, new Object[0]);
            AndroidComponentsExtension2.getMethod("onVariants", VariantSelector2, Function1.class).invoke(androidComponents, selector.getClass().getMethod("all", new Class[0]).invoke(selector, new Object[0]), applicationVariant -> {
                FirebasePerfClassVisitorFactory.registerForVariant(applicationVariant, instrumentationFlagState, false);
                return Unit.INSTANCE;
            });
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new GradleException("perf-plugin failed to register for project with AGP version 4.2.*: " + e.getMessage());
        }
    }

    private static void registerForVariant(ApplicationVariant appVariant, InstrumentationFlagState instrumentationFlagState, boolean useInstrumentationApi) {
        boolean instrumentationEnabled = instrumentationFlagState.isEnabledFor(appVariant.getName(), appVariant.getBuildType(), appVariant.getProductFlavors().stream().map(productFlavor -> (String)productFlavor.getSecond()).collect(Collectors.toList()));
        if (instrumentationEnabled) {
            if (useInstrumentationApi) {
                appVariant.getInstrumentation().transformClassesWith(FirebasePerfClassVisitorFactory.class, InstrumentationScope.ALL, params -> Unit.INSTANCE);
                appVariant.getInstrumentation().setAsmFramesComputationMode(FramesComputationMode.COMPUTE_FRAMES_FOR_INSTRUMENTED_CLASSES);
            } else {
                appVariant.transformClassesWith(FirebasePerfClassVisitorFactory.class, InstrumentationScope.ALL, params -> Unit.INSTANCE);
                appVariant.setAsmFramesComputationMode(FramesComputationMode.COMPUTE_FRAMES_FOR_INSTRUMENTED_CLASSES);
            }
        }
    }
}

