/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin;

import com.android.Version;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import com.android.ide.common.repository.GradleVersion;
import com.google.firebase.perf.plugin.FirebasePerfClassVisitorFactory;
import com.google.firebase.perf.plugin.FirebasePerfExtension;
import com.google.firebase.perf.plugin.FirebasePerfTransform;
import com.google.firebase.perf.plugin.InstrumentationFlagState;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirebasePerfPlugin
implements Plugin<Project> {
    public static final String FIREBASE_PERF_TAG = "FirebasePerformancePlugin";
    public static final String MINIMUM_SUPPORTED_AGP_VERSION_FOR_NEW_TRANSFORM_API = "4.2.0-rc01";
    public static final String AGP_NEW_VARIANT_API_VERSION = "7.0.0";
    public static final String AGP_NEW_INSTRUMENTATION_API_VERSION = "7.2.0";
    private static final Logger logger = LoggerFactory.getLogger((String)"FirebasePerformancePlugin");
    public static final String FIREBASE_PERF_EXTENSION_NAME = "FirebasePerformance";
    public static final String FIREBASE_PERF_INSTRUMENTATION_ENABLED_KEY = "firebasePerformanceInstrumentationEnabled";
    private static boolean instrumentFireperfE2ETest = false;
    private boolean foundApplicationPlugin = false;

    public void apply(Project project) {
        instrumentFireperfE2ETest = project.getProperties().containsKey("instrumentFireperfE2ETest") && project.getProperties().get("instrumentFireperfE2ETest").equals("true");
        project.getPluginManager().withPlugin("com.android.application", androidPlugin -> {
            this.foundApplicationPlugin = true;
            try {
                this.perform(project);
            }
            catch (ClassNotFoundException e) {
                logger.error("Perform performance plugin failed: class not found " + e.getMessage());
            }
        });
        project.afterEvaluate(project2 -> {
            if (!this.foundApplicationPlugin) {
                throw new IllegalStateException("FirebasePerformancePlugin must only be used with Android application projects. Need to apply the 'com.android.application' plugin with this plugin.");
            }
        });
    }

    private void perform(Project project) throws ClassNotFoundException {
        AppExtension androidExt = (AppExtension)project.getExtensions().getByType(AppExtension.class);
        this.registerExtension(androidExt);
        InstrumentationFlagState instrumentationFlagState = new InstrumentationFlagState(project);
        Optional<Boolean> parsedProjectPropertyValue = instrumentationFlagState.getProjectPropertyValue();
        if (parsedProjectPropertyValue.isPresent() && Boolean.FALSE.equals(parsedProjectPropertyValue.get())) {
            logger.info(String.format("%s is disabled globally for the project by specifying '%s=false' flag in the 'gradle.properties' file.", FIREBASE_PERF_TAG, FIREBASE_PERF_INSTRUMENTATION_ENABLED_KEY));
        } else if (this.useNewAgpTransformApi()) {
            if (this.useNewVariantApi()) {
                FirebasePerfClassVisitorFactory.registerForProject(project, instrumentationFlagState, this.useInstrumentationApi());
            } else {
                FirebasePerfClassVisitorFactory.registerForProjectWithDeprecatedVariantApi(project, instrumentationFlagState);
            }
        } else {
            androidExt.registerTransform((Transform)new FirebasePerfTransform(instrumentationFlagState, (Provider<List<File>>)project.provider(() -> ((AppExtension)androidExt).getBootClasspath())), new Object[0]);
        }
    }

    private void registerExtension(AppExtension androidExt) {
        androidExt.getBuildTypes().all(buildType -> buildType.getExtensions().add(FIREBASE_PERF_EXTENSION_NAME, FirebasePerfExtension.class));
        androidExt.getProductFlavors().all(productFlavor -> productFlavor.getExtensions().add(FIREBASE_PERF_EXTENSION_NAME, FirebasePerfExtension.class));
    }

    public static String getPluginVersion() {
        return FirebasePerfPlugin.getPluginVersion(FirebasePerfPlugin.class.getClassLoader(), "com/google/firebase/perf/plugin/project.properties");
    }

    static String getPluginVersion(ClassLoader classLoader, String projectPropsResFile) {
        Properties properties = new Properties();
        if (classLoader != null) {
            try (BufferedInputStream stream = new BufferedInputStream(classLoader.getResourceAsStream(projectPropsResFile));){
                properties.load(stream);
            }
            catch (IOException e) {
                logger.warn(String.format("Could not load '%s' file.", projectPropsResFile), (Throwable)e);
            }
        }
        return properties.getProperty("pluginVersion", "unknown");
    }

    private boolean useNewAgpTransformApi() {
        try {
            return GradleVersion.parseAndroidGradlePluginVersion((String)Version.ANDROID_GRADLE_PLUGIN_VERSION).compareTo(GradleVersion.parseAndroidGradlePluginVersion((String)MINIMUM_SUPPORTED_AGP_VERSION_FOR_NEW_TRANSFORM_API)) >= 0;
        }
        catch (NoClassDefFoundError | NoSuchMethodError error) {
            return false;
        }
    }

    private boolean useNewVariantApi() {
        try {
            return GradleVersion.parseAndroidGradlePluginVersion((String)Version.ANDROID_GRADLE_PLUGIN_VERSION).compareTo(GradleVersion.parseAndroidGradlePluginVersion((String)AGP_NEW_VARIANT_API_VERSION)) >= 0;
        }
        catch (NoClassDefFoundError | NoSuchMethodError error) {
            return false;
        }
    }

    private boolean useInstrumentationApi() {
        try {
            return GradleVersion.parseAndroidGradlePluginVersion((String)Version.ANDROID_GRADLE_PLUGIN_VERSION).compareTo(GradleVersion.parseAndroidGradlePluginVersion((String)AGP_NEW_INSTRUMENTATION_API_VERSION)) >= 0;
        }
        catch (NoClassDefFoundError | NoSuchMethodError error) {
            return false;
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public static boolean getInstrumentFireperfE2ETest() {
        return instrumentFireperfE2ETest;
    }
}

