/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.builder.model.ProductFlavor;
import com.google.common.base.Ascii;
import com.google.firebase.perf.plugin.FirebasePerfExtension;
import com.google.firebase.perf.plugin.FirebasePerfPlugin;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.gradle.api.Project;
import org.slf4j.Logger;

public final class InstrumentationFlagState
implements Serializable {
    private static final Logger logger = FirebasePerfPlugin.getLogger();
    private static final boolean INSTRUMENTATION_ENABLED_DEFAULT = true;
    private final Optional<Boolean> parsedProjectPropertyValue;
    private final Map<String, Boolean> variantToInstrumentationEnabledMap = new HashMap<String, Boolean>();
    private final transient AppExtension androidExt;

    public InstrumentationFlagState(Project project) {
        this.androidExt = (AppExtension)project.getExtensions().getByType(AppExtension.class);
        this.parsedProjectPropertyValue = InstrumentationFlagState.fetchProjectPropertyValue(project);
        this.androidExt.getApplicationVariants().all(this::updateInstrumentationEnabledFor);
    }

    private static Optional<Boolean> fetchProjectPropertyValue(Project project) {
        String propKey = "firebasePerformanceInstrumentationEnabled";
        if (!project.hasProperty(propKey) || project.property(propKey) == null) {
            return Optional.empty();
        }
        String propVal = Objects.requireNonNull(project.property(propKey)).toString();
        Optional<Boolean> parsedPropVal = InstrumentationFlagState.parseBoolean(propVal);
        if (parsedPropVal.isPresent()) {
            return parsedPropVal;
        }
        throw new IllegalStateException(String.format("Could not get unknown value '%s' for the project property '%s' defined in the 'gradle.properties' file. Correct format is either '%s=false' or '%s=true'.", propVal, propKey, propKey, propKey));
    }

    private static Optional<Boolean> parseBoolean(String s) {
        if (s != null && (Ascii.equalsIgnoreCase((CharSequence)s, (CharSequence)"true") || Ascii.equalsIgnoreCase((CharSequence)s, (CharSequence)"false"))) {
            return Optional.of(Boolean.parseBoolean(s));
        }
        return Optional.empty();
    }

    private void updateInstrumentationEnabledFor(ApplicationVariant applicationVariant) {
        String variant = applicationVariant.getName();
        ArrayList<String> productFlavors = new ArrayList<String>();
        for (ProductFlavor flavor : applicationVariant.getProductFlavors()) {
            productFlavors.add(flavor.getName());
        }
        this.variantToInstrumentationEnabledMap.put(variant, this.instrumentationEnabledFor(variant, applicationVariant.getBuildType().getName(), productFlavors));
    }

    private boolean instrumentationEnabledFor(String variant, String buildType, List<String> flavors) {
        if (this.parsedProjectPropertyValue.isPresent()) {
            logger.info(String.format("Firebase Performance Instrumentation is %s per the Project Property specified in the 'gradle.properties' file.", this.parsedProjectPropertyValue.get() != false ? "enabled" : "disabled"));
            return this.parsedProjectPropertyValue.get();
        }
        Optional<Boolean> parsedBuildTypeVal = this.getBuildTypeExtensionValue(buildType);
        if (parsedBuildTypeVal.isPresent()) {
            logger.info(String.format("Firebase Performance Instrumentation is %s for %s variant per the Extension Property specified (for buildType=%s) in the 'build.gradle' file.", parsedBuildTypeVal.get() != false ? "enabled" : "disabled", variant, buildType));
            return parsedBuildTypeVal.get();
        }
        for (String flavor : flavors) {
            Optional<Boolean> parsedFlavorsVal = this.getProductFlavorExtensionValue(flavor);
            if (!parsedFlavorsVal.isPresent()) continue;
            logger.info(String.format("Firebase Performance Instrumentation is %s for %s variant per the Extension Property specified (for flavors=%s) in the 'build.gradle' file.", parsedFlavorsVal.get() != false ? "enabled" : "disabled", variant, flavors));
            return parsedFlavorsVal.get();
        }
        logger.info(String.format("Firebase Performance Instrumentation is %s by default for %s variant.", "enabled", variant));
        return true;
    }

    private Optional<Boolean> getBuildTypeExtensionValue(String buildType) {
        BuildType dslBuildType = (BuildType)this.androidExt.getBuildTypes().getByName(buildType);
        FirebasePerfExtension buildTypeExt = (FirebasePerfExtension)dslBuildType.getExtensions().getByType(FirebasePerfExtension.class);
        return buildTypeExt != null ? buildTypeExt.isInstrumentationEnabled() : Optional.empty();
    }

    private Optional<Boolean> getProductFlavorExtensionValue(String flavor) {
        com.android.build.gradle.internal.dsl.ProductFlavor dslFlavor = (com.android.build.gradle.internal.dsl.ProductFlavor)this.androidExt.getProductFlavors().getByName(flavor);
        FirebasePerfExtension flavorExt = (FirebasePerfExtension)dslFlavor.getExtensions().getByType(FirebasePerfExtension.class);
        return flavorExt != null ? flavorExt.isInstrumentationEnabled() : Optional.empty();
    }

    public Optional<Boolean> getProjectPropertyValue() {
        return this.parsedProjectPropertyValue;
    }

    public boolean isEnabledFor(String variant) {
        return this.variantToInstrumentationEnabledMap.getOrDefault(variant, true);
    }

    public boolean isEnabledFor(String variant, String buildType, List<String> flavors) {
        return this.instrumentationEnabledFor(variant, buildType, flavors);
    }

    public Map<String, Boolean> getVariantToInstrumentationEnabledMap() {
        return this.variantToInstrumentationEnabledMap;
    }
}

