/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin.instrumentation;

import com.android.build.api.instrumentation.ClassContext;
import com.android.build.api.instrumentation.ClassData;
import com.google.firebase.perf.plugin.instrumentation.InstrumentationConfigBase;
import com.google.firebase.perf.plugin.instrumentation.annotation.AnnotatedMethodInstrumentationConfig;
import com.google.firebase.perf.plugin.instrumentation.network.NetworkObjectInstrumentationConfig;
import com.google.firebase.perf.plugin.instrumentation.network.NetworkObjectInstrumentationFactory;
import java.util.List;
import javax.annotation.Nullable;
import org.objectweb.asm.Type;

public class ClassDataBasedInstrumentationConfig
extends InstrumentationConfigBase {
    private final ClassContext classContext;

    public ClassDataBasedInstrumentationConfig(ClassContext classContext, List<AnnotatedMethodInstrumentationConfig> annotatedMethodConfigs, List<NetworkObjectInstrumentationConfig> networkObjectConfigs) {
        super(annotatedMethodConfigs, networkObjectConfigs);
        this.classContext = classContext;
    }

    @Override
    @Nullable
    public NetworkObjectInstrumentationFactory getNetworkObjectInstrumentationFactory(String className, String methodName, String methodDesc) {
        Type classType = Type.getObjectType((String)className);
        if (classType.getSort() != 10) {
            return null;
        }
        ClassData classData = this.classContext.loadClassData(className.replace('/', '.'));
        if (classData == null) {
            return null;
        }
        for (NetworkObjectInstrumentationConfig networkObjectConfig : this.networkObjectConfigs) {
            Type networkClassType = Type.getObjectType((String)networkObjectConfig.getClassName());
            String networkClassName = networkClassType.getClassName();
            boolean isInstance = classData.getClassName().equals(networkClassName) || classData.getInterfaces().contains(networkClassName) || classData.getSuperClasses().contains(networkClassName);
            boolean methodMatch = networkObjectConfig.getMethodName().equals(methodName);
            boolean descMatch = networkObjectConfig.getMethodDesc().equals(methodDesc);
            if (!isInstance || !methodMatch || !descMatch) continue;
            return networkObjectConfig.getFactory();
        }
        return null;
    }
}

