/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin.instrumentation;

import com.google.firebase.perf.plugin.instrumentation.InstrumentationConfig;
import com.google.firebase.perf.plugin.instrumentation.annotation.AnnotatedMethodInstrumentationConfig;
import com.google.firebase.perf.plugin.instrumentation.annotation.AnnotatedMethodInstrumentationFactory;
import com.google.firebase.perf.plugin.instrumentation.network.NetworkObjectInstrumentationConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public abstract class InstrumentationConfigBase
implements InstrumentationConfig {
    protected final List<AnnotatedMethodInstrumentationConfig> annotatedMethodConfigs;
    protected final List<NetworkObjectInstrumentationConfig> networkObjectConfigs;

    public InstrumentationConfigBase(List<AnnotatedMethodInstrumentationConfig> annotatedMethodConfigs, List<NetworkObjectInstrumentationConfig> networkObjectConfigs) {
        this.annotatedMethodConfigs = Collections.unmodifiableList(annotatedMethodConfigs);
        this.networkObjectConfigs = Collections.unmodifiableList(networkObjectConfigs);
    }

    @Override
    @Nullable
    public List<AnnotatedMethodInstrumentationFactory> getAnnotatedMethodInstrumentationFactories(String classDesc) {
        ArrayList<AnnotatedMethodInstrumentationFactory> annotatedMethodFactoryList = null;
        for (AnnotatedMethodInstrumentationConfig annotatedMethodConfig : this.annotatedMethodConfigs) {
            if (!annotatedMethodConfig.getClassDesc().equals(classDesc)) continue;
            if (annotatedMethodFactoryList == null) {
                annotatedMethodFactoryList = new ArrayList<AnnotatedMethodInstrumentationFactory>();
            }
            annotatedMethodFactoryList.add(annotatedMethodConfig.getFactory());
        }
        return annotatedMethodFactoryList;
    }
}

