/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.docs;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.Content;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.MediaContent;
import com.google.gdata.data.Person;
import com.google.gdata.data.acl.AclFeed;
import com.google.gdata.data.docs.DocumentListAclFeedLink;
import com.google.gdata.data.docs.WritersCanInvite;
import com.google.gdata.data.extensions.Deleted;
import com.google.gdata.data.extensions.Labels;
import com.google.gdata.data.extensions.LastModifiedBy;
import com.google.gdata.data.extensions.LastViewed;
import com.google.gdata.data.extensions.QuotaBytesUsed;
import com.google.gdata.data.extensions.ResourceId;
import com.google.gdata.data.media.MediaEntry;
import com.google.gdata.data.media.MediaFileSource;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.common.base.StringUtil;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://schemas.google.com/docs/2007#unknown")
public class DocumentListEntry
extends MediaEntry<DocumentListEntry> {
    public static final String UNKNOWN_LABEL = "unknown";
    public static final String UNKNOWN_KIND = "http://schemas.google.com/docs/2007#unknown";
    public static final Category UNKNOWN_CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/docs/2007#unknown", "unknown");
    public static final String FOLDERS_NAMESPACE = "http://schemas.google.com/docs/2007/folders";
    public static final String PARENT_NAMESPACE = "http://schemas.google.com/docs/2007#parent";
    public static final String REVISIONS_NAMESPACE = "http://schemas.google.com/docs/2007/revisions";
    private static final Pattern FOLDER_PATTERN = Pattern.compile("^" + Pattern.quote("http://schemas.google.com/docs/2007/folders") + "(:?/[^/]+)?$");

    protected static String getMimeTypeFromFileName(String fileName) {
        return MediaType.fromFileName(fileName).getMimeType();
    }

    public DocumentListEntry() {
    }

    public DocumentListEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        super.declareExtensions(extProfile);
        extProfile.declare(DocumentListEntry.class, DocumentListAclFeedLink.class);
        extProfile.declare(DocumentListEntry.class, LastModifiedBy.class);
        extProfile.declare(DocumentListEntry.class, LastViewed.class);
        extProfile.declare(DocumentListEntry.class, QuotaBytesUsed.class);
        extProfile.declare(DocumentListEntry.class, ResourceId.class);
        extProfile.declare(DocumentListEntry.class, WritersCanInvite.class);
    }

    public Link getDocumentLink() {
        return super.getHtmlLink();
    }

    public String getKey() {
        int position;
        String result = this.state.id;
        if (result != null && (position = result.lastIndexOf("/")) > 0) {
            result = result.substring(position + 1);
        }
        return result;
    }

    @Deprecated
    public void setFile(File file) {
        this.setFile(file, DocumentListEntry.getMimeTypeFromFileName(file.getName()));
    }

    public void setFile(File file, String mimeType) {
        MediaFileSource fileSource = new MediaFileSource(file, mimeType);
        MediaContent content = new MediaContent();
        content.setMediaSource((MediaSource)fileSource);
        content.setMimeType(new ContentType(mimeType));
        this.setContent((Content)content);
    }

    public void setHidden(boolean hidden) {
        if (hidden) {
            this.getCategories().add(Labels.HIDDEN);
        } else {
            this.getCategories().remove(Labels.HIDDEN);
        }
    }

    public boolean isHidden() {
        return this.getCategories().contains(Labels.HIDDEN);
    }

    public void setStarred(boolean starred) {
        if (starred) {
            this.getCategories().add(Labels.STARRED);
        } else {
            this.getCategories().remove(Labels.STARRED);
        }
    }

    public boolean isStarred() {
        return this.getCategories().contains(Labels.STARRED);
    }

    public void setViewed(boolean viewed) {
        if (viewed) {
            this.getCategories().add(Labels.VIEWED);
        } else {
            this.getCategories().remove(Labels.VIEWED);
        }
    }

    public boolean isViewed() {
        return this.getCategories().contains(Labels.VIEWED);
    }

    public void setTrashed(boolean trashed) {
        if (trashed) {
            this.getCategories().add(Labels.TRASHED);
            this.setExtension((Extension)new Deleted());
        } else {
            this.getCategories().remove(Labels.TRASHED);
            this.removeExtension(Deleted.class);
        }
    }

    public boolean isTrashed() {
        return this.getCategories().contains(Labels.TRASHED) || this.hasExtension(Deleted.class);
    }

    public void addFolder(Person owner, String folderName) {
        String scheme = "http://schemas.google.com/docs/2007/folders/" + owner.getEmail();
        Category folderCategory = new Category(scheme, folderName, folderName);
        this.getCategories().add(folderCategory);
    }

    public Set<String> getFolders() {
        HashSet<String> folders = new HashSet<String>();
        for (Category category : this.getCategories()) {
            Matcher matcher = FOLDER_PATTERN.matcher(category.getScheme());
            if (!matcher.matches()) continue;
            String folderName = category.getLabel();
            if (StringUtil.isEmpty((String)folderName)) {
                folderName = category.getTerm();
            }
            folders.add(folderName);
        }
        return folders;
    }

    public DocumentListAclFeedLink getAclFeedLink() {
        List links = this.getRepeatingExtension(DocumentListAclFeedLink.class);
        for (DocumentListAclFeedLink feedLink : links) {
            if (!"http://schemas.google.com/acl/2007#accessControlList".equals(feedLink.getRel())) continue;
            return feedLink;
        }
        return null;
    }

    public AclFeed getAclFeed() {
        DocumentListAclFeedLink feedLink = this.getAclFeedLink();
        return feedLink != null ? (AclFeed)feedLink.getFeed() : null;
    }

    public List<Link> getParentLinks() {
        return this.getLinks(PARENT_NAMESPACE, ILink.Type.ATOM);
    }

    public DateTime getLastViewed() {
        LastViewed lastViewed = (LastViewed)this.getExtension(LastViewed.class);
        return lastViewed == null ? null : lastViewed.getValue();
    }

    public void setLastViewed(DateTime lastViewed) {
        if (lastViewed == null) {
            this.removeExtension(LastViewed.class);
        } else {
            this.setExtension((Extension)new LastViewed(lastViewed));
        }
    }

    public Long getQuotaBytesUsed() {
        QuotaBytesUsed quotaBytes = (QuotaBytesUsed)this.getExtension(QuotaBytesUsed.class);
        return quotaBytes == null ? null : quotaBytes.getValue();
    }

    public void setQuotaBytesUsed(Long quotaBytesUsed) {
        if (quotaBytesUsed == null) {
            this.removeExtension(QuotaBytesUsed.class);
        } else {
            this.setExtension((Extension)new QuotaBytesUsed(quotaBytesUsed));
        }
    }

    public Boolean isWritersCanInvite() {
        WritersCanInvite writersCanInvite = (WritersCanInvite)this.getExtension(WritersCanInvite.class);
        return writersCanInvite == null ? null : writersCanInvite.getValue();
    }

    public void setWritersCanInvite(Boolean writersCanInvite) {
        if (writersCanInvite == null) {
            this.removeExtension(WritersCanInvite.class);
        } else {
            this.setExtension((Extension)new WritersCanInvite(writersCanInvite));
        }
    }

    public LastModifiedBy getLastModifiedBy() {
        LastModifiedBy lastModifiedBy = (LastModifiedBy)this.getExtension(LastModifiedBy.class);
        return lastModifiedBy == null ? null : lastModifiedBy;
    }

    public void setLastModifiedBy(LastModifiedBy lastModifiedBy) {
        if (lastModifiedBy == null) {
            this.removeExtension(LastModifiedBy.class);
        } else {
            this.setExtension((Extension)lastModifiedBy);
        }
    }

    public String getResourceId() {
        ResourceId resourceId = (ResourceId)this.getExtension(ResourceId.class);
        return resourceId == null ? null : resourceId.getValue();
    }

    public void setResourceId(String resourceId) {
        if (resourceId == null) {
            this.removeExtension(ResourceId.class);
        } else {
            this.setExtension((Extension)new ResourceId(resourceId));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MediaType {
        JPG("image/jpeg"),
        JPEG("image/jpeg"),
        PNG("image/png"),
        BMP("image/bmp"),
        GIF("image/gif"),
        TXT("text/plain"),
        HTML("text/html"),
        HTM("text/html"),
        ODT("application/vnd.oasis.opendocument.text"),
        SXW("application/vnd.sun.xml.writer"),
        DOC("application/msword"),
        RTF("application/rtf"),
        PDF("application/pdf"),
        PPS("application/vnd.ms-powerpoint"),
        PPT("application/vnd.ms-powerpoint"),
        XLS("application/vnd.ms-excel"),
        ODS("application/x-vnd.oasis.opendocument.spreadsheet"),
        CSV("text/csv"),
        TAB("text/tab-separated-value"),
        TSV("text/tab-separated-value");

        private String mimeType;

        private MediaType(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public static MediaType fromFileName(String fileName) {
            int index = fileName.indexOf(46);
            if (index > 0) {
                return MediaType.valueOf(fileName.substring(index + 1).toUpperCase());
            }
            return MediaType.valueOf(fileName);
        }
    }
}

