package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CreateTuningJobConfig extends CreateTuningJobConfig {

  private final Optional<HttpOptions> httpOptions;

  private final Optional<TuningValidationDataset> validationDataset;

  private final Optional<String> tunedModelDisplayName;

  private final Optional<String> description;

  private final Optional<Integer> epochCount;

  private final Optional<Float> learningRateMultiplier;

  private final Optional<Boolean> exportLastCheckpointOnly;

  private final Optional<String> preTunedModelCheckpointId;

  private final Optional<AdapterSize> adapterSize;

  private final Optional<Integer> batchSize;

  private final Optional<Float> learningRate;

  private final Optional<Map<String, String>> labels;

  private AutoValue_CreateTuningJobConfig(
      Optional<HttpOptions> httpOptions,
      Optional<TuningValidationDataset> validationDataset,
      Optional<String> tunedModelDisplayName,
      Optional<String> description,
      Optional<Integer> epochCount,
      Optional<Float> learningRateMultiplier,
      Optional<Boolean> exportLastCheckpointOnly,
      Optional<String> preTunedModelCheckpointId,
      Optional<AdapterSize> adapterSize,
      Optional<Integer> batchSize,
      Optional<Float> learningRate,
      Optional<Map<String, String>> labels) {
    this.httpOptions = httpOptions;
    this.validationDataset = validationDataset;
    this.tunedModelDisplayName = tunedModelDisplayName;
    this.description = description;
    this.epochCount = epochCount;
    this.learningRateMultiplier = learningRateMultiplier;
    this.exportLastCheckpointOnly = exportLastCheckpointOnly;
    this.preTunedModelCheckpointId = preTunedModelCheckpointId;
    this.adapterSize = adapterSize;
    this.batchSize = batchSize;
    this.learningRate = learningRate;
    this.labels = labels;
  }

  @JsonProperty("httpOptions")
  @Override
  public Optional<HttpOptions> httpOptions() {
    return httpOptions;
  }

  @JsonProperty("validationDataset")
  @Override
  public Optional<TuningValidationDataset> validationDataset() {
    return validationDataset;
  }

  @JsonProperty("tunedModelDisplayName")
  @Override
  public Optional<String> tunedModelDisplayName() {
    return tunedModelDisplayName;
  }

  @JsonProperty("description")
  @Override
  public Optional<String> description() {
    return description;
  }

  @JsonProperty("epochCount")
  @Override
  public Optional<Integer> epochCount() {
    return epochCount;
  }

  @JsonProperty("learningRateMultiplier")
  @Override
  public Optional<Float> learningRateMultiplier() {
    return learningRateMultiplier;
  }

  @JsonProperty("exportLastCheckpointOnly")
  @Override
  public Optional<Boolean> exportLastCheckpointOnly() {
    return exportLastCheckpointOnly;
  }

  @JsonProperty("preTunedModelCheckpointId")
  @Override
  public Optional<String> preTunedModelCheckpointId() {
    return preTunedModelCheckpointId;
  }

  @JsonProperty("adapterSize")
  @Override
  public Optional<AdapterSize> adapterSize() {
    return adapterSize;
  }

  @JsonProperty("batchSize")
  @Override
  public Optional<Integer> batchSize() {
    return batchSize;
  }

  @JsonProperty("learningRate")
  @Override
  public Optional<Float> learningRate() {
    return learningRate;
  }

  @JsonProperty("labels")
  @Override
  public Optional<Map<String, String>> labels() {
    return labels;
  }

  @Override
  public String toString() {
    return "CreateTuningJobConfig{"
        + "httpOptions=" + httpOptions + ", "
        + "validationDataset=" + validationDataset + ", "
        + "tunedModelDisplayName=" + tunedModelDisplayName + ", "
        + "description=" + description + ", "
        + "epochCount=" + epochCount + ", "
        + "learningRateMultiplier=" + learningRateMultiplier + ", "
        + "exportLastCheckpointOnly=" + exportLastCheckpointOnly + ", "
        + "preTunedModelCheckpointId=" + preTunedModelCheckpointId + ", "
        + "adapterSize=" + adapterSize + ", "
        + "batchSize=" + batchSize + ", "
        + "learningRate=" + learningRate + ", "
        + "labels=" + labels
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CreateTuningJobConfig) {
      CreateTuningJobConfig that = (CreateTuningJobConfig) o;
      return this.httpOptions.equals(that.httpOptions())
          && this.validationDataset.equals(that.validationDataset())
          && this.tunedModelDisplayName.equals(that.tunedModelDisplayName())
          && this.description.equals(that.description())
          && this.epochCount.equals(that.epochCount())
          && this.learningRateMultiplier.equals(that.learningRateMultiplier())
          && this.exportLastCheckpointOnly.equals(that.exportLastCheckpointOnly())
          && this.preTunedModelCheckpointId.equals(that.preTunedModelCheckpointId())
          && this.adapterSize.equals(that.adapterSize())
          && this.batchSize.equals(that.batchSize())
          && this.learningRate.equals(that.learningRate())
          && this.labels.equals(that.labels());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= httpOptions.hashCode();
    h$ *= 1000003;
    h$ ^= validationDataset.hashCode();
    h$ *= 1000003;
    h$ ^= tunedModelDisplayName.hashCode();
    h$ *= 1000003;
    h$ ^= description.hashCode();
    h$ *= 1000003;
    h$ ^= epochCount.hashCode();
    h$ *= 1000003;
    h$ ^= learningRateMultiplier.hashCode();
    h$ *= 1000003;
    h$ ^= exportLastCheckpointOnly.hashCode();
    h$ *= 1000003;
    h$ ^= preTunedModelCheckpointId.hashCode();
    h$ *= 1000003;
    h$ ^= adapterSize.hashCode();
    h$ *= 1000003;
    h$ ^= batchSize.hashCode();
    h$ *= 1000003;
    h$ ^= learningRate.hashCode();
    h$ *= 1000003;
    h$ ^= labels.hashCode();
    return h$;
  }

  @Override
  public CreateTuningJobConfig.Builder toBuilder() {
    return new AutoValue_CreateTuningJobConfig.Builder(this);
  }

  static final class Builder extends CreateTuningJobConfig.Builder {
    private Optional<HttpOptions> httpOptions = Optional.empty();
    private Optional<TuningValidationDataset> validationDataset = Optional.empty();
    private Optional<String> tunedModelDisplayName = Optional.empty();
    private Optional<String> description = Optional.empty();
    private Optional<Integer> epochCount = Optional.empty();
    private Optional<Float> learningRateMultiplier = Optional.empty();
    private Optional<Boolean> exportLastCheckpointOnly = Optional.empty();
    private Optional<String> preTunedModelCheckpointId = Optional.empty();
    private Optional<AdapterSize> adapterSize = Optional.empty();
    private Optional<Integer> batchSize = Optional.empty();
    private Optional<Float> learningRate = Optional.empty();
    private Optional<Map<String, String>> labels = Optional.empty();
    Builder() {
    }
    Builder(CreateTuningJobConfig source) {
      this.httpOptions = source.httpOptions();
      this.validationDataset = source.validationDataset();
      this.tunedModelDisplayName = source.tunedModelDisplayName();
      this.description = source.description();
      this.epochCount = source.epochCount();
      this.learningRateMultiplier = source.learningRateMultiplier();
      this.exportLastCheckpointOnly = source.exportLastCheckpointOnly();
      this.preTunedModelCheckpointId = source.preTunedModelCheckpointId();
      this.adapterSize = source.adapterSize();
      this.batchSize = source.batchSize();
      this.learningRate = source.learningRate();
      this.labels = source.labels();
    }
    @Override
    public CreateTuningJobConfig.Builder httpOptions(HttpOptions httpOptions) {
      this.httpOptions = Optional.of(httpOptions);
      return this;
    }
    @Override
    public CreateTuningJobConfig.Builder validationDataset(TuningValidationDataset validationDataset) {
      this.validationDataset = Optional.of(validationDataset);
      return this;
    }
    @Override
    public CreateTuningJobConfig.Builder tunedModelDisplayName(String tunedModelDisplayName) {
      this.tunedModelDisplayName = Optional.of(tunedModelDisplayName);
      return this;
    }
    @Override
    public CreateTuningJobConfig.Builder description(String description) {
      this.description = Optional.of(description);
      return this;
    }
    @Override
    public CreateTuningJobConfig.Builder epochCount(Integer epochCount) {
      this.epochCount = Optional.of(epochCount);
      return this;
    }
    @Override
    public CreateTuningJobConfig.Builder learningRateMultiplier(Float learningRateMultiplier) {
      this.learningRateMultiplier = Optional.of(learningRateMultiplier);
      return this;
    }
    @Override
    public CreateTuningJobConfig.Builder exportLastCheckpointOnly(boolean exportLastCheckpointOnly) {
      this.exportLastCheckpointOnly = Optional.of(exportLastCheckpointOnly);
      return this;
    }
    @Override
    public CreateTuningJobConfig.Builder preTunedModelCheckpointId(String preTunedModelCheckpointId) {
      this.preTunedModelCheckpointId = Optional.of(preTunedModelCheckpointId);
      return this;
    }
    @Override
    public CreateTuningJobConfig.Builder adapterSize(AdapterSize adapterSize) {
      this.adapterSize = Optional.of(adapterSize);
      return this;
    }
    @Override
    public CreateTuningJobConfig.Builder batchSize(Integer batchSize) {
      this.batchSize = Optional.of(batchSize);
      return this;
    }
    @Override
    public CreateTuningJobConfig.Builder learningRate(Float learningRate) {
      this.learningRate = Optional.of(learningRate);
      return this;
    }
    @Override
    public CreateTuningJobConfig.Builder labels(Map<String, String> labels) {
      this.labels = Optional.of(labels);
      return this;
    }
    @Override
    public CreateTuningJobConfig build() {
      return new AutoValue_CreateTuningJobConfig(
          this.httpOptions,
          this.validationDataset,
          this.tunedModelDisplayName,
          this.description,
          this.epochCount,
          this.learningRateMultiplier,
          this.exportLastCheckpointOnly,
          this.preTunedModelCheckpointId,
          this.adapterSize,
          this.batchSize,
          this.learningRate,
          this.labels);
    }
  }

}
