package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SafetySetting extends SafetySetting {

  private final Optional<HarmBlockMethod> method;

  private final Optional<HarmCategory> category;

  private final Optional<HarmBlockThreshold> threshold;

  private AutoValue_SafetySetting(
      Optional<HarmBlockMethod> method,
      Optional<HarmCategory> category,
      Optional<HarmBlockThreshold> threshold) {
    this.method = method;
    this.category = category;
    this.threshold = threshold;
  }

  @JsonProperty("method")
  @Override
  public Optional<HarmBlockMethod> method() {
    return method;
  }

  @JsonProperty("category")
  @Override
  public Optional<HarmCategory> category() {
    return category;
  }

  @JsonProperty("threshold")
  @Override
  public Optional<HarmBlockThreshold> threshold() {
    return threshold;
  }

  @Override
  public String toString() {
    return "SafetySetting{"
        + "method=" + method + ", "
        + "category=" + category + ", "
        + "threshold=" + threshold
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SafetySetting) {
      SafetySetting that = (SafetySetting) o;
      return this.method.equals(that.method())
          && this.category.equals(that.category())
          && this.threshold.equals(that.threshold());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= method.hashCode();
    h$ *= 1000003;
    h$ ^= category.hashCode();
    h$ *= 1000003;
    h$ ^= threshold.hashCode();
    return h$;
  }

  @Override
  public SafetySetting.Builder toBuilder() {
    return new AutoValue_SafetySetting.Builder(this);
  }

  static final class Builder extends SafetySetting.Builder {
    private Optional<HarmBlockMethod> method = Optional.empty();
    private Optional<HarmCategory> category = Optional.empty();
    private Optional<HarmBlockThreshold> threshold = Optional.empty();
    Builder() {
    }
    Builder(SafetySetting source) {
      this.method = source.method();
      this.category = source.category();
      this.threshold = source.threshold();
    }
    @Override
    public SafetySetting.Builder method(HarmBlockMethod method) {
      this.method = Optional.of(method);
      return this;
    }
    @Override
    public SafetySetting.Builder category(HarmCategory category) {
      this.category = Optional.of(category);
      return this;
    }
    @Override
    public SafetySetting.Builder threshold(HarmBlockThreshold threshold) {
      this.threshold = Optional.of(threshold);
      return this;
    }
    @Override
    public SafetySetting build() {
      return new AutoValue_SafetySetting(
          this.method,
          this.category,
          this.threshold);
    }
  }

}
