package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_UpscaleImageConfig extends UpscaleImageConfig {

  private final Optional<HttpOptions> httpOptions;

  private final Optional<String> outputGcsUri;

  private final Optional<Boolean> includeRaiReason;

  private final Optional<String> outputMimeType;

  private final Optional<Integer> outputCompressionQuality;

  private final Optional<Boolean> enhanceInputImage;

  private final Optional<Float> imagePreservationFactor;

  private AutoValue_UpscaleImageConfig(
      Optional<HttpOptions> httpOptions,
      Optional<String> outputGcsUri,
      Optional<Boolean> includeRaiReason,
      Optional<String> outputMimeType,
      Optional<Integer> outputCompressionQuality,
      Optional<Boolean> enhanceInputImage,
      Optional<Float> imagePreservationFactor) {
    this.httpOptions = httpOptions;
    this.outputGcsUri = outputGcsUri;
    this.includeRaiReason = includeRaiReason;
    this.outputMimeType = outputMimeType;
    this.outputCompressionQuality = outputCompressionQuality;
    this.enhanceInputImage = enhanceInputImage;
    this.imagePreservationFactor = imagePreservationFactor;
  }

  @JsonProperty("httpOptions")
  @Override
  public Optional<HttpOptions> httpOptions() {
    return httpOptions;
  }

  @JsonProperty("outputGcsUri")
  @Override
  public Optional<String> outputGcsUri() {
    return outputGcsUri;
  }

  @JsonProperty("includeRaiReason")
  @Override
  public Optional<Boolean> includeRaiReason() {
    return includeRaiReason;
  }

  @JsonProperty("outputMimeType")
  @Override
  public Optional<String> outputMimeType() {
    return outputMimeType;
  }

  @JsonProperty("outputCompressionQuality")
  @Override
  public Optional<Integer> outputCompressionQuality() {
    return outputCompressionQuality;
  }

  @JsonProperty("enhanceInputImage")
  @Override
  public Optional<Boolean> enhanceInputImage() {
    return enhanceInputImage;
  }

  @JsonProperty("imagePreservationFactor")
  @Override
  public Optional<Float> imagePreservationFactor() {
    return imagePreservationFactor;
  }

  @Override
  public String toString() {
    return "UpscaleImageConfig{"
        + "httpOptions=" + httpOptions + ", "
        + "outputGcsUri=" + outputGcsUri + ", "
        + "includeRaiReason=" + includeRaiReason + ", "
        + "outputMimeType=" + outputMimeType + ", "
        + "outputCompressionQuality=" + outputCompressionQuality + ", "
        + "enhanceInputImage=" + enhanceInputImage + ", "
        + "imagePreservationFactor=" + imagePreservationFactor
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof UpscaleImageConfig) {
      UpscaleImageConfig that = (UpscaleImageConfig) o;
      return this.httpOptions.equals(that.httpOptions())
          && this.outputGcsUri.equals(that.outputGcsUri())
          && this.includeRaiReason.equals(that.includeRaiReason())
          && this.outputMimeType.equals(that.outputMimeType())
          && this.outputCompressionQuality.equals(that.outputCompressionQuality())
          && this.enhanceInputImage.equals(that.enhanceInputImage())
          && this.imagePreservationFactor.equals(that.imagePreservationFactor());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= httpOptions.hashCode();
    h$ *= 1000003;
    h$ ^= outputGcsUri.hashCode();
    h$ *= 1000003;
    h$ ^= includeRaiReason.hashCode();
    h$ *= 1000003;
    h$ ^= outputMimeType.hashCode();
    h$ *= 1000003;
    h$ ^= outputCompressionQuality.hashCode();
    h$ *= 1000003;
    h$ ^= enhanceInputImage.hashCode();
    h$ *= 1000003;
    h$ ^= imagePreservationFactor.hashCode();
    return h$;
  }

  @Override
  public UpscaleImageConfig.Builder toBuilder() {
    return new AutoValue_UpscaleImageConfig.Builder(this);
  }

  static final class Builder extends UpscaleImageConfig.Builder {
    private Optional<HttpOptions> httpOptions = Optional.empty();
    private Optional<String> outputGcsUri = Optional.empty();
    private Optional<Boolean> includeRaiReason = Optional.empty();
    private Optional<String> outputMimeType = Optional.empty();
    private Optional<Integer> outputCompressionQuality = Optional.empty();
    private Optional<Boolean> enhanceInputImage = Optional.empty();
    private Optional<Float> imagePreservationFactor = Optional.empty();
    Builder() {
    }
    Builder(UpscaleImageConfig source) {
      this.httpOptions = source.httpOptions();
      this.outputGcsUri = source.outputGcsUri();
      this.includeRaiReason = source.includeRaiReason();
      this.outputMimeType = source.outputMimeType();
      this.outputCompressionQuality = source.outputCompressionQuality();
      this.enhanceInputImage = source.enhanceInputImage();
      this.imagePreservationFactor = source.imagePreservationFactor();
    }
    @Override
    public UpscaleImageConfig.Builder httpOptions(HttpOptions httpOptions) {
      this.httpOptions = Optional.of(httpOptions);
      return this;
    }
    @Override
    public UpscaleImageConfig.Builder outputGcsUri(String outputGcsUri) {
      this.outputGcsUri = Optional.of(outputGcsUri);
      return this;
    }
    @Override
    public UpscaleImageConfig.Builder includeRaiReason(boolean includeRaiReason) {
      this.includeRaiReason = Optional.of(includeRaiReason);
      return this;
    }
    @Override
    public UpscaleImageConfig.Builder outputMimeType(String outputMimeType) {
      this.outputMimeType = Optional.of(outputMimeType);
      return this;
    }
    @Override
    public UpscaleImageConfig.Builder outputCompressionQuality(Integer outputCompressionQuality) {
      this.outputCompressionQuality = Optional.of(outputCompressionQuality);
      return this;
    }
    @Override
    public UpscaleImageConfig.Builder enhanceInputImage(boolean enhanceInputImage) {
      this.enhanceInputImage = Optional.of(enhanceInputImage);
      return this;
    }
    @Override
    public UpscaleImageConfig.Builder imagePreservationFactor(Float imagePreservationFactor) {
      this.imagePreservationFactor = Optional.of(imagePreservationFactor);
      return this;
    }
    @Override
    public UpscaleImageConfig build() {
      return new AutoValue_UpscaleImageConfig(
          this.httpOptions,
          this.outputGcsUri,
          this.includeRaiReason,
          this.outputMimeType,
          this.outputCompressionQuality,
          this.enhanceInputImage,
          this.imagePreservationFactor);
    }
  }

}
